/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster;

import com.day.crx.cluster.ClusterController;
import com.day.crx.cluster.Connection;
import com.day.crx.cluster.ElectionListener;
import com.day.crx.cluster.TransportHandler;
import com.day.crx.cluster.TransportHandlerContext;
import com.day.crx.persistence.tar.TarUtils;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMasterElection {
    private static final int DEF_CONNECT_TIMEOUT = 2000;
    private static final int DEF_INBOUND_SO_TIMEOUT = 600000;
    private static final int DEF_OUTBOUND_SO_TIMEOUT = 0;
    private static Logger log = LoggerFactory.getLogger(AbstractMasterElection.class);
    protected static final String LISTENER_PROPERTIES = "listener.properties";
    protected static final String PN_ADDRESS = "address";
    protected static final String PN_CHECK = "check";
    protected static final String VERSION = "1.01";
    protected final File controlFolder;
    protected final String identity;
    protected final String host;
    protected final int port;
    protected final int[] candidatePorts;
    protected final TransportHandler handler;
    protected final TransportHandlerContext context;
    protected boolean isMaster;
    protected String checkKey;
    protected File controlFile;
    protected File identityFile;
    protected String listenerAddress;
    protected Listener listener;
    protected Connection connection;
    private final HashSet<ElectionListener> electionListeners = new HashSet();
    private int connectTimeout = 2000;
    private int inboundSocketTimeout = 600000;
    private InetAddress bindAddress;
    private Properties properties = new Properties();

    public AbstractMasterElection(String controlPath, String identity, String host, int port, int[] candidatePorts, TransportHandler handler, TransportHandlerContext context) throws IOException {
        this.controlFolder = new File(controlPath);
        this.identity = identity;
        this.host = host;
        this.port = port;
        this.candidatePorts = candidatePorts;
        this.handler = handler;
        this.context = context;
        TarUtils.createDirectory(this.controlFolder.getPath());
        this.controlFile = new File(this.controlFolder, LISTENER_PROPERTIES);
        this.identityFile = this.getIdentityFile(identity);
        TarUtils.createFile(this.identityFile.getPath());
        this.loadProperties();
    }

    public static boolean isControlFolder(File folder) {
        if (!folder.isDirectory()) {
            return false;
        }
        File listenerProps = new File(folder, LISTENER_PROPERTIES);
        return listenerProps.exists() && listenerProps.isFile();
    }

    public File getControlFolder() {
        return this.controlFolder;
    }

    public File getIdentityFile(String identity) {
        return new File(this.controlFolder, identity);
    }

    public synchronized void elect() throws IOException {
        this.elect(false);
    }

    public synchronized void elect(boolean becomeMaster) throws IOException {
        this.notifyElectionStarted(this.isMaster);
        this.reset();
        log.info("Election started.");
        this.doElect(becomeMaster);
        log.info("Election ended: " + (this.isMaster ? "master" : "slave"));
        this.notifyElectionEnded(this.isMaster);
        if (this.isMaster) {
            this.startListener();
        } else if (this.listener != null) {
            this.listener.stop();
            this.listener = null;
        }
    }

    private void reset() {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        if (this.listener != null) {
            this.listener.stop();
            this.listener = null;
        }
    }

    protected abstract void doElect(boolean var1) throws IOException;

    public boolean isMaster() throws IOException {
        return this.isMaster;
    }

    public boolean masterOvertaken() {
        return false;
    }

    public boolean checkKey(String key) {
        return this.checkKey.equals(key);
    }

    public boolean checkIdentity(String identity) {
        File f = this.getIdentityFile(identity);
        return f.exists() && f.isFile();
    }

    public synchronized Connection getConnection() throws IOException {
        if (this.connection == null) {
            this.connection = this.createConnection(this.isMaster);
        }
        return this.connection;
    }

    public void close() {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        if (this.listener != null) {
            this.listener.stop();
            this.listener = null;
        }
        this.identityFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties readControlFile() {
        Properties properties;
        if (!this.controlFile.exists()) {
            return null;
        }
        FileInputStream in = null;
        try {
            Properties prop = new Properties();
            in = new FileInputStream(this.controlFile);
            prop.load(in);
            properties = prop;
        }
        catch (IOException e) {
            Properties properties2;
            try {
                log.warn("Error reading from file " + this.controlFile + " " + e, (Throwable)e);
                properties2 = null;
            }
            catch (Throwable throwable) {
                TarUtils.closeSilently(in);
                throw throwable;
            }
            TarUtils.closeSilently(in);
            return properties2;
        }
        TarUtils.closeSilently(in);
        return properties;
    }

    protected boolean tryConnect() throws IOException {
        try {
            this.connection = this.createConnection(false);
            return true;
        }
        catch (ConnectException e) {
            log.debug("Error trying to connect to " + this.listenerAddress, (Throwable)e);
        }
        catch (NoRouteToHostException e) {
            log.debug("Error trying to connect to " + this.listenerAddress, (Throwable)e);
        }
        catch (SocketException e) {
            log.debug("Error trying to connect to " + this.listenerAddress, (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            log.debug("Error trying to connect to " + this.listenerAddress, (Throwable)e);
        }
        return false;
    }

    private Socket socketConnect() throws IOException {
        String address;
        IOException last = null;
        String listenerAddress = this.listenerAddress;
        int idx = listenerAddress.lastIndexOf(58);
        String s = listenerAddress.substring(idx + 1);
        int port = this.port;
        if (port == 0) {
            port = Integer.parseInt(s);
        }
        if ((address = this.host) == null) {
            address = listenerAddress.substring(0, idx);
        }
        String[] addresses = address.split(",");
        for (int i = 0; i < addresses.length; ++i) {
            String addr = addresses[i];
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(InetAddress.getByName(addr), port), 2000);
                return socket;
            }
            catch (IOException e) {
                last = e;
                continue;
            }
        }
        if (last == null) {
            String msg = "No connection available to: " + listenerAddress;
            last = new IOException(msg);
        }
        throw last;
    }

    protected void createListener() throws IOException {
        if (this.listener == null) {
            StringBuffer buff = new StringBuffer();
            if (this.bindAddress != null) {
                buff.append(this.bindAddress.getHostAddress());
            }
            if (this.bindAddress == null || !this.bindAddress.isLoopbackAddress()) {
                InetAddress local = InetAddress.getLocalHost();
                InetAddress[] list = InetAddress.getAllByName(local.getHostAddress());
                for (int i = 0; i < list.length; ++i) {
                    if (buff.length() > 0) {
                        buff.append(",");
                    }
                    buff.append(list[i].getHostAddress());
                }
            }
            ServerSocket socket = ClusterController.openServerSocket(this.candidatePorts, this.bindAddress);
            this.listener = new Listener(socket);
            this.listenerAddress = buff.toString() + ":" + socket.getLocalPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection createConnection(boolean isLocal) throws IOException {
        Socket socket = null;
        try {
            socket = this.socketConnect();
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(this.connectTimeout);
            Connection connection = this.handler.createConnection(socket);
            this.context.login(connection, this.checkKey, this.identity, isLocal);
            socket.setSoTimeout(0);
            socket = null;
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            if (socket != null) {
                TarUtils.closeSilently(socket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveListenerAddress(File destination) throws IOException {
        Properties prop = new Properties();
        prop.setProperty(PN_ADDRESS, this.listenerAddress);
        this.checkKey = "1.01-" + Math.random();
        prop.setProperty(PN_CHECK, this.checkKey);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(destination);
            prop.store(out, this.getClass().getName());
        }
        catch (Throwable throwable) {
            TarUtils.closeSilently(out);
            throw throwable;
        }
        TarUtils.closeSilently(out);
    }

    protected void startListener() {
        Thread t = new Thread(this.listener);
        t.setName("Listener " + this.listener.getName());
        t.setDaemon(true);
        t.start();
    }

    public void addListener(ElectionListener listener) {
        this.electionListeners.add(listener);
    }

    public void notifyElectionStarted(boolean isMaster) {
        for (ElectionListener listener : this.electionListeners) {
            listener.electionStarted(isMaster);
        }
    }

    public void notifyElectionEnded(boolean isMaster) {
        for (ElectionListener listener : this.electionListeners) {
            listener.electionEnded(isMaster);
        }
    }

    public void removeListener(ElectionListener listener) {
        this.electionListeners.remove(listener);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.inboundSocketTimeout = socketTimeout;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() throws IOException {
        FileInputStream in = new FileInputStream(this.identityFile);
        try {
            this.properties.load(in);
        }
        finally {
            in.close();
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        Object old = this.properties.setProperty(key, value);
        if (!value.equals(old)) {
            try {
                this.saveProperties();
            }
            catch (IOException e) {
                String msg = "Unable to save properties in: " + this.identityFile.getPath();
                log.warn(msg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveProperties() throws IOException {
        FileOutputStream out = new FileOutputStream(this.identityFile);
        try {
            this.properties.store(out, null);
        }
        finally {
            out.close();
        }
    }

    private class Processor
    implements Runnable {
        private final Listener listener;
        private final String name;
        private Socket socket;
        private boolean stopped;
        private InputStream in;
        private OutputStream out;

        Processor(Listener listener, Socket socket) {
            this.listener = listener;
            this.socket = socket;
            this.name = socket.getRemoteSocketAddress().toString();
        }

        public String getName() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.socket.setSoTimeout(AbstractMasterElection.this.inboundSocketTimeout);
                this.socket.setTcpNoDelay(true);
                this.in = this.socket.getInputStream();
                this.out = this.socket.getOutputStream();
                AbstractMasterElection.this.handler.process(this.in, this.out);
            }
            catch (SocketTimeoutException e) {
                log.info("Connection timed out.");
            }
            catch (EOFException e) {
                log.info("EOF encountered.");
            }
            catch (IOException e) {
                if (!this.isStopped()) {
                    log.warn("IO exception: " + e, (Throwable)e);
                }
            }
            finally {
                if (!this.isStopped()) {
                    this.shutdown();
                    this.listener.finished(this);
                }
            }
        }

        public synchronized boolean isStopped() {
            return this.stopped;
        }

        public synchronized void stop() {
            if (!this.isStopped()) {
                log.info("Stopping processor: " + this.getName());
                this.stopped = true;
                this.shutdown();
            }
        }

        private synchronized void shutdown() {
            this.out = TarUtils.closeSilently(this.out);
            this.in = TarUtils.closeSilently(this.in);
            this.socket = TarUtils.closeSilently(this.socket);
        }
    }

    private class Listener
    implements Runnable {
        private ServerSocket server;
        private final HashSet<Processor> processors = new HashSet();
        private boolean stopped;
        private final String name;

        Listener(ServerSocket server) {
            this.server = server;
            this.name = server.getLocalSocketAddress().toString();
        }

        public String getName() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    while (true) {
                        Socket client = this.server.accept();
                        Listener listener = this;
                        synchronized (listener) {
                            Processor processor = new Processor(this, client);
                            this.processors.add(processor);
                            Thread t = new Thread(processor);
                            t.setName("Processor " + processor.getName());
                            t.setDaemon(true);
                            t.start();
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.isStopped()) {
                        log.warn("Error in listener", (Throwable)e);
                    }
                    return;
                }
            }
            finally {
                this.shutdown();
            }
        }

        public synchronized boolean isStopped() {
            return this.stopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(Processor processor) {
            Listener listener = this;
            synchronized (listener) {
                this.processors.remove(processor);
            }
        }

        public synchronized void stop() {
            this.stopped = true;
            this.shutdown();
        }

        private synchronized void shutdown() {
            this.server = TarUtils.closeSilently(this.server);
            Processor[] p = new Processor[this.processors.size()];
            this.processors.toArray(p);
            for (int i = 0; i < p.length; ++i) {
                p[i].stop();
            }
        }
    }
}

