/*
 * Decompiled with CFR 0.152.
 */
package com.day.text;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUtils {
    private static final Logger log = LoggerFactory.getLogger((Class)TextUtils.class);

    public static String removeControlCharacters(String characters) {
        log.debug("Starting removeControlCharacters (characters : " + characters + " , " + ")");
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < characters.length(); ++i) {
            char c = characters.charAt(i);
            if (c < ' ' || c == '\u007f') continue;
            result.append(c);
        }
        return result.toString();
    }

    public static String removeWhitespace(String characters) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < characters.length(); ++i) {
            char c = characters.charAt(i);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') continue;
            result.append(c);
        }
        return result.toString();
    }

    public static boolean isTextSimilar(String docOne, String docTwo) {
        String sortedOne = TextUtils.stripSortedWhitespace(TextUtils.sortString(TextUtils.convertWhitespaceToSpaces(docOne.toLowerCase())));
        String sortedTwo = TextUtils.stripSortedWhitespace(TextUtils.sortString(TextUtils.convertWhitespaceToSpaces(docTwo.toLowerCase())));
        return sortedOne.equals(sortedTwo);
    }

    public static boolean noisyIsTextSimilar(String docOne, String docTwo) {
        String sortedOne = TextUtils.stripSortedWhitespace(TextUtils.sortString(TextUtils.convertWhitespaceToSpaces(docOne.toLowerCase())));
        String sortedTwo = TextUtils.stripSortedWhitespace(TextUtils.sortString(TextUtils.convertWhitespaceToSpaces(docTwo.toLowerCase())));
        System.out.println("Comparing  :" + sortedOne);
        System.out.println("Compare to :" + sortedTwo);
        return sortedOne.equals(sortedTwo);
    }

    private static String convertWhitespaceToSpaces(String s) {
        s = s.replace('\t', ' ');
        s = s.replace('\n', ' ');
        s = s.replace('\r', ' ');
        return s;
    }

    protected static String stripSortedWhitespace(String s) {
        String first = s.substring(0, s.indexOf(32));
        String last = s.substring(s.lastIndexOf(32) + 1);
        return first + last;
    }

    protected static String sortString(String in) {
        char[] characters = in.toCharArray();
        Arrays.sort(characters);
        return new String(characters);
    }

    public String stripWhitespace(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            out.append(s.charAt(i));
        }
        return out.toString();
    }

    public static String sanitizeForCommunique(String s) {
        log.debug("Starting sanitizeForCommunique (s : " + s + " , " + ")");
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' || c == '\n' || c == '\r' || c == '\t' || c == '\\') {
                out.append("\\");
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String replace(String allOfTheText, String toFind, String toReplace) {
        log.debug("Starting replace (allOfTheText : " + allOfTheText + " , " + "toFind : " + toFind + " , " + "toReplace : " + toReplace + " , " + ")");
        StringBuffer dest = new StringBuffer();
        int nextFound = allOfTheText.indexOf(toFind, 0);
        int lastFound = 0;
        if (nextFound == -1) {
            return allOfTheText;
        }
        do {
            dest.append(allOfTheText.substring(lastFound, nextFound));
            dest.append(toReplace);
        } while ((nextFound = allOfTheText.indexOf(toFind, lastFound = nextFound + toFind.length())) != -1);
        dest.append(allOfTheText.substring(lastFound));
        return dest.toString();
    }

    public static String trimTrailingSlashes(String input) {
        log.debug("Starting trimTrailingSlashes (input : " + input + " , " + ")");
        while (input.endsWith("/")) {
            input = input.substring(0, input.length() - 1);
        }
        return input;
    }

    public static String trimLeadingSlashes(String input) {
        log.debug("Starting trimLeadingSlashes (input : " + input + " , " + ")");
        while (input.startsWith("/")) {
            input = input.substring(1);
        }
        return input;
    }

    public static boolean occursOnceOnly(String big, String small) {
        return TextUtils.occursExactlyNTimes(big, small, 1);
    }

    public static boolean occursExactlyNTimes(String big, String small, int n) {
        try {
            int occurences = TextUtils.countOccurences(big, small);
            return occurences == n;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static int countOccurences(String big, String small) {
        int count = 0;
        int off = 0;
        if (big == null || small == null || "".equals(small)) {
            throw new NullPointerException("Cannot count occurrences of the empty or null String.");
        }
        if ("".equals(big)) {
            return 0;
        }
        while ((off = big.indexOf(small, off)) != -1) {
            off += small.length();
            ++count;
        }
        return count;
    }

    public static String trimLastSlashLevel(String input) {
        if (input.equals("/") || input.equals("")) {
            return input;
        }
        String output = TextUtils.trimTrailingSlashes(input);
        output = output.substring(0, output.lastIndexOf("/"));
        return output;
    }
}

