/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import com.davidehrmann.vcdiff.engine.RollingHash;
import java.nio.ByteBuffer;
import java.util.Arrays;

class BlockHash {
    public static final int kBlockSize = 16;
    protected static final int kMaxMatchesToCheck = 64;
    protected static final int kMaxProbes = 16;
    protected static final RollingHash rollingHash = new RollingHash(16);
    private final ByteBuffer source_data;
    private final int[] hash_table;
    private final int[] next_block_table;
    private final int[] last_block_table;
    private final int hash_table_mask;
    private final int starting_offset;
    private int last_block_added = -1;

    public BlockHash(byte[] source_data, int starting_offset, boolean populate_hash_table) {
        this(ByteBuffer.wrap(source_data), starting_offset, populate_hash_table);
    }

    public BlockHash(ByteBuffer source_data, int starting_offset, boolean populate_hash_table) {
        int table_size = BlockHash.CalcTableSize(source_data.remaining());
        if (table_size == 0) {
            throw new IllegalArgumentException("Error finding table size for source size " + source_data.remaining());
        }
        this.source_data = source_data;
        this.starting_offset = starting_offset;
        this.hash_table_mask = table_size - 1;
        this.hash_table = new int[table_size];
        Arrays.fill(this.hash_table, -1);
        this.next_block_table = new int[this.GetNumberOfBlocks()];
        this.last_block_table = new int[this.GetNumberOfBlocks()];
        Arrays.fill(this.next_block_table, -1);
        Arrays.fill(this.last_block_table, -1);
        if (populate_hash_table) {
            this.AddAllBlocks();
        }
    }

    public static BlockHash CreateDictionaryHash(byte[] dictionary_data) {
        return new BlockHash(dictionary_data, 0, true);
    }

    public static BlockHash CreateTargetHash(byte[] target_data, int dictionary_size) {
        return new BlockHash(target_data, dictionary_size, false);
    }

    public static BlockHash CreateTargetHash(ByteBuffer target_data, int dictionary_size) {
        return new BlockHash(target_data, dictionary_size, false);
    }

    public void AddOneIndexHash(int index, int hash_value) {
        if (index == this.NextIndexToAdd()) {
            this.AddBlock(hash_value);
        }
    }

    public void AddAllBlocksThroughIndex(int end_index) {
        if (end_index > this.source_data.limit()) {
            throw new IllegalArgumentException("AddAllBlocksThroughIndex() called with index " + end_index + " higher than end index " + this.source_data.limit());
        }
        int last_index_added = this.last_block_added * 16;
        if (end_index <= last_index_added) {
            throw new IllegalArgumentException("AddAllBlocksThroughIndex() called with index " + end_index + " <= last index added ( " + last_index_added + ")");
        }
        if (this.source_data.remaining() < 16) {
            return;
        }
        int end_limit = end_index;
        int last_legal_hash_index = this.source_data.limit() - 16;
        if (end_limit > last_legal_hash_index) {
            end_limit = last_legal_hash_index + 1;
        }
        ByteBuffer temp = this.source_data.duplicate();
        temp.position(this.NextIndexToAdd());
        while (temp.position() < end_limit) {
            this.AddBlock((int)rollingHash.Hash(temp));
        }
    }

    public void FindBestMatch(int hash_value, ByteBuffer target, Match best_match) {
        int match_counter = 0;
        int block_number = this.FirstMatchingBlock(hash_value, target.array(), target.arrayOffset() + target.position());
        while (block_number >= 0 && ++match_counter <= 64) {
            int source_match_offset = block_number * 16;
            int source_match_end = source_match_offset + 16;
            int target_match_offset = target.position();
            int target_match_end = target_match_offset + 16;
            int match_size = 16;
            int limit_bytes_to_left = Math.min(source_match_offset, target_match_offset);
            int matching_bytes_to_left = BlockHash.MatchingBytesToLeft(this.source_data, source_match_offset, target.array(), target.arrayOffset() + target_match_offset, limit_bytes_to_left);
            match_size += matching_bytes_to_left;
            int source_bytes_to_right = this.source_data.limit() - source_match_end;
            int target_bytes_to_right = target.limit() - target_match_end;
            int limit_bytes_to_right = Math.min(source_bytes_to_right, target_bytes_to_right);
            best_match.ReplaceIfBetterMatch(match_size += BlockHash.MatchingBytesToRight(this.source_data, source_match_end, target.array(), target.arrayOffset() + target_match_end, limit_bytes_to_right), (source_match_offset -= matching_bytes_to_left) + this.starting_offset, target_match_offset -= matching_bytes_to_left);
            block_number = this.NextMatchingBlock(block_number, target.array(), target.arrayOffset() + target.position());
        }
    }

    public void FindBestMatch(int hash_value, byte[] target_candidate, int target_candidate_start, byte[] target, int target_start, Match best_match) {
        if (target_candidate != target) {
            throw new IllegalArgumentException("target_candidate != target");
        }
        if (target_candidate_start < target_start) {
            throw new IllegalArgumentException("target_candidate_start < target_start");
        }
        ByteBuffer targetBuffer = ByteBuffer.wrap(target, target_start, target.length - target_start);
        targetBuffer.position(target_candidate_start);
        this.FindBestMatch(hash_value, targetBuffer, best_match);
    }

    protected static int CalcTableSize(int dictionary_size) {
        int min_size = dictionary_size / 4 + 1;
        int table_size = 1;
        while (table_size < min_size) {
            if ((table_size <<= 1) > 0) continue;
            throw new IllegalStateException(String.format("Internal error: CalcTableSize(dictionarySize = %d): resulting table_size %d is zero or negative", dictionary_size, table_size));
        }
        if ((table_size & table_size - 1) != 0) {
            throw new IllegalStateException(String.format("Internal error: CalcTableSize(dictionarySize = %d): resulting table_size %d is not a power of 2", dictionary_size, table_size));
        }
        if (dictionary_size > 0 && table_size > min_size * 2) {
            throw new IllegalStateException(String.format("Internal error: CalcTableSize(dictionarySize = %d): resulting table_size %d is too large", dictionary_size, table_size));
        }
        return table_size;
    }

    protected int GetNumberOfBlocks() {
        return this.source_data.limit() / 16;
    }

    protected int GetHashTableIndex(int hash_value) {
        return hash_value & this.hash_table_mask;
    }

    protected int NextIndexToAdd() {
        return (this.last_block_added + 1) * 16;
    }

    protected void AddBlock(int hash_value) {
        int block_number = this.last_block_added + 1;
        int total_blocks = this.source_data.limit() / 16;
        if (block_number >= total_blocks) {
            throw new IllegalArgumentException(String.format("BlockHash.AddBlock() called with block number %d. This is past last block %d", block_number, total_blocks - 1));
        }
        if (this.next_block_table[block_number] != -1) {
            throw new IllegalStateException(String.format("Internal error in BlockHash.AddBlock(): block number = %d, next block should be -1 but is %d", block_number, this.next_block_table[block_number]));
        }
        int hash_table_index = this.GetHashTableIndex(hash_value);
        int first_matching_block = this.hash_table[hash_table_index];
        if (first_matching_block < 0) {
            this.hash_table[hash_table_index] = block_number;
            this.last_block_table[block_number] = block_number;
        } else {
            int last_matching_block = this.last_block_table[first_matching_block];
            if (this.next_block_table[last_matching_block] != -1) {
                throw new IllegalStateException(String.format("Internal error in BlockHash.AddBlock(): first matching block = %d, last matching block = %d, next block should be -1 but is %d", first_matching_block, last_matching_block, this.next_block_table[last_matching_block]));
            }
            this.next_block_table[last_matching_block] = block_number;
            this.last_block_table[first_matching_block] = block_number;
        }
        this.last_block_added = block_number;
    }

    protected void AddAllBlocks() {
        this.AddAllBlocksThroughIndex(this.source_data.limit());
    }

    protected static boolean BlockContentsMatch(byte[] block1, int block1_ofset, ByteBuffer block2, int block2_offset) {
        for (int i = 0; i < 16; ++i) {
            if (block1[block1_ofset + i] == block2.get(block2_offset + i)) continue;
            return false;
        }
        return true;
    }

    protected static boolean BlockContentsMatch(byte[] block1, int block1_ofset, byte[] block2, int block2_offset) {
        for (int i = 0; i < 16; ++i) {
            if (block1[block1_ofset + i] == block2[block2_offset + i]) continue;
            return false;
        }
        return true;
    }

    protected int FirstMatchingBlock(int hash_value, byte[] block_ptr, int offset) {
        return this.SkipNonMatchingBlocks(this.hash_table[this.GetHashTableIndex(hash_value)], block_ptr, offset);
    }

    protected int NextMatchingBlock(int block_number, byte[] block_ptr, int offset) {
        if (block_number >= this.GetNumberOfBlocks()) {
            throw new IllegalArgumentException("NextMatchingBlock called for invalid block number " + block_number);
        }
        return this.SkipNonMatchingBlocks(this.next_block_table[block_number], block_ptr, offset);
    }

    protected int SkipNonMatchingBlocks(int block_number, byte[] block_ptr, int offset) {
        int probes = 0;
        while (block_number >= 0 && !BlockHash.BlockContentsMatch(block_ptr, offset, this.source_data, block_number * 16)) {
            if (++probes > 16) {
                return -1;
            }
            block_number = this.next_block_table[block_number];
        }
        return block_number;
    }

    protected static int MatchingBytesToLeft(ByteBuffer source_match_start, int source_match_offset, byte[] target_match_start, int target_match_start_offset, int max_bytes) {
        int bytes_found;
        for (bytes_found = 0; bytes_found < max_bytes && source_match_start.get(--source_match_offset) == target_match_start[--target_match_start_offset]; ++bytes_found) {
        }
        return bytes_found;
    }

    protected static int MatchingBytesToLeft(byte[] source_match_start, int source_match_offset, byte[] target_match_start, int target_match_start_offset, int max_bytes) {
        int bytes_found;
        for (bytes_found = 0; bytes_found < max_bytes && source_match_start[--source_match_offset] == target_match_start[--target_match_start_offset]; ++bytes_found) {
        }
        return bytes_found;
    }

    protected static int MatchingBytesToRight(ByteBuffer source_match_end, int source_match_end_offset, byte[] target_match_end, int target_match_end_offset, int max_bytes) {
        int bytes_found = 0;
        while (bytes_found < max_bytes && source_match_end.get(source_match_end_offset) == target_match_end[target_match_end_offset]) {
            ++bytes_found;
            ++source_match_end_offset;
            ++target_match_end_offset;
        }
        return bytes_found;
    }

    protected static int MatchingBytesToRight(byte[] source_match_end, int source_match_end_offset, byte[] target_match_end, int target_match_end_offset, int max_bytes) {
        int bytes_found = 0;
        while (bytes_found < max_bytes && source_match_end[source_match_end_offset] == target_match_end[target_match_end_offset]) {
            ++bytes_found;
            ++source_match_end_offset;
            ++target_match_end_offset;
        }
        return bytes_found;
    }

    public static class Match {
        private int size = 0;
        private int source_offset = -1;
        private int target_offset = -1;

        public void ReplaceIfBetterMatch(int candidate_size, int candidate_source_offset, int candidate_target_offset) {
            if (candidate_size > this.size) {
                this.size = candidate_size;
                this.source_offset = candidate_source_offset;
                this.target_offset = candidate_target_offset;
            }
        }

        public int size() {
            return this.size;
        }

        public int source_offset() {
            return this.source_offset;
        }

        public int target_offset() {
            return this.target_offset;
        }
    }
}

