/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import java.nio.ByteBuffer;

class RollingHash {
    private final int window_size;
    private final long[] remove_table;

    public RollingHash(int window_size) {
        if (window_size < 2) {
            throw new IllegalArgumentException();
        }
        this.window_size = window_size;
        this.remove_table = RollingHashUtil.BuildRemoveTable(window_size);
    }

    public long Hash(byte[] data, int offset, int length) {
        long h = RollingHashUtil.HashFirstTwoBytes(data, offset);
        for (int i = 2; i < this.window_size; ++i) {
            h = RollingHashUtil.HashStep(h, data[offset + i]);
        }
        return h;
    }

    public long Hash(ByteBuffer data) {
        long h = RollingHashUtil.HashFirstTwoBytes(data);
        for (int i = 2; i < this.window_size; ++i) {
            h = RollingHashUtil.HashStep(h, data.get());
        }
        return h;
    }

    public long UpdateHash(long old_hash, byte old_first_byte, byte new_last_byte) {
        long partial_hash = this.RemoveFirstByteFromHash(old_hash, old_first_byte);
        return RollingHashUtil.HashStep(partial_hash, new_last_byte);
    }

    protected long RemoveFirstByteFromHash(long full_hash, byte first_byte) {
        return RollingHashUtil.ModBase(full_hash + this.remove_table[first_byte & 0xFF]);
    }

    protected static class RollingHashUtil {
        public static final int kMult = 257;
        public static final int kBase = 0x800000;

        protected RollingHashUtil() {
        }

        public static long ModBase(long operand) {
            return operand & 0x7FFFFFL;
        }

        public static long FindModBaseInverse(long operand) {
            return 0x100000000L - RollingHashUtil.ModBase(operand) & 0xFFFFFFFFL;
        }

        public static long HashStep(long partial_hash, byte next_byte) {
            return RollingHashUtil.ModBase(partial_hash * 257L + (long)(next_byte & 0xFF));
        }

        public static long HashFirstTwoBytes(byte[] ptr, int offset) {
            return (ptr[offset] & 0xFF) * 257 + (ptr[offset + 1] & 0xFF);
        }

        public static long HashFirstTwoBytes(ByteBuffer data) {
            long hash = (data.get() & 0xFF) * 257;
            return hash += (long)(data.get() & 0xFF);
        }

        public static long[] BuildRemoveTable(int window_size) {
            if (window_size < 2) {
                throw new IllegalArgumentException();
            }
            long[] remove_table = new long[256];
            long multiplier = 1L;
            for (int i = 0; i < window_size - 1; ++i) {
                multiplier = RollingHashUtil.ModBase(multiplier * 257L);
            }
            long byte_times_multiplier = 0L;
            for (int removed_byte = 0; removed_byte < 256; ++removed_byte) {
                remove_table[removed_byte] = RollingHashUtil.FindModBaseInverse(byte_times_multiplier);
                byte_times_multiplier = RollingHashUtil.ModBase(byte_times_multiplier + multiplier);
            }
            return remove_table;
        }
    }
}

