/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordlistLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getWordSet(Class<?> aClass, String stopwordResource) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(aClass.getResourceAsStream(stopwordResource), "UTF-8"));
        try {
            HashSet<String> hashSet = WordlistLoader.getWordSet(reader);
            return hashSet;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getWordSet(Class<?> aClass, String stopwordResource, String comment) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(aClass.getResourceAsStream(stopwordResource), "UTF-8"));
        try {
            HashSet<String> hashSet = WordlistLoader.getWordSet(reader, comment);
            return hashSet;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<String> getWordSet(File wordfile) throws IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(wordfile);
            HashSet<String> hashSet = WordlistLoader.getWordSet(reader);
            return hashSet;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<String> getWordSet(File wordfile, String comment) throws IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(wordfile);
            HashSet<String> hashSet = WordlistLoader.getWordSet(reader, comment);
            return hashSet;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<String> getWordSet(Reader reader) throws IOException {
        HashSet<String> result = new HashSet<String>();
        BufferedReader br = null;
        try {
            br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            String word = null;
            while ((word = br.readLine()) != null) {
                result.add(word.trim());
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<String> getWordSet(Reader reader, String comment) throws IOException {
        HashSet<String> result = new HashSet<String>();
        BufferedReader br = null;
        try {
            br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            String word = null;
            while ((word = br.readLine()) != null) {
                if (word.startsWith(comment)) continue;
                result.add(word.trim());
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getSnowballWordSet(Class<?> aClass, String stopwordResource) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(aClass.getResourceAsStream(stopwordResource), "UTF-8"));
        try {
            Set<String> set = WordlistLoader.getSnowballWordSet(reader);
            return set;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getSnowballWordSet(Reader reader) throws IOException {
        HashSet<String> result = new HashSet<String>();
        BufferedReader br = null;
        try {
            br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            String line = null;
            while ((line = br.readLine()) != null) {
                int comment = line.indexOf(124);
                if (comment >= 0) {
                    line = line.substring(0, comment);
                }
                String[] words = line.split("\\s+");
                for (int i = 0; i < words.length; ++i) {
                    if (words[i].length() <= 0) continue;
                    result.add(words[i]);
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getStemDict(File wordstemfile) throws IOException {
        if (wordstemfile == null) {
            throw new NullPointerException("wordstemfile may not be null");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(wordstemfile));
            while ((line = br.readLine()) != null) {
                String[] wordstem = line.split("\t", 2);
                result.put(wordstem[0], wordstem[1]);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return result;
    }
}

