/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.analysis;

import com.datomic.lucene.analysis.CharArraySet;
import com.datomic.lucene.analysis.LowerCaseTokenizer;
import com.datomic.lucene.analysis.ReusableAnalyzerBase;
import com.datomic.lucene.analysis.StopFilter;
import com.datomic.lucene.analysis.StopwordAnalyzerBase;
import com.datomic.lucene.analysis.TokenStream;
import com.datomic.lucene.analysis.WordlistLoader;
import com.datomic.lucene.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StopAnalyzer
extends StopwordAnalyzerBase {
    public static final Set<?> ENGLISH_STOP_WORDS_SET;

    public StopAnalyzer(Version matchVersion) {
        this(matchVersion, ENGLISH_STOP_WORDS_SET);
    }

    public StopAnalyzer(Version matchVersion, Set<?> stopWords) {
        super(matchVersion, stopWords);
    }

    public StopAnalyzer(Version matchVersion, File stopwordsFile) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet(stopwordsFile));
    }

    public StopAnalyzer(Version matchVersion, Reader stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet(stopwords));
    }

    @Override
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        LowerCaseTokenizer source = new LowerCaseTokenizer(this.matchVersion, reader);
        return new ReusableAnalyzerBase.TokenStreamComponents(source, new StopFilter(this.matchVersion, (TokenStream)source, this.stopwords));
    }

    static {
        List<String> stopWords = Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with");
        CharArraySet stopSet = new CharArraySet(Version.LUCENE_CURRENT, stopWords.size(), false);
        stopSet.addAll(stopWords);
        ENGLISH_STOP_WORDS_SET = CharArraySet.unmodifiableSet(stopSet);
    }
}

