/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.reporting;

import androidx.annotation.NonNull;
import com.datatheorem.android.trustkit.reporting.PinningFailureReport;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ReportRateLimiter {
    private static final long MAX_SECONDS_BETWEEN_CACHE_RESET = 86400L;
    private static final Set<List<Object>> reportsCache = new HashSet<List<Object>>();
    protected static Date lastReportsCacheResetDate = new Date();

    ReportRateLimiter() {
    }

    static synchronized boolean shouldRateLimit(@NonNull PinningFailureReport report) {
        Date currentDate = new Date();
        long secondsSinceLastReset = currentDate.getTime() / 1000L - lastReportsCacheResetDate.getTime() / 1000L;
        if (secondsSinceLastReset > 86400L) {
            reportsCache.clear();
            lastReportsCacheResetDate = currentDate;
        }
        ArrayList<Object> cacheEntry = new ArrayList<Object>();
        cacheEntry.add(report.getNotedHostname());
        cacheEntry.add(report.getServerHostname());
        cacheEntry.add(report.getServerPort());
        cacheEntry.add(report.getValidatedCertificateChainAsPem());
        cacheEntry.add((Object)report.getValidationResult());
        boolean shouldRateLimitReport = reportsCache.contains(cacheEntry);
        if (!shouldRateLimitReport) {
            reportsCache.add(cacheEntry);
        }
        return shouldRateLimitReport;
    }
}

