/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.pinning;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.datatheorem.android.trustkit.TrustKit;
import com.datatheorem.android.trustkit.config.DomainPinningPolicy;
import com.datatheorem.android.trustkit.pinning.DebugOverridesTrustManager;
import com.datatheorem.android.trustkit.pinning.PinningTrustManager;
import com.datatheorem.android.trustkit.pinning.SystemTrustManager;
import com.datatheorem.android.trustkit.reporting.BackgroundReporter;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Set;
import javax.net.ssl.X509TrustManager;

public class TrustManagerBuilder {
    protected static X509TrustManager baselineTrustManager = null;
    protected static boolean shouldOverridePins = false;
    protected static BackgroundReporter backgroundReporter = null;

    public static void initializeBaselineTrustManager(@Nullable Set<Certificate> debugCaCerts, boolean debugOverridePins, @NonNull BackgroundReporter reporter) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        if (baselineTrustManager != null) {
            throw new IllegalStateException("TrustManagerBuilder has already been initialized");
        }
        baselineTrustManager = SystemTrustManager.getInstance();
        if (Build.VERSION.SDK_INT < 17) {
            return;
        }
        shouldOverridePins = debugOverridePins;
        if (debugCaCerts != null && debugCaCerts.size() > 0 && Build.VERSION.SDK_INT < 24) {
            baselineTrustManager = DebugOverridesTrustManager.getInstance(debugCaCerts);
        }
        backgroundReporter = reporter;
    }

    public static X509TrustManager getTrustManager(@NonNull String serverHostname) {
        if (baselineTrustManager == null) {
            throw new IllegalStateException("TrustManagerBuilder has not been initialized");
        }
        if (Build.VERSION.SDK_INT < 17) {
            return baselineTrustManager;
        }
        DomainPinningPolicy serverConfig = TrustKit.getInstance().getConfiguration().getPolicyForHostname(serverHostname);
        if (serverConfig == null || shouldOverridePins) {
            return baselineTrustManager;
        }
        return new PinningTrustManager(serverHostname, serverConfig, baselineTrustManager);
    }

    static BackgroundReporter getReporter() {
        if (backgroundReporter == null) {
            throw new IllegalStateException("TrustManagerBuilder has not been initialized");
        }
        return backgroundReporter;
    }
}

