/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.pinning;

import android.net.http.X509TrustManagerExtensions;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.datatheorem.android.trustkit.config.DomainPinningPolicy;
import com.datatheorem.android.trustkit.config.PublicKeyPin;
import com.datatheorem.android.trustkit.pinning.OkHostnameVerifier;
import com.datatheorem.android.trustkit.pinning.PinningValidationResult;
import com.datatheorem.android.trustkit.pinning.TrustManagerBuilder;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.net.ssl.X509TrustManager;

@RequiresApi(api=17)
class PinningTrustManager
implements X509TrustManager {
    private final X509TrustManagerExtensions baselineTrustManager;
    private final String serverHostname;
    private final DomainPinningPolicy serverConfig;

    public PinningTrustManager(@NonNull String serverHostname, @NonNull DomainPinningPolicy serverConfig, @NonNull X509TrustManager baselineTrustManager) {
        this.serverHostname = serverHostname;
        this.serverConfig = serverConfig;
        this.baselineTrustManager = Build.VERSION.SDK_INT < 17 ? null : new X509TrustManagerExtensions(baselineTrustManager);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        List servedServerChain;
        boolean didChainValidationFail = false;
        boolean didPinningValidationFail = false;
        List validatedServerChain = servedServerChain = Arrays.asList(chain);
        if (!OkHostnameVerifier.INSTANCE.verify(this.serverHostname, chain[0])) {
            didChainValidationFail = true;
        }
        try {
            validatedServerChain = this.baselineTrustManager.checkServerTrusted(chain, authType, this.serverHostname);
        }
        catch (CertificateException e) {
            if (Build.VERSION.SDK_INT >= 24 && e.getMessage().startsWith("Pin verification failed")) {
                didPinningValidationFail = true;
            }
            didChainValidationFail = true;
        }
        if (Build.VERSION.SDK_INT < 24 && !didChainValidationFail) {
            boolean hasPinningPolicyExpired;
            boolean bl = hasPinningPolicyExpired = this.serverConfig.getExpirationDate() != null && this.serverConfig.getExpirationDate().compareTo(new Date()) < 0;
            if (!hasPinningPolicyExpired) {
                boolean bl2 = didPinningValidationFail = !PinningTrustManager.isPinInChain(validatedServerChain, this.serverConfig.getPublicKeyPins());
            }
        }
        if (didChainValidationFail || didPinningValidationFail) {
            PinningValidationResult validationResult = PinningValidationResult.FAILED;
            if (didChainValidationFail) {
                validationResult = PinningValidationResult.FAILED_CERTIFICATE_CHAIN_NOT_TRUSTED;
            }
            TrustManagerBuilder.getReporter().pinValidationFailed(this.serverHostname, 0, servedServerChain, validatedServerChain, this.serverConfig, validationResult);
        }
        if (didChainValidationFail) {
            throw new CertificateException("Certificate validation failed for " + this.serverHostname);
        }
        if (didPinningValidationFail && this.serverConfig.shouldEnforcePinning()) {
            StringBuilder errorBuilder = new StringBuilder().append("Pin verification failed").append("\n  Configured pins: ");
            for (PublicKeyPin pin : this.serverConfig.getPublicKeyPins()) {
                errorBuilder.append(pin);
                errorBuilder.append(" ");
            }
            errorBuilder.append("\n  Peer certificate chain: ");
            for (Certificate certificate : validatedServerChain) {
                errorBuilder.append("\n    ").append(new PublicKeyPin(certificate)).append(" - ").append(((X509Certificate)certificate).getSubjectDN());
            }
            throw new CertificateException(errorBuilder.toString());
        }
    }

    private static boolean isPinInChain(List<X509Certificate> verifiedServerChain, Set<PublicKeyPin> configuredPins) {
        boolean wasPinFound = false;
        for (Certificate certificate : verifiedServerChain) {
            PublicKeyPin certificatePin = new PublicKeyPin(certificate);
            if (!configuredPins.contains(certificatePin)) continue;
            wasPinFound = true;
            break;
        }
        return wasPinFound;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new CertificateException("Client certificates not supported!");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

