/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.core.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.stargate.sdk.serialization.CustomEJsonCalendarDeserializer;
import io.stargate.sdk.serialization.CustomEJsonCalendarSerializer;
import io.stargate.sdk.serialization.CustomEJsonDateDeserializer;
import io.stargate.sdk.serialization.CustomEJsonDateSerializer;
import io.stargate.sdk.serialization.CustomEJsonInstantDeserializer;
import io.stargate.sdk.serialization.CustomEJsonInstantSerializer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;

public class ObjectMap
extends HashMap<String, Object> {
    private static ObjectMapper objectMapper;
    private static final long serialVersionUID = 3279531139420446635L;

    public static synchronized ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).registerModule((Module)new JavaTimeModule()).setDateFormat((DateFormat)new SimpleDateFormat("dd/MM/yyyy")).setSerializationInclusion(JsonInclude.Include.NON_NULL).setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
            SimpleModule module = new SimpleModule();
            module.addSerializer(Date.class, (JsonSerializer)new CustomEJsonDateSerializer());
            module.addSerializer(Calendar.class, (JsonSerializer)new CustomEJsonCalendarSerializer());
            module.addSerializer(Instant.class, (JsonSerializer)new CustomEJsonInstantSerializer());
            module.addDeserializer(Date.class, (JsonDeserializer)new CustomEJsonDateDeserializer());
            module.addDeserializer(Calendar.class, (JsonDeserializer)new CustomEJsonCalendarDeserializer());
            module.addDeserializer(Instant.class, (JsonDeserializer)new CustomEJsonInstantDeserializer());
            objectMapper.registerModule((Module)module);
        }
        return objectMapper;
    }

    public ObjectMap() {
    }

    public ObjectMap(Map<String, Object> map) {
        super(map);
    }

    public <K> K get(String key, Class<K> type, boolean required) {
        Objects.requireNonNull(type, "Type is required");
        if (this.containsKey(key)) {
            if (type.isAssignableFrom(this.get(key).getClass())) {
                return (K)this.get(key);
            }
            throw new IllegalArgumentException("Argument " + key + " is not a " + type.getSimpleName());
        }
        if (required) {
            throw new IllegalArgumentException("Argument " + key + " is required but was not found");
        }
        return null;
    }

    public <K> Set<K> getSet(String key, Class<K> itemClass) {
        return this.get(key, Set.class, true);
    }

    public <K> List<K> getList(String k, Class<K> itemClass) {
        return this.get(k, List.class, true);
    }

    public String getString(String k) {
        return this.get(k, String.class, true);
    }

    public Double getDouble(String k) {
        return this.get(k, Double.class, true);
    }

    public Integer getInteger(String k) {
        return this.get(k, Integer.class, true);
    }

    public Boolean getBoolean(String k) {
        return this.get(k, Boolean.class, true);
    }

    public Float getFloat(String k) {
        return this.get(k, Float.class, true);
    }

    public Long getLong(String k) {
        return this.get(k, Long.class, true);
    }

    public Short getShort(String k) {
        return this.get(k, Short.class, true);
    }

    public Byte getByte(String k) {
        return this.get(k, Byte.class, true);
    }

    public Character getCharacter(String k) {
        return this.get(k, Character.class, true);
    }

    public static ObjectMap of(@NonNull Object o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return (ObjectMap)ObjectMap.getObjectMapper().convertValue(o, ObjectMap.class);
    }
}

