/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.stubbing;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.DefaultRows;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.simulacron.common.cluster.AbstractCluster;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.cluster.AbstractNodeProperties;
import com.datastax.oss.simulacron.common.cluster.ClusterStructure;
import com.datastax.oss.simulacron.common.codec.Codec;
import com.datastax.oss.simulacron.common.codec.CodecUtils;
import com.datastax.oss.simulacron.common.codec.CqlMapper;
import com.datastax.oss.simulacron.common.stubbing.Action;
import com.datastax.oss.simulacron.common.stubbing.InternalStubMapping;
import com.datastax.oss.simulacron.common.stubbing.MessageResponseAction;
import com.datastax.oss.simulacron.common.stubbing.StubMapping;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PeerMetadataHandler
extends StubMapping
implements InternalStubMapping {
    private final List<String> queries = new ArrayList<String>();
    private final List<Pattern> queryPatterns = new ArrayList<Pattern>();
    static final UUID schemaVersion = UUID.randomUUID();
    private static final String queryClusterName = "select cluster_name from system.local";
    private static final RowsMetadata queryClusterNameMetadata;
    private static final Pattern queryPeers;
    private static final Pattern queryLocal;
    private static final Pattern queryPeersWithAddr;
    private static final String queryPeerWithNamedParam = "SELECT * FROM system.peers WHERE peer = :address";
    private static final String queryPeerV2WithNamedParam = "SELECT * FROM system.peers_v2 WHERE peer = :address and peer_port = :port";
    private final boolean supportsV2;

    public PeerMetadataHandler() {
        this(false);
    }

    public PeerMetadataHandler(boolean supportsV2) {
        this.supportsV2 = supportsV2;
        this.queries.add(queryClusterName);
        this.queries.add(queryPeerWithNamedParam);
        this.queryPatterns.add(queryPeers);
        this.queryPatterns.add(queryLocal);
        this.queryPatterns.add(queryPeersWithAddr);
        if (supportsV2) {
            this.queries.add(queryPeerV2WithNamedParam);
        }
    }

    @Override
    public boolean matches(Frame frame) {
        if (frame.message instanceof Query) {
            Query query = (Query)frame.message;
            String queryStr = query.query;
            return this.queries.stream().anyMatch(q -> q.equalsIgnoreCase(queryStr)) || this.queryPatternMatches(queryStr);
        }
        return false;
    }

    @Override
    public List<Action> getActions(AbstractNode node, Frame frame) {
        if (frame.message instanceof Query) {
            CqlMapper mapper = CqlMapper.forVersion(frame.protocolVersion);
            Query query = (Query)frame.message;
            if (query.query.equalsIgnoreCase(queryClusterName)) {
                return this.handleClusterNameQuery(node, mapper);
            }
            Matcher peerAddrMatcher = queryPeersWithAddr.matcher(query.query);
            if (peerAddrMatcher.matches()) {
                return this.handlePeersQuery(node, mapper, n -> {
                    if (n.getAddress() instanceof InetSocketAddress) {
                        InetAddress address = ((InetSocketAddress)n.getAddress()).getAddress();
                        String addrIp = address.getHostAddress();
                        return addrIp.equals(peerAddrMatcher.group(1));
                    }
                    return false;
                }, false);
            }
            if (query.query.equalsIgnoreCase(queryPeerWithNamedParam)) {
                ByteBuffer addressBuffer = (ByteBuffer)query.options.namedValues.get("address");
                InetAddress address = mapper.inet.decode(addressBuffer);
                return this.handlePeersQuery(node, mapper, n -> n.inet().equals(address), false);
            }
            if (query.query.equalsIgnoreCase(queryPeerV2WithNamedParam)) {
                if (!this.supportsV2) {
                    return this.peersV2NotSupported();
                }
                ByteBuffer addressBuffer = (ByteBuffer)query.options.namedValues.get("address");
                InetAddress address = mapper.inet.decode(addressBuffer);
                ByteBuffer portBuffer = (ByteBuffer)query.options.namedValues.get("port");
                int port = mapper.cint.decode(portBuffer);
                InetSocketAddress socketAddr = new InetSocketAddress(address, port);
                return this.handlePeersQuery(node, mapper, n -> n.inetSocketAddress().equals(socketAddr), true);
            }
            Matcher matcher = queryLocal.matcher(query.query);
            if (matcher.matches()) {
                return this.handleSystemLocalQuery(node, mapper);
            }
            matcher = queryPeers.matcher(query.query);
            if (matcher.matches()) {
                if (matcher.group(2).endsWith("v2")) {
                    if (this.supportsV2) {
                        return this.handlePeersQuery(node, mapper, n -> n != node, true);
                    }
                    return this.peersV2NotSupported();
                }
                return this.handlePeersQuery(node, mapper, n -> n != node, false);
            }
        }
        return Collections.emptyList();
    }

    private List<Action> peersV2NotSupported() {
        return Collections.singletonList(new MessageResponseAction((Message)new Error(8704, "Table system.peers_v2 does not exist")));
    }

    private boolean queryPatternMatches(String query) {
        for (Pattern pattern : this.queryPatterns) {
            if (!pattern.matcher(query).matches()) continue;
            return true;
        }
        return false;
    }

    private Set<String> resolveTokens(AbstractNode node) {
        String[] t = node.resolvePeerInfo("tokens", "0").split(",");
        return new LinkedHashSet<String>(Arrays.asList(t));
    }

    private List<Action> handleSystemLocalQuery(AbstractNode node, CqlMapper mapper) {
        InetSocketAddress address = this.resolveAddress(node);
        Codec<Set<String>> tokenCodec = mapper.codecFor((RawType)new RawType.RawSet(CodecUtils.primitive(1)));
        ByteBuffer[] byteBufferArray = new ByteBuffer[17];
        byteBufferArray[0] = CodecUtils.encodePeerInfo(node, mapper.ascii::encode, "key", "local");
        byteBufferArray[1] = CodecUtils.encodePeerInfo(node, mapper.ascii::encode, "bootstrapped", "COMPLETED");
        byteBufferArray[2] = mapper.inet.encode(node.resolvePeerInfo("rpc_address", address.getAddress()));
        byteBufferArray[3] = mapper.cint.encode(node.resolvePeerInfo("rpc_port", address.getPort()));
        byteBufferArray[4] = mapper.inet.encode(node.resolvePeerInfo("broadcast_address", address.getAddress()));
        byteBufferArray[5] = mapper.cint.encode(node.resolvePeerInfo("broadcast_port", address.getPort()));
        byteBufferArray[6] = mapper.ascii.encode(((AbstractNodeProperties)((Object)node.getCluster())).getName());
        byteBufferArray[7] = CodecUtils.encodePeerInfo(node, mapper.ascii::encode, "cql_version", "3.2.0");
        byteBufferArray[8] = mapper.ascii.encode(((AbstractNodeProperties)((Object)node.getDataCenter())).getName());
        byteBufferArray[9] = mapper.inet.encode(node.resolvePeerInfo("listen_address", address.getAddress()));
        byteBufferArray[10] = mapper.cint.encode(node.resolvePeerInfo("listen_port", address.getPort()));
        byteBufferArray[11] = CodecUtils.encodePeerInfo(node, mapper.ascii::encode, "partitioner", "org.apache.cassandra.dht.Murmur3Partitioner");
        byteBufferArray[12] = CodecUtils.encodePeerInfo(node, mapper.ascii::encode, "rack", "rack1");
        byteBufferArray[13] = mapper.ascii.encode(node.resolveCassandraVersion());
        byteBufferArray[14] = tokenCodec.encode(this.resolveTokens(node));
        byteBufferArray[15] = mapper.uuid.encode(node.getHostId());
        byteBufferArray[16] = mapper.uuid.encode(schemaVersion);
        List<ByteBuffer> localRow = CodecUtils.row(byteBufferArray);
        if (node.resolveDSEVersion() != null) {
            localRow.add(mapper.ascii.encode(node.resolveDSEVersion()));
            localRow.add(CodecUtils.encodePeerInfo(node, mapper.bool::encode, "graph", false));
        }
        DefaultRows rows = new DefaultRows(this.buildSystemLocalRowsMetadata(node), CodecUtils.rows(localRow));
        MessageResponseAction action = new MessageResponseAction((Message)rows);
        return Collections.singletonList(action);
    }

    private List<Action> handleClusterNameQuery(AbstractNode node, CqlMapper mapper) {
        Queue<List<ByteBuffer>> clusterRow = CodecUtils.singletonRow(mapper.ascii.encode(((AbstractNodeProperties)((Object)node.getCluster())).getName()));
        DefaultRows rows = new DefaultRows(queryClusterNameMetadata, clusterRow);
        MessageResponseAction action = new MessageResponseAction((Message)rows);
        return Collections.singletonList(action);
    }

    private List<Action> handlePeersQuery(AbstractNode node, CqlMapper mapper, Predicate<AbstractNode> nodeFilter, boolean isV2) {
        Codec tokenCodec = mapper.codecFor((RawType)new RawType.RawSet(CodecUtils.primitive(1)));
        ClusterStructure cluster = node.getCluster();
        Stream stream = ((AbstractCluster)cluster).getNodes().stream();
        Queue peerRows = stream.filter(nodeFilter).map(n -> {
            InetSocketAddress address = this.resolveAddress((AbstractNode)n);
            ByteBuffer[] byteBufferArray = new ByteBuffer[7];
            byteBufferArray[0] = mapper.inet.encode(n.resolvePeerInfo("peer", address.getAddress()));
            byteBufferArray[1] = mapper.varchar.encode(n.resolvePeerInfo("data_center", ((AbstractNodeProperties)((Object)n.getDataCenter())).getName()));
            byteBufferArray[2] = CodecUtils.encodePeerInfo(n, mapper.varchar::encode, "rack", "rack1");
            byteBufferArray[3] = mapper.varchar.encode(n.resolvePeerInfo("release_version", n.resolveCassandraVersion()));
            byteBufferArray[4] = tokenCodec.encode(this.resolveTokens((AbstractNode)n));
            byteBufferArray[5] = mapper.uuid.encode(n.getHostId());
            byteBufferArray[6] = mapper.uuid.encode(n.resolvePeerInfo("schema_version", schemaVersion));
            List<ByteBuffer> row = CodecUtils.row(byteBufferArray);
            if (isV2) {
                row.addAll(CodecUtils.row(mapper.cint.encode(n.resolvePeerInfo("peer_port", address.getPort())), mapper.inet.encode(n.resolvePeerInfo("native_address", address.getAddress())), mapper.cint.encode(n.resolvePeerInfo("native_port", address.getPort()))));
            } else {
                row.addAll(CodecUtils.row(mapper.inet.encode(n.resolvePeerInfo("rpc_address", address.getAddress()))));
            }
            if (node.resolveDSEVersion() != null) {
                row.add(mapper.ascii.encode(n.resolveDSEVersion()));
                row.add(CodecUtils.encodePeerInfo(n, mapper.bool::encode, "graph", false));
            }
            return row;
        }).collect(Collectors.toCollection(ArrayDeque::new));
        DefaultRows rows = new DefaultRows(this.buildSystemPeersRowsMetadata(node, isV2), peerRows);
        MessageResponseAction action = new MessageResponseAction((Message)rows);
        return Collections.singletonList(action);
    }

    private InetSocketAddress resolveAddress(AbstractNode node) {
        InetSocketAddress address = node.getAddress() instanceof InetSocketAddress ? (InetSocketAddress)node.getAddress() : new InetSocketAddress(InetAddress.getLoopbackAddress(), 9042);
        return address;
    }

    private RowsMetadata buildSystemPeersRowsMetadata(AbstractNode node, boolean isV2) {
        int[] nArray;
        CodecUtils.ColumnSpecBuilder systemPeers = CodecUtils.columnSpecBuilder("system", "peers");
        List<ColumnSpec> systemPeersSpecs = CodecUtils.columnSpecs((ColumnSpec)systemPeers.apply("peer", CodecUtils.primitive(16)), (ColumnSpec)systemPeers.apply("data_center", CodecUtils.primitive(1)), (ColumnSpec)systemPeers.apply("rack", CodecUtils.primitive(1)), (ColumnSpec)systemPeers.apply("release_version", CodecUtils.primitive(1)), (ColumnSpec)systemPeers.apply("tokens", new RawType.RawSet(CodecUtils.primitive(1))), (ColumnSpec)systemPeers.apply("host_id", CodecUtils.primitive(12)), (ColumnSpec)systemPeers.apply("schema_version", CodecUtils.primitive(12)));
        if (isV2) {
            systemPeersSpecs.addAll(CodecUtils.columnSpecs((ColumnSpec)systemPeers.apply("peer_port", CodecUtils.primitive(9)), (ColumnSpec)systemPeers.apply("native_address", CodecUtils.primitive(16)), (ColumnSpec)systemPeers.apply("native_port", CodecUtils.primitive(9))));
        } else {
            systemPeersSpecs.addAll(CodecUtils.columnSpecs((ColumnSpec)systemPeers.apply("rpc_address", CodecUtils.primitive(16))));
        }
        if (node.resolveDSEVersion() != null) {
            systemPeersSpecs.add((ColumnSpec)systemPeers.apply("dse_version", CodecUtils.primitive(1)));
            systemPeersSpecs.add((ColumnSpec)systemPeers.apply("graph", CodecUtils.primitive(4)));
        }
        if (isV2) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        int[] primaryKey = nArray;
        return new RowsMetadata(systemPeersSpecs, null, primaryKey, null);
    }

    private RowsMetadata buildSystemLocalRowsMetadata(AbstractNode node) {
        CodecUtils.ColumnSpecBuilder systemLocal = CodecUtils.columnSpecBuilder("system", "local");
        List<ColumnSpec> systemLocalSpecs = CodecUtils.columnSpecs((ColumnSpec)systemLocal.apply("key", CodecUtils.primitive(1)), (ColumnSpec)systemLocal.apply("bootstrapped", CodecUtils.primitive(1)), (ColumnSpec)systemLocal.apply("rpc_address", CodecUtils.primitive(16)), (ColumnSpec)systemLocal.apply("rpc_port", CodecUtils.primitive(9)), (ColumnSpec)systemLocal.apply("broadcast_address", CodecUtils.primitive(16)), (ColumnSpec)systemLocal.apply("broadcast_port", CodecUtils.primitive(9)), (ColumnSpec)systemLocal.apply("cluster_name", CodecUtils.primitive(1)), (ColumnSpec)systemLocal.apply("cql_version", CodecUtils.primitive(1)), (ColumnSpec)systemLocal.apply("data_center", CodecUtils.primitive(1)), (ColumnSpec)systemLocal.apply("listen_address", CodecUtils.primitive(16)), (ColumnSpec)systemLocal.apply("listen_port", CodecUtils.primitive(9)), (ColumnSpec)systemLocal.apply("partitioner", CodecUtils.primitive(1)), (ColumnSpec)systemLocal.apply("rack", CodecUtils.primitive(1)), (ColumnSpec)systemLocal.apply("release_version", CodecUtils.primitive(1)), (ColumnSpec)systemLocal.apply("tokens", new RawType.RawSet(CodecUtils.primitive(1))), (ColumnSpec)systemLocal.apply("host_id", CodecUtils.primitive(12)), (ColumnSpec)systemLocal.apply("schema_version", CodecUtils.primitive(12)));
        if (node.resolveDSEVersion() != null) {
            systemLocalSpecs.add((ColumnSpec)systemLocal.apply("dse_version", CodecUtils.primitive(1)));
            systemLocalSpecs.add((ColumnSpec)systemLocal.apply("graph", CodecUtils.primitive(4)));
        }
        return new RowsMetadata(systemLocalSpecs, null, new int[]{0}, null);
    }

    static {
        CodecUtils.ColumnSpecBuilder systemLocal = CodecUtils.columnSpecBuilder("system", "local");
        List<ColumnSpec> queryClusterNameSpecs = CodecUtils.columnSpecs((ColumnSpec)systemLocal.apply("cluster_name", CodecUtils.primitive(1)));
        queryClusterNameMetadata = new RowsMetadata(queryClusterNameSpecs, null, new int[0], null);
        queryPeers = Pattern.compile("SELECT (.*) FROM system\\.(peers\\S*)");
        queryLocal = Pattern.compile("SELECT (.*) FROM system\\.local( WHERE key='local')*");
        queryPeersWithAddr = Pattern.compile("SELECT \\* FROM system\\.peers WHERE peer='(.*)'");
    }
}

