/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.stubbing;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.DefaultRows;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.codec.CodecUtils;
import com.datastax.oss.simulacron.common.stubbing.Action;
import com.datastax.oss.simulacron.common.stubbing.InternalStubMapping;
import com.datastax.oss.simulacron.common.stubbing.MessageResponseAction;
import com.datastax.oss.simulacron.common.stubbing.StubMapping;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;

public class EmptyReturnMetadataHandler
extends StubMapping
implements InternalStubMapping {
    private String queryStr;

    public EmptyReturnMetadataHandler(String matchingQuery) {
        this.queryStr = matchingQuery;
    }

    @Override
    public boolean matches(Frame frame) {
        if (frame.message instanceof Query) {
            Query query = (Query)frame.message;
            String frameQueryStr = query.query;
            return this.queryStr.equalsIgnoreCase(frameQueryStr);
        }
        return false;
    }

    @Override
    public List<Action> getActions(AbstractNode node, Frame frame) {
        if (frame.message instanceof Query) {
            ArrayDeque peerRows = new ArrayDeque();
            DefaultRows rows = new DefaultRows(this.buildEmptyRowsMetadata(), peerRows);
            MessageResponseAction action = new MessageResponseAction((Message)rows);
            return Collections.singletonList(action);
        }
        return Collections.emptyList();
    }

    private RowsMetadata buildEmptyRowsMetadata() {
        CodecUtils.ColumnSpecBuilder systemPeers = CodecUtils.columnSpecBuilder("whatever_keyspace", "whatever_table");
        List<ColumnSpec> systemPeersSpecs = CodecUtils.columnSpecs((ColumnSpec)systemPeers.apply("key", CodecUtils.primitive(9)));
        return new RowsMetadata(systemPeersSpecs, null, new int[]{0}, null);
    }
}

