/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.result;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.error.FunctionFailure;
import com.datastax.oss.simulacron.common.result.ErrorResult;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class FunctionFailureResult
extends ErrorResult {
    @JsonProperty(value="keyspace")
    private final String keyspace;
    @JsonProperty(value="function")
    private final String name;
    @JsonProperty(value="arg_types")
    private final List<String> argTypes;

    public FunctionFailureResult(String keyspace, String function, List<String> argTypes, String detail) {
        this(keyspace, function, argTypes, detail, 0L, null);
    }

    @JsonCreator
    public FunctionFailureResult(@JsonProperty(value="keyspace") String keyspace, @JsonProperty(value="function", required=true) String function, @JsonProperty(value="arg_types") List<String> argTypes, @JsonProperty(value="detail") String detail, @JsonProperty(value="delay_in_ms") long delayInMs, @JsonProperty(value="ignore_on_prepare") Boolean ignoreOnPrepare) {
        super(5120, "execution of '" + FunctionFailureResult.functionName(keyspace, function) + argTypes + "' failed: " + detail, delayInMs, ignoreOnPrepare);
        this.keyspace = keyspace;
        this.name = function;
        this.argTypes = argTypes;
    }

    private static String functionName(String keyspace, String name) {
        return keyspace == null ? name : keyspace + "." + name;
    }

    @Override
    public Message toMessage() {
        return new FunctionFailure(this.errorMessage, this.keyspace, this.name, this.argTypes);
    }
}

