/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.codec;

import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.simulacron.common.codec.CodecUtils;
import com.datastax.oss.simulacron.common.codec.InvalidTypeException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RawTypeParser {
    public static Logger logger = LoggerFactory.getLogger(RawTypeParser.class);
    private final String str;
    private int idx;

    private RawTypeParser(String str, int idx) {
        this.str = str;
        this.idx = idx;
    }

    static RawType resolveRawTypeFromName(String name) {
        if (name.startsWith("'")) {
            return new RawType.RawCustom(name.substring(1, name.length() - 1));
        }
        RawTypeParser parser = new RawTypeParser(name, 0);
        String type = parser.parseTypeName();
        RawType nativeType = CodecUtils.nativeTypeMap.get(type.toLowerCase());
        if (nativeType != null) {
            return nativeType;
        }
        if (type.equalsIgnoreCase("list")) {
            List<String> parameters = parser.parseTypeParameters();
            if (parameters.size() != 1) {
                throw new InvalidTypeException(String.format("Excepting single parameter for list, got %s", parameters));
            }
            RawType elementType = RawTypeParser.resolveRawTypeFromName(parameters.get(0));
            return new RawType.RawList(elementType);
        }
        if (type.equalsIgnoreCase("set")) {
            List<String> parameters = parser.parseTypeParameters();
            if (parameters.size() != 1) {
                throw new InvalidTypeException(String.format("Excepting single parameter for set, got %s", parameters));
            }
            RawType elementType = RawTypeParser.resolveRawTypeFromName(parameters.get(0));
            return new RawType.RawSet(elementType);
        }
        if (type.equalsIgnoreCase("map")) {
            List<String> parameters = parser.parseTypeParameters();
            if (parameters.size() != 2) {
                throw new InvalidTypeException(String.format("Expecting two parameters for map, got %s", parameters));
            }
            RawType keyType = RawTypeParser.resolveRawTypeFromName(parameters.get(0));
            RawType valueType = RawTypeParser.resolveRawTypeFromName(parameters.get(1));
            return new RawType.RawMap(keyType, valueType);
        }
        if (type.equalsIgnoreCase("tuple")) {
            List<String> rawTypes = parser.parseTypeParameters();
            if (rawTypes.size() == 0) {
                throw new InvalidTypeException(String.format("Expecting at least one parameter for tuple, got %s", rawTypes));
            }
            ArrayList<RawType> types = new ArrayList<RawType>(rawTypes.size());
            for (String rawType : rawTypes) {
                types.add(RawTypeParser.resolveRawTypeFromName(rawType));
            }
            return new RawType.RawTuple(types);
        }
        if (type.equalsIgnoreCase("empty")) {
            return new RawType.RawCustom(type);
        }
        throw new InvalidTypeException("No valid type found");
    }

    private static int skipSpaces(String toParse, int idx) {
        while (idx < toParse.length() && RawTypeParser.isBlank(toParse.charAt(idx))) {
            ++idx;
        }
        return idx;
    }

    private static boolean isBlank(int c) {
        return c == 32 || c == 9 || c == 10;
    }

    private static boolean isIdentifierChar(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 45 || c == 43 || c == 46 || c == 95 || c == 38;
    }

    private String parseTypeName() {
        this.idx = RawTypeParser.skipSpaces(this.str, this.idx);
        return this.readNextIdentifier();
    }

    private List<String> parseTypeParameters() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isEOS()) {
            return list;
        }
        this.skipBlankAndComma();
        if (this.str.charAt(this.idx) != '<') {
            throw new InvalidTypeException("Illegal character " + this.idx);
        }
        ++this.idx;
        while (this.skipBlankAndComma()) {
            if (this.str.charAt(this.idx) == '>') {
                ++this.idx;
                return list;
            }
            String name = this.parseTypeName();
            String args = this.readRawTypeParameters();
            list.add(name + args);
        }
        throw new InvalidTypeException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
    }

    private String readNextIdentifier() {
        int startIdx;
        if ((startIdx = this.idx++) >= this.str.length()) {
            throw new InvalidTypeException("No more identifiers to read at index " + this.idx);
        }
        if (this.str.charAt(startIdx) == '\"') {
            while (!this.isEOS()) {
                boolean atQuote = this.str.charAt(this.idx) == '\"';
                ++this.idx;
                if (!atQuote) continue;
                if (!this.isEOS() && this.str.charAt(this.idx) == '\"') {
                    ++this.idx;
                    continue;
                }
                break;
            }
        } else if (this.str.charAt(startIdx) == '\'') {
            ++this.idx;
            while (!this.isEOS() && this.str.charAt(this.idx++) != '\'') {
            }
        } else {
            while (!this.isEOS() && (RawTypeParser.isIdentifierChar(this.str.charAt(this.idx)) || this.str.charAt(this.idx) == '\"')) {
                ++this.idx;
            }
        }
        return this.str.substring(startIdx, this.idx);
    }

    private String readRawTypeParameters() {
        this.idx = RawTypeParser.skipSpaces(this.str, this.idx);
        if (this.isEOS() || this.str.charAt(this.idx) == '>' || this.str.charAt(this.idx) == ',') {
            return "";
        }
        if (this.str.charAt(this.idx) != '<') {
            throw new InvalidTypeException(String.format("Expecting char %d of %s to be '<' but '%c' found", this.idx, this.str, Character.valueOf(this.str.charAt(this.idx))));
        }
        int i = this.idx;
        int open = 1;
        boolean inQuotes = false;
        while (open > 0) {
            ++this.idx;
            if (this.isEOS()) {
                throw new InvalidTypeException("Non closed angle brackets");
            }
            if (!inQuotes) {
                if (this.str.charAt(this.idx) == '\"') {
                    inQuotes = true;
                    continue;
                }
                if (this.str.charAt(this.idx) == '<') {
                    ++open;
                    continue;
                }
                if (this.str.charAt(this.idx) != '>') continue;
                --open;
                continue;
            }
            if (this.str.charAt(this.idx) != '\"') continue;
            inQuotes = false;
        }
        ++this.idx;
        return this.str.substring(i, this.idx);
    }

    private boolean skipBlankAndComma() {
        boolean commaFound = false;
        while (!this.isEOS()) {
            char c = this.str.charAt(this.idx);
            if (c == ',') {
                if (commaFound) {
                    return true;
                }
                commaFound = true;
            } else if (!RawTypeParser.isBlank(c)) {
                return true;
            }
            ++this.idx;
        }
        return false;
    }

    private boolean isEOS() {
        return this.idx >= this.str.length();
    }
}

