/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.codec;

import com.datastax.oss.protocol.internal.ProtocolConstants;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.codec.Encoder;
import com.datastax.oss.simulacron.common.codec.RawTypeParser;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecUtils {
    public static Logger logger = LoggerFactory.getLogger(CodecUtils.class);
    static final Map<String, RawType> nativeTypeMap = new HashMap<String, RawType>();
    private static final ConcurrentMap<String, RawType> typeCache;

    public static List<ByteBuffer> row(ByteBuffer ... columns) {
        return new ArrayList<ByteBuffer>(Arrays.asList(columns));
    }

    public static Queue<List<ByteBuffer>> singletonRow(ByteBuffer ... columns) {
        List<ByteBuffer> row = CodecUtils.row(columns);
        return CodecUtils.rows(row);
    }

    @SafeVarargs
    public static Queue<List<ByteBuffer>> rows(List<ByteBuffer> ... rows) {
        return new ArrayDeque<List<ByteBuffer>>(Arrays.asList(rows));
    }

    public static <T> ByteBuffer encodePeerInfo(AbstractNode node, Encoder<T> encoder, String key, T defaultValue) {
        return (ByteBuffer)encoder.apply(node.resolvePeerInfo(key, defaultValue));
    }

    public static RawType primitive(int code) {
        return (RawType)RawType.PRIMITIVES.get(code);
    }

    public static RawType getTypeFromName(String name) {
        RawType rawType;
        if (name == null) {
            name = "varchar";
        }
        if ((rawType = nativeTypeMap.get(name)) == null) {
            rawType = typeCache.computeIfAbsent(name, RawTypeParser::resolveRawTypeFromName);
        }
        return rawType;
    }

    public static List<ColumnSpec> columnSpecs(ColumnSpec ... colSpecs) {
        return new ArrayList<ColumnSpec>(Arrays.asList(colSpecs));
    }

    public static ColumnSpecBuilder columnSpecBuilder() {
        return CodecUtils.columnSpecBuilder("ks", "tbl");
    }

    public static ColumnSpecBuilder columnSpecBuilder(String keyspace, String table) {
        AtomicInteger counter = new AtomicInteger(0);
        return (columnName, rawType) -> new ColumnSpec(keyspace, table, columnName, counter.getAndIncrement(), rawType);
    }

    static {
        Field[] fields = ProtocolConstants.DataType.class.getDeclaredFields();
        TreeSet<String> nonPrimitiveTypes = new TreeSet<String>();
        nonPrimitiveTypes.add("custom");
        nonPrimitiveTypes.add("list");
        nonPrimitiveTypes.add("map");
        nonPrimitiveTypes.add("set");
        nonPrimitiveTypes.add("udt");
        nonPrimitiveTypes.add("tuple");
        for (Field field : fields) {
            try {
                String fieldName = field.getName().toLowerCase();
                if (nonPrimitiveTypes.contains(fieldName) || field.isSynthetic()) continue;
                RawType rawType = CodecUtils.primitive((Integer)field.get(null));
                nativeTypeMap.put(fieldName, rawType);
            }
            catch (IllegalAccessException e) {
                logger.error("Unable to cache Primitive type for {}", (Object)field, (Object)e);
            }
        }
        typeCache = new ConcurrentHashMap<String, RawType>();
    }

    public static interface ColumnSpecBuilder
    extends BiFunction<String, RawType, ColumnSpec> {
    }
}

