/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.protocol.json.NativeProtocolModule;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class ObjectMapperHolder {
    private static final ObjectMapper OBJECT_MAPPER;

    public static ObjectMapper getMapper() {
        return OBJECT_MAPPER;
    }

    static {
        ObjectMapper om = new ObjectMapper();
        SimpleModule mod = new SimpleModule("ClusterSerializers");
        mod.addDeserializer(SocketAddress.class, (JsonDeserializer)new SocketAddressDeserializer());
        mod.addKeySerializer(InetAddress.class, (JsonSerializer)new InetAddressSerializer());
        mod.addKeyDeserializer(InetAddress.class, (KeyDeserializer)new InetAddressDeserializer());
        om.registerModule((Module)mod);
        om.registerModule((Module)NativeProtocolModule.module());
        OBJECT_MAPPER = om;
    }

    public static class InetAddressSerializer
    extends JsonSerializer<InetAddress> {
        public void serialize(InetAddress value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String str = value.toString().trim();
            int ix = str.indexOf(47);
            if (ix >= 0) {
                str = ix == 0 ? str.substring(1) : str.substring(0, ix);
            }
            gen.writeFieldName(str);
        }
    }

    public static class InetAddressDeserializer
    extends KeyDeserializer {
        InetAddressDeserializer() {
        }

        public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
            return InetAddress.getByName(key);
        }
    }

    public static class SocketAddressDeserializer
    extends StdDeserializer<SocketAddress> {
        SocketAddressDeserializer() {
            super(SocketAddress.class);
        }

        public SocketAddress deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String data = p.getText();
            String[] parts = data.split(":");
            String addr = parts[0];
            int port = Integer.parseInt(parts[1]);
            return new InetSocketAddress(InetAddress.getByName(addr), port);
        }
    }
}

