/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request.query;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.request.query.QueryFlag;
import com.datastax.oss.protocol.internal.request.query.Values;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class QueryOptions {
    public static final QueryOptions DEFAULT = new QueryOptions(1, Collections.emptyList(), Collections.emptyMap(), false, -1, null, 8, Long.MIN_VALUE, null);
    private final EnumSet<QueryFlag> flags;
    public final int consistency;
    public final List<ByteBuffer> positionalValues;
    public final Map<String, ByteBuffer> namedValues;
    public final boolean skipMetadata;
    public final int pageSize;
    public final ByteBuffer pagingState;
    public final int serialConsistency;
    public final long defaultTimestamp;
    public final String keyspace;

    private QueryOptions(EnumSet<QueryFlag> flags, int consistency, List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency, long defaultTimestamp, String keyspace) {
        ProtocolErrors.check(positionalValues.isEmpty() || namedValues.isEmpty(), "Can't have both positional and named values", new Object[0]);
        this.flags = flags;
        this.consistency = consistency;
        this.positionalValues = positionalValues;
        this.namedValues = namedValues;
        this.skipMetadata = skipMetadata;
        this.pageSize = pageSize;
        this.pagingState = pagingState;
        this.serialConsistency = serialConsistency;
        this.defaultTimestamp = defaultTimestamp;
        this.keyspace = keyspace;
    }

    public QueryOptions(int consistency, List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency, long defaultTimestamp, String keyspace) {
        this(QueryOptions.computeFlags(positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency, defaultTimestamp, keyspace), consistency, positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency, defaultTimestamp, keyspace);
    }

    private static EnumSet<QueryFlag> computeFlags(List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency, long defaultTimestamp, String keyspace) {
        EnumSet<QueryFlag> flags = EnumSet.noneOf(QueryFlag.class);
        if (!positionalValues.isEmpty()) {
            flags.add(QueryFlag.VALUES);
        }
        if (!namedValues.isEmpty()) {
            flags.add(QueryFlag.VALUES);
            flags.add(QueryFlag.VALUE_NAMES);
        }
        if (skipMetadata) {
            flags.add(QueryFlag.SKIP_METADATA);
        }
        if (pageSize > 0) {
            flags.add(QueryFlag.PAGE_SIZE);
        }
        if (pagingState != null) {
            flags.add(QueryFlag.PAGING_STATE);
        }
        if (serialConsistency != 8) {
            flags.add(QueryFlag.SERIAL_CONSISTENCY);
        }
        if (defaultTimestamp != Long.MIN_VALUE) {
            flags.add(QueryFlag.DEFAULT_TIMESTAMP);
        }
        if (keyspace != null) {
            flags.add(QueryFlag.WITH_KEYSPACE);
        }
        return flags;
    }

    public <B> void encode(B dest, PrimitiveCodec<B> encoder, int protocolVersion) {
        encoder.writeUnsignedShort(this.consistency, dest);
        QueryFlag.encode(this.flags, dest, encoder, protocolVersion);
        if (this.flags.contains((Object)QueryFlag.VALUES)) {
            if (this.flags.contains((Object)QueryFlag.VALUE_NAMES)) {
                Values.writeNamedValues(this.namedValues, dest, encoder);
            } else {
                Values.writePositionalValues(this.positionalValues, dest, encoder);
            }
        }
        if (this.flags.contains((Object)QueryFlag.PAGE_SIZE)) {
            encoder.writeInt(this.pageSize, dest);
        }
        if (this.flags.contains((Object)QueryFlag.PAGING_STATE)) {
            encoder.writeBytes(this.pagingState, dest);
        }
        if (this.flags.contains((Object)QueryFlag.SERIAL_CONSISTENCY)) {
            encoder.writeUnsignedShort(this.serialConsistency, dest);
        }
        if (this.flags.contains((Object)QueryFlag.DEFAULT_TIMESTAMP)) {
            encoder.writeLong(this.defaultTimestamp, dest);
        }
        if (this.flags.contains((Object)QueryFlag.WITH_KEYSPACE)) {
            encoder.writeString(this.keyspace, dest);
        }
    }

    public int encodedSize(int protocolVersion) {
        int size = 0;
        size += 2;
        size += QueryFlag.encodedSize(protocolVersion);
        if (this.flags.contains((Object)QueryFlag.VALUES)) {
            size = this.flags.contains((Object)QueryFlag.VALUE_NAMES) ? (size += Values.sizeOfNamedValues(this.namedValues)) : (size += Values.sizeOfPositionalValues(this.positionalValues));
        }
        if (this.flags.contains((Object)QueryFlag.PAGE_SIZE)) {
            size += 4;
        }
        if (this.flags.contains((Object)QueryFlag.PAGING_STATE)) {
            size += PrimitiveSizes.sizeOfBytes(this.pagingState);
        }
        if (this.flags.contains((Object)QueryFlag.SERIAL_CONSISTENCY)) {
            size += 2;
        }
        if (this.flags.contains((Object)QueryFlag.DEFAULT_TIMESTAMP)) {
            size += 8;
        }
        if (this.flags.contains((Object)QueryFlag.WITH_KEYSPACE)) {
            size += PrimitiveSizes.sizeOfString(this.keyspace);
        }
        return size;
    }

    public static <B> QueryOptions decode(B source, PrimitiveCodec<B> decoder, int protocolVersion) {
        int consistency = decoder.readUnsignedShort(source);
        EnumSet<QueryFlag> flags = QueryFlag.decode(source, decoder, protocolVersion);
        List<ByteBuffer> positionalValues = Collections.emptyList();
        Map<String, ByteBuffer> namedValues = Collections.emptyMap();
        if (flags.contains((Object)QueryFlag.VALUES)) {
            if (flags.contains((Object)QueryFlag.VALUE_NAMES)) {
                namedValues = Values.readNamedValues(source, decoder);
            } else {
                positionalValues = Values.readPositionalValues(source, decoder);
            }
        }
        boolean skipMetadata = flags.contains((Object)QueryFlag.SKIP_METADATA);
        int pageSize = flags.contains((Object)QueryFlag.PAGE_SIZE) ? decoder.readInt(source) : -1;
        ByteBuffer pagingState = flags.contains((Object)QueryFlag.PAGING_STATE) ? decoder.readBytes(source) : null;
        int serialConsistency = flags.contains((Object)QueryFlag.SERIAL_CONSISTENCY) ? decoder.readUnsignedShort(source) : 8;
        long defaultTimestamp = flags.contains((Object)QueryFlag.DEFAULT_TIMESTAMP) ? decoder.readLong(source) : Long.MIN_VALUE;
        String keyspace = flags.contains((Object)QueryFlag.WITH_KEYSPACE) ? decoder.readString(source) : null;
        return new QueryOptions(flags, consistency, positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency, defaultTimestamp, keyspace);
    }

    public String toString() {
        return String.format("[cl=%s, positionalVals=%s, namedVals=%s, skip=%b, psize=%d, state=%s, serialCl=%s]", this.consistency, this.positionalValues, this.namedValues, this.skipMetadata, this.pageSize, this.pagingState, this.serialConsistency);
    }
}

