/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.util.Bytes;

public class Execute
extends Message {
    public final byte[] queryId;
    public final QueryOptions options;

    public Execute(byte[] queryId, QueryOptions options) {
        super(false, 10);
        this.queryId = queryId;
        this.options = options;
    }

    public String toString() {
        return "EXECUTE(" + Bytes.toHexString(this.queryId) + ')';
    }

    public static class Codec
    extends Message.Codec {
        public Codec(int protocolVersion) {
            super(10, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            Execute execute = (Execute)message;
            encoder.writeShortBytes(execute.queryId, dest);
            execute.options.encode(dest, encoder, this.protocolVersion);
        }

        @Override
        public int encodedSize(Message message) {
            Execute execute = (Execute)message;
            return PrimitiveSizes.sizeOfShortBytes(execute.queryId) + execute.options.encodedSize(this.protocolVersion);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            byte[] queryId = decoder.readShortBytes(source);
            QueryOptions options = QueryOptions.decode(source, decoder, this.protocolVersion);
            return new Execute(queryId, options);
        }
    }
}

