/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri.ogc;

import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryEngine;
import com.datastax.shaded.esri.Operator;
import com.datastax.shaded.esri.OperatorExportToGeoJson;
import com.datastax.shaded.esri.OperatorExportToWkb;
import com.datastax.shaded.esri.OperatorFactoryLocal;
import com.datastax.shaded.esri.Polygon;
import com.datastax.shaded.esri.Polyline;
import com.datastax.shaded.esri.SpatialReference;
import com.datastax.shaded.esri.ogc.OGCGeometry;
import com.datastax.shaded.esri.ogc.OGCMultiCurve;
import com.datastax.shaded.esri.ogc.OGCMultiSurface;
import com.datastax.shaded.esri.ogc.OGCPolygon;
import java.nio.ByteBuffer;

public class OGCMultiPolygon
extends OGCMultiSurface {
    Polygon polygon;

    public OGCMultiPolygon(Polygon src, SpatialReference sr) {
        this.polygon = src;
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 32);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(32, this.getEsriGeometry(), null);
    }

    @Override
    public String asGeoJson() {
        OperatorExportToGeoJson op = (OperatorExportToGeoJson)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToGeoJson);
        return op.execute(1, null, this.getEsriGeometry());
    }

    @Override
    public int numGeometries() {
        return this.polygon.getExteriorRingCount();
    }

    @Override
    public OGCGeometry geometryN(int n) {
        int exterior = 0;
        for (int i = 0; i < this.polygon.getPathCount(); ++i) {
            if (this.polygon.isExteriorRing(i)) {
                ++exterior;
            }
            if (exterior != n + 1) continue;
            return new OGCPolygon(this.polygon, i, this.esriSR);
        }
        throw new IllegalArgumentException("geometryN: n out of range");
    }

    @Override
    public String geometryType() {
        return "MultiPolygon";
    }

    @Override
    public OGCGeometry boundary() {
        Polyline polyline = new Polyline();
        polyline.add(this.polygon, true);
        return (OGCMultiCurve)OGCGeometry.createFromEsriGeometry(polyline, this.esriSR, true);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.polygon;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return this;
    }
}

