/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.auth;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Authenticator;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.dse.auth.BaseDseAuthenticator;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import java.net.InetSocketAddress;
import java.util.Arrays;

public class DsePlainTextAuthProvider
implements AuthProvider {
    private final String username;
    private final String password;
    private final String authorizationId;

    public DsePlainTextAuthProvider(String username, String password) {
        Preconditions.checkNotNull((Object)username, (Object)"username cannot be null");
        Preconditions.checkNotNull((Object)password, (Object)"password cannot be null");
        this.username = username;
        this.password = password;
        this.authorizationId = "";
    }

    public DsePlainTextAuthProvider(String username, String password, String authorizationId) {
        Preconditions.checkNotNull((Object)username, (Object)"username cannot be null");
        Preconditions.checkNotNull((Object)password, (Object)"password cannot be null");
        Preconditions.checkNotNull((Object)authorizationId, (Object)"authorizationId cannot be null");
        this.username = username;
        this.password = password;
        this.authorizationId = authorizationId;
    }

    @Override
    public Authenticator newAuthenticator(InetSocketAddress host, String authenticator) throws AuthenticationException {
        return new PlainTextAuthenticator(authenticator, this.username, this.password, this.authorizationId);
    }

    private static class PlainTextAuthenticator
    extends BaseDseAuthenticator {
        private static final byte[] MECHANISM = "PLAIN".getBytes(Charsets.UTF_8);
        private static final byte[] SERVER_INITIAL_CHALLENGE = "PLAIN-START".getBytes(Charsets.UTF_8);
        private static final byte[] NULL = new byte[]{0};
        private final byte[] authenticationId;
        private final byte[] password;
        private final byte[] authorizationId;

        PlainTextAuthenticator(String authenticator, String authenticationId, String password, String authorizationId) {
            super(authenticator);
            this.authenticationId = authenticationId.getBytes(Charsets.UTF_8);
            this.password = password.getBytes(Charsets.UTF_8);
            this.authorizationId = authorizationId.getBytes(Charsets.UTF_8);
        }

        @Override
        public byte[] getMechanism() {
            return (byte[])MECHANISM.clone();
        }

        @Override
        public byte[] getInitialServerChallenge() {
            return (byte[])SERVER_INITIAL_CHALLENGE.clone();
        }

        @Override
        public byte[] evaluateChallenge(byte[] challenge) {
            if (Arrays.equals(SERVER_INITIAL_CHALLENGE, challenge)) {
                return Bytes.concat((byte[][])new byte[][]{this.authorizationId, NULL, this.authenticationId, NULL, this.password});
            }
            throw new RuntimeException("Incorrect challenge from server");
        }
    }
}

