/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DelegatingCluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.TimestampGenerator;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.CodecNotFoundException;
import com.datastax.driver.core.policies.AddressTranslator;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.datastax.driver.dse.DefaultDseSession;
import com.datastax.driver.dse.DseConfiguration;
import com.datastax.driver.dse.DseSession;
import com.datastax.driver.dse.geometry.codecs.LineStringCodec;
import com.datastax.driver.dse.geometry.codecs.PointCodec;
import com.datastax.driver.dse.geometry.codecs.PolygonCodec;
import com.datastax.driver.dse.graph.GraphOptions;
import com.datastax.driver.dse.search.DateRangeCodec;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.ResourceBundle;

public class DseCluster
extends DelegatingCluster {
    private static final ResourceBundle dseDriverProperties = ResourceBundle.getBundle("com.datastax.driver.dse.DseDriver");
    private final Cluster delegate;

    public static String getDseDriverVersion() {
        return dseDriverProperties.getString("dse.driver.version");
    }

    public static Builder builder() {
        return new Builder();
    }

    private DseCluster(Cluster delegate) {
        Preconditions.checkArgument((boolean)(delegate.getConfiguration() instanceof DseConfiguration), (Object)"Cannot create a GraphCluster without a GraphConfiguration");
        this.delegate = delegate;
    }

    @Override
    public DseConfiguration getConfiguration() {
        return (DseConfiguration)super.getConfiguration();
    }

    @Override
    protected Cluster delegate() {
        return this.delegate;
    }

    @Override
    public DseSession newSession() {
        return new DefaultDseSession(super.newSession(), this);
    }

    @Override
    public DseSession connect() {
        return new DefaultDseSession(super.connect(), this);
    }

    @Override
    public DseSession connect(String keyspace) {
        return new DefaultDseSession(super.connect(keyspace), this);
    }

    @Override
    public ListenableFuture<Session> connectAsync() {
        return Futures.transform(super.connectAsync(), (Function)new Function<Session, Session>(){

            public Session apply(Session input) {
                return new DefaultDseSession(input, DseCluster.this);
            }
        });
    }

    @Override
    public ListenableFuture<Session> connectAsync(String keyspace) {
        return Futures.transform(super.connectAsync(keyspace), (Function)new Function<Session, Session>(){

            public Session apply(Session input) {
                return new DefaultDseSession(input, DseCluster.this);
            }
        });
    }

    public static class Builder
    extends Cluster.Builder {
        private GraphOptions graphOptions;
        private boolean geospatialCodecs = true;
        private boolean searchCodecs = true;

        public Builder() {
            this.withLoadBalancingPolicy(DseConfiguration.defaultLoadBalancingPolicy());
        }

        public Builder withGraphOptions(GraphOptions graphOptions) {
            this.graphOptions = graphOptions;
            return this;
        }

        public Builder withoutGeospatialCodecs() {
            this.geospatialCodecs = false;
            return this;
        }

        public Builder withoutSearchCodecs() {
            this.searchCodecs = false;
            return this;
        }

        @Override
        public Builder withClusterName(String name) {
            return (Builder)super.withClusterName(name);
        }

        @Override
        public Builder withPort(int port) {
            return (Builder)super.withPort(port);
        }

        @Override
        public Builder withMaxSchemaAgreementWaitSeconds(int maxSchemaAgreementWaitSeconds) {
            return (Builder)super.withMaxSchemaAgreementWaitSeconds(maxSchemaAgreementWaitSeconds);
        }

        @Override
        public Builder withProtocolVersion(ProtocolVersion version) {
            return (Builder)super.withProtocolVersion(version);
        }

        @Override
        public Builder addContactPoint(String address) {
            return (Builder)super.addContactPoint(address);
        }

        @Override
        public Builder addContactPoints(String ... addresses) {
            return (Builder)super.addContactPoints(addresses);
        }

        @Override
        public Builder addContactPoints(InetAddress ... addresses) {
            return (Builder)super.addContactPoints(addresses);
        }

        @Override
        public Builder addContactPoints(Collection<InetAddress> addresses) {
            return (Builder)super.addContactPoints(addresses);
        }

        @Override
        public Builder addContactPointsWithPorts(Collection<InetSocketAddress> addresses) {
            return (Builder)super.addContactPointsWithPorts(addresses);
        }

        @Override
        public Builder withLoadBalancingPolicy(LoadBalancingPolicy policy) {
            return (Builder)super.withLoadBalancingPolicy(policy);
        }

        @Override
        public Builder withReconnectionPolicy(ReconnectionPolicy policy) {
            return (Builder)super.withReconnectionPolicy(policy);
        }

        @Override
        public Builder withRetryPolicy(RetryPolicy policy) {
            return (Builder)super.withRetryPolicy(policy);
        }

        @Override
        public Builder withAddressTranslator(AddressTranslator translator) {
            return (Builder)super.withAddressTranslator(translator);
        }

        @Override
        public Builder withTimestampGenerator(TimestampGenerator timestampGenerator) {
            return (Builder)super.withTimestampGenerator(timestampGenerator);
        }

        @Override
        public Builder withSpeculativeExecutionPolicy(SpeculativeExecutionPolicy policy) {
            return (Builder)super.withSpeculativeExecutionPolicy(policy);
        }

        @Override
        public Builder withCodecRegistry(CodecRegistry codecRegistry) {
            return (Builder)super.withCodecRegistry(codecRegistry);
        }

        @Override
        public Builder withCredentials(String username, String password) {
            return (Builder)super.withCredentials(username, password);
        }

        @Override
        public Builder withAuthProvider(AuthProvider authProvider) {
            return (Builder)super.withAuthProvider(authProvider);
        }

        @Override
        public Builder withCompression(ProtocolOptions.Compression compression) {
            return (Builder)super.withCompression(compression);
        }

        @Override
        public Builder withoutMetrics() {
            return (Builder)super.withoutMetrics();
        }

        @Override
        public Builder withSSL() {
            return (Builder)super.withSSL();
        }

        @Override
        public Builder withSSL(SSLOptions sslOptions) {
            return (Builder)super.withSSL(sslOptions);
        }

        @Override
        public Builder withInitialListeners(Collection<Host.StateListener> listeners) {
            return (Builder)super.withInitialListeners(listeners);
        }

        @Override
        public Builder withoutJMXReporting() {
            return (Builder)super.withoutJMXReporting();
        }

        @Override
        public Builder withPoolingOptions(PoolingOptions options) {
            return (Builder)super.withPoolingOptions(options);
        }

        @Override
        public Builder withSocketOptions(SocketOptions options) {
            return (Builder)super.withSocketOptions(options);
        }

        @Override
        public Builder withQueryOptions(QueryOptions options) {
            return (Builder)super.withQueryOptions(options);
        }

        @Override
        public Builder withNettyOptions(NettyOptions nettyOptions) {
            return (Builder)super.withNettyOptions(nettyOptions);
        }

        @Override
        public DseCluster build() {
            DseCluster dseCluster = new DseCluster(super.build());
            CodecRegistry codecRegistry = dseCluster.getConfiguration().getCodecRegistry();
            if (this.geospatialCodecs) {
                Builder.registerGeospatialCodecs(codecRegistry);
            }
            if (this.searchCodecs) {
                Builder.registerSearchCodecs(codecRegistry);
            }
            return dseCluster;
        }

        @Override
        public DseConfiguration getConfiguration() {
            return new DseConfiguration(super.getConfiguration(), this.graphOptions != null ? this.graphOptions : new GraphOptions());
        }

        private static void registerGeospatialCodecs(CodecRegistry codecRegistry) {
            Builder.registerCodecIfNotPresent(codecRegistry, LineStringCodec.INSTANCE);
            Builder.registerCodecIfNotPresent(codecRegistry, PointCodec.INSTANCE);
            Builder.registerCodecIfNotPresent(codecRegistry, PolygonCodec.INSTANCE);
        }

        private static void registerSearchCodecs(CodecRegistry codecRegistry) {
            Builder.registerCodecIfNotPresent(codecRegistry, DateRangeCodec.INSTANCE);
        }

        private static void registerCodecIfNotPresent(CodecRegistry codecRegistry, TypeCodec<?> codec) {
            try {
                codecRegistry.codecFor(codec.getCqlType(), codec.getJavaType());
            }
            catch (CodecNotFoundException e) {
                codecRegistry.register(codec);
            }
        }
    }
}

