/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ExceptionCode;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.ProtocolEvent;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SchemaElement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.BootstrappingException;
import com.datastax.driver.core.exceptions.ClientWriteException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.FunctionExecutionException;
import com.datastax.driver.core.exceptions.InvalidConfigurationInQueryException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.ProtocolError;
import com.datastax.driver.core.exceptions.ReadFailureException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.ServerError;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.TruncateException;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.UnpreparedException;
import com.datastax.driver.core.exceptions.WriteFailureException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.utils.Bytes;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

class Responses {
    private Responses() {
    }

    static class AuthSuccess
    extends Message.Response {
        static final Message.Decoder<AuthSuccess> decoder = new Message.Decoder<AuthSuccess>(){

            @Override
            public AuthSuccess decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                ByteBuffer b = CBUtil.readValue(body);
                if (b == null) {
                    return new AuthSuccess(null);
                }
                byte[] token = new byte[b.remaining()];
                b.get(token);
                return new AuthSuccess(token);
            }
        };
        final byte[] token;

        private AuthSuccess(byte[] token) {
            super(Message.Response.Type.AUTH_SUCCESS);
            this.token = token;
        }
    }

    static class AuthChallenge
    extends Message.Response {
        static final Message.Decoder<AuthChallenge> decoder = new Message.Decoder<AuthChallenge>(){

            @Override
            public AuthChallenge decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                ByteBuffer b = CBUtil.readValue(body);
                if (b == null) {
                    return new AuthChallenge(null);
                }
                byte[] token = new byte[b.remaining()];
                b.get(token);
                return new AuthChallenge(token);
            }
        };
        final byte[] token;

        private AuthChallenge(byte[] token) {
            super(Message.Response.Type.AUTH_CHALLENGE);
            this.token = token;
        }
    }

    static class Event
    extends Message.Response {
        static final Message.Decoder<Event> decoder = new Message.Decoder<Event>(){

            @Override
            public Event decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                return new Event(ProtocolEvent.deserialize(body, version));
            }
        };
        final ProtocolEvent event;

        Event(ProtocolEvent event) {
            super(Message.Response.Type.EVENT);
            this.event = event;
        }

        public String toString() {
            return "EVENT " + this.event;
        }
    }

    static abstract class Result
    extends Message.Response {
        static final Message.Decoder<Result> decoder = new Message.Decoder<Result>(){

            @Override
            public Result decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                Kind kind = Kind.fromId(body.readInt());
                return kind.subDecoder.decode(body, version, codecRegistry);
            }
        };
        final Kind kind;

        protected Result(Kind kind) {
            super(Message.Response.Type.RESULT);
            this.kind = kind;
        }

        static class SchemaChange
        extends Result {
            final Change change;
            final SchemaElement targetType;
            final String targetKeyspace;
            final String targetName;
            final List<String> targetSignature;
            static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                    switch (version) {
                        case V1: 
                        case V2: {
                            Change change = CBUtil.readEnumValue(Change.class, body);
                            String targetKeyspace = CBUtil.readString(body);
                            String targetName = CBUtil.readString(body);
                            SchemaElement targetType = targetName.isEmpty() ? SchemaElement.KEYSPACE : SchemaElement.TABLE;
                            List targetSignature = Collections.emptyList();
                            return new SchemaChange(change, targetType, targetKeyspace, targetName, targetSignature);
                        }
                        case V3: 
                        case V4: 
                        case V5: 
                        case DSE_V1: {
                            Change change = CBUtil.readEnumValue(Change.class, body);
                            SchemaElement targetType = CBUtil.readEnumValue(SchemaElement.class, body);
                            String targetKeyspace = CBUtil.readString(body);
                            String targetName = targetType == SchemaElement.KEYSPACE ? "" : CBUtil.readString(body);
                            List<String> targetSignature = targetType == SchemaElement.FUNCTION || targetType == SchemaElement.AGGREGATE ? CBUtil.readStringList(body) : Collections.emptyList();
                            return new SchemaChange(change, targetType, targetKeyspace, targetName, targetSignature);
                        }
                    }
                    throw version.unsupported();
                }
            };

            private SchemaChange(Change change, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature) {
                super(Kind.SCHEMA_CHANGE);
                this.change = change;
                this.targetType = targetType;
                this.targetKeyspace = targetKeyspace;
                this.targetName = targetName;
                this.targetSignature = targetSignature;
            }

            public String toString() {
                return "RESULT schema change " + (Object)((Object)this.change) + " on " + (Object)((Object)this.targetType) + ' ' + this.targetKeyspace + (this.targetName.isEmpty() ? "" : '.' + this.targetName);
            }

            static enum Change {
                CREATED,
                UPDATED,
                DROPPED;

            }
        }

        static class Prepared
        extends Result {
            static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                    MD5Digest id = MD5Digest.wrap(CBUtil.readBytes(body));
                    boolean withPkIndices = version.compareTo(ProtocolVersion.V4) >= 0;
                    Rows.Metadata metadata = Rows.Metadata.decode(body, withPkIndices, version, codecRegistry);
                    Rows.Metadata resultMetadata = this.decodeResultMetadata(body, version, codecRegistry);
                    return new Prepared(id, metadata, resultMetadata);
                }

                private Rows.Metadata decodeResultMetadata(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                    switch (version) {
                        case V1: {
                            return Rows.Metadata.EMPTY;
                        }
                        case V2: 
                        case V3: 
                        case V4: 
                        case V5: 
                        case DSE_V1: {
                            return Rows.Metadata.decode(body, version, codecRegistry);
                        }
                    }
                    throw version.unsupported();
                }
            };
            final MD5Digest statementId;
            final Rows.Metadata metadata;
            final Rows.Metadata resultMetadata;

            private Prepared(MD5Digest statementId, Rows.Metadata metadata, Rows.Metadata resultMetadata) {
                super(Kind.PREPARED);
                this.statementId = statementId;
                this.metadata = metadata;
                this.resultMetadata = resultMetadata;
            }

            public String toString() {
                return "RESULT PREPARED " + this.statementId + ' ' + this.metadata + " (resultMetadata=" + this.resultMetadata + ')';
            }
        }

        static class ContinuousPagingMetadata {
            final int seqNo;
            final boolean last;

            ContinuousPagingMetadata(int seqNo, boolean last) {
                this.seqNo = seqNo;
                this.last = last;
            }

            public String toString() {
                return String.format("Page no. %d%s", this.seqNo, this.last ? " final" : "");
            }
        }

        static class Rows
        extends Result {
            static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                    Metadata metadata = Metadata.decode(body, version, codecRegistry);
                    int rowCount = body.readInt();
                    int columnCount = metadata.columnCount;
                    ArrayDeque data = new ArrayDeque(rowCount);
                    for (int i = 0; i < rowCount; ++i) {
                        ArrayList<ByteBuffer> row = new ArrayList<ByteBuffer>(columnCount);
                        for (int j = 0; j < columnCount; ++j) {
                            row.add(CBUtil.readValue(body));
                        }
                        data.add(row);
                    }
                    return new Rows(metadata, data, version);
                }
            };
            final Metadata metadata;
            final Queue<List<ByteBuffer>> data;
            private final ProtocolVersion version;
            private volatile Queue<List<ByteBuffer>> rows;

            private Rows(Metadata metadata, Queue<List<ByteBuffer>> data, ProtocolVersion version) {
                super(Kind.ROWS);
                this.metadata = metadata;
                this.data = data;
                this.version = version;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("ROWS ").append(this.metadata).append('\n');
                int rowNumber = 0;
                for (List list : this.data) {
                    if (++rowNumber > 5) break;
                    for (int i = 0; i < list.size(); ++i) {
                        ByteBuffer v = (ByteBuffer)list.get(i);
                        if (v == null) {
                            sb.append(" | null");
                            continue;
                        }
                        sb.append(" | ");
                        if (this.metadata.columns != null) {
                            DataType dataType = this.metadata.columns.getType(i);
                            sb.append(dataType);
                            sb.append(" ");
                            TypeCodec codec = this.metadata.columns.codecRegistry.codecFor(dataType);
                            Object o = codec.deserialize(v, this.version);
                            String s = codec.format(o);
                            if (s.length() > 100) {
                                s = s.substring(0, 100) + "...";
                            }
                            sb.append(s);
                            continue;
                        }
                        sb.append(Bytes.toHexString(v));
                    }
                    sb.append('\n');
                }
                if (rowNumber > 5) {
                    sb.append(String.format(" ... (%d rows)\n", this.data.size()));
                }
                sb.append("---");
                return sb.toString();
            }

            static class Metadata {
                static final Metadata EMPTY = new Metadata(0, null, null, null, null);
                final int columnCount;
                final ColumnDefinitions columns;
                final ByteBuffer pagingState;
                final int[] pkIndices;
                final ContinuousPagingMetadata continuousPage;

                private Metadata(int columnCount, ColumnDefinitions columns, ByteBuffer pagingState, int[] pkIndices, ContinuousPagingMetadata continuousPage) {
                    this.columnCount = columnCount;
                    this.columns = columns;
                    this.pagingState = pagingState;
                    this.pkIndices = pkIndices;
                    this.continuousPage = continuousPage;
                }

                static Metadata decode(ByteBuf body, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
                    return Metadata.decode(body, false, protocolVersion, codecRegistry);
                }

                static Metadata decode(ByteBuf body, boolean withPkIndices, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
                    ContinuousPagingMetadata optimizedPage;
                    int pkCount;
                    EnumSet<Flag> flags = Flag.deserialize(body.readInt());
                    int columnCount = body.readInt();
                    int[] pkIndices = null;
                    if (withPkIndices && (pkCount = body.readInt()) > 0) {
                        pkIndices = new int[pkCount];
                        for (int i = 0; i < pkCount; ++i) {
                            pkIndices[i] = body.readShort();
                        }
                    }
                    ByteBuffer state = null;
                    if (flags.contains((Object)Flag.HAS_MORE_PAGES)) {
                        state = CBUtil.readValue(body);
                    }
                    ContinuousPagingMetadata continuousPagingMetadata = optimizedPage = flags.contains((Object)Flag.CONTINUOUS_PAGING) ? new ContinuousPagingMetadata(body.readInt(), flags.contains((Object)Flag.LAST_CONTINUOUS_PAGE)) : null;
                    if (flags.contains((Object)Flag.NO_METADATA)) {
                        return new Metadata(columnCount, null, state, pkIndices, optimizedPage);
                    }
                    boolean globalTablesSpec = flags.contains((Object)Flag.GLOBAL_TABLES_SPEC);
                    String globalKsName = null;
                    String globalCfName = null;
                    if (globalTablesSpec) {
                        globalKsName = CBUtil.readString(body);
                        globalCfName = CBUtil.readString(body);
                    }
                    ColumnDefinitions.Definition[] defs = new ColumnDefinitions.Definition[columnCount];
                    for (int i = 0; i < columnCount; ++i) {
                        String ksName = globalTablesSpec ? globalKsName : CBUtil.readString(body);
                        String cfName = globalTablesSpec ? globalCfName : CBUtil.readString(body);
                        String name = CBUtil.readString(body);
                        DataType type = DataType.decode(body, protocolVersion, codecRegistry);
                        defs[i] = new ColumnDefinitions.Definition(ksName, cfName, name, type);
                    }
                    return new Metadata(columnCount, new ColumnDefinitions(defs, codecRegistry), state, pkIndices, optimizedPage);
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder();
                    if (this.columns == null) {
                        sb.append('[').append(this.columnCount).append(" columns]");
                    } else {
                        for (ColumnDefinitions.Definition column : this.columns) {
                            sb.append('[').append(column.getName());
                            sb.append(" (").append(column.getType()).append(")]");
                        }
                    }
                    if (this.pagingState != null) {
                        sb.append(" (to be continued)");
                    }
                    return sb.toString();
                }

                private static enum Flag {
                    GLOBAL_TABLES_SPEC(0),
                    HAS_MORE_PAGES(1),
                    NO_METADATA(2),
                    CONTINUOUS_PAGING(30),
                    LAST_CONTINUOUS_PAGE(31);

                    private final int pos;

                    private Flag(int pos) {
                        this.pos = pos;
                    }

                    static EnumSet<Flag> deserialize(int flags) {
                        Flag[] values;
                        EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                        for (Flag value : values = Flag.values()) {
                            if ((flags & 1 << value.pos) == 0) continue;
                            set.add(value);
                        }
                        return set;
                    }

                    static int serialize(EnumSet<Flag> flags) {
                        int i = 0;
                        for (Flag flag : flags) {
                            i |= 1 << flag.pos;
                        }
                        return i;
                    }
                }
            }
        }

        static class SetKeyspace
        extends Result {
            final String keyspace;
            static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                    return new SetKeyspace(CBUtil.readString(body));
                }
            };

            private SetKeyspace(String keyspace) {
                super(Kind.SET_KEYSPACE);
                this.keyspace = keyspace;
            }

            public String toString() {
                return "RESULT set keyspace " + this.keyspace;
            }
        }

        static class Void
        extends Result {
            static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                    return new Void();
                }
            };

            Void() {
                super(Kind.VOID);
            }

            public String toString() {
                return "EMPTY RESULT";
            }
        }

        static enum Kind {
            VOID(1, Void.subcodec),
            ROWS(2, Rows.subcodec),
            SET_KEYSPACE(3, SetKeyspace.subcodec),
            PREPARED(4, Prepared.subcodec),
            SCHEMA_CHANGE(5, SchemaChange.subcodec);

            private final int id;
            final Message.Decoder<Result> subDecoder;
            private static final Kind[] ids;

            private Kind(int id, Message.Decoder<Result> subDecoder) {
                this.id = id;
                this.subDecoder = subDecoder;
            }

            static Kind fromId(int id) {
                Kind k = ids[id];
                if (k == null) {
                    throw new DriverInternalError(String.format("Unknown kind id %d in RESULT message", id));
                }
                return k;
            }

            static {
                int maxId = -1;
                for (Kind k : Kind.values()) {
                    maxId = Math.max(maxId, k.id);
                }
                ids = new Kind[maxId + 1];
                for (Kind k : Kind.values()) {
                    if (ids[k.id] != null) {
                        throw new IllegalStateException("Duplicate kind id");
                    }
                    Kind.ids[k.id] = k;
                }
            }
        }
    }

    static class Supported
    extends Message.Response {
        static final Message.Decoder<Supported> decoder = new Message.Decoder<Supported>(){

            @Override
            public Supported decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                return new Supported(CBUtil.readStringToStringListMap(body));
            }
        };
        final Map<String, List<String>> supported;
        final Set<ProtocolOptions.Compression> supportedCompressions = EnumSet.noneOf(ProtocolOptions.Compression.class);

        Supported(Map<String, List<String>> supported) {
            super(Message.Response.Type.SUPPORTED);
            this.supported = supported;
            this.parseCompressions();
        }

        private void parseCompressions() {
            List<String> compList = this.supported.get("COMPRESSION");
            if (compList == null) {
                return;
            }
            for (String compStr : compList) {
                ProtocolOptions.Compression compr = ProtocolOptions.Compression.fromString(compStr);
                if (compr == null) continue;
                this.supportedCompressions.add(compr);
            }
        }

        public String toString() {
            return "SUPPORTED " + this.supported;
        }
    }

    static class Authenticate
    extends Message.Response {
        static final Message.Decoder<Authenticate> decoder = new Message.Decoder<Authenticate>(){

            @Override
            public Authenticate decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                String authenticator = CBUtil.readString(body);
                return new Authenticate(authenticator);
            }
        };
        final String authenticator;

        Authenticate(String authenticator) {
            super(Message.Response.Type.AUTHENTICATE);
            this.authenticator = authenticator;
        }

        public String toString() {
            return "AUTHENTICATE " + this.authenticator;
        }
    }

    static class Ready
    extends Message.Response {
        static final Message.Decoder<Ready> decoder = new Message.Decoder<Ready>(){

            @Override
            public Ready decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                return new Ready();
            }
        };

        Ready() {
            super(Message.Response.Type.READY);
        }

        public String toString() {
            return "READY";
        }
    }

    static class Error
    extends Message.Response {
        static final Message.Decoder<Error> decoder = new Message.Decoder<Error>(){

            @Override
            public Error decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                ExceptionCode code = ExceptionCode.fromValue(body.readInt());
                String msg = CBUtil.readString(body);
                Object infos = null;
                switch (code) {
                    case UNAVAILABLE: {
                        ConsistencyLevel clu = CBUtil.readConsistencyLevel(body);
                        int required = body.readInt();
                        int alive = body.readInt();
                        infos = new UnavailableException(clu, required, alive);
                        break;
                    }
                    case WRITE_TIMEOUT: 
                    case READ_TIMEOUT: {
                        ConsistencyLevel clt = CBUtil.readConsistencyLevel(body);
                        int received = body.readInt();
                        int blockFor = body.readInt();
                        if (code == ExceptionCode.WRITE_TIMEOUT) {
                            WriteType writeType = Enum.valueOf(WriteType.class, CBUtil.readString(body));
                            infos = new WriteTimeoutException(clt, writeType, received, blockFor);
                            break;
                        }
                        byte dataPresent = body.readByte();
                        infos = new ReadTimeoutException(clt, received, blockFor, dataPresent != 0);
                        break;
                    }
                    case WRITE_FAILURE: 
                    case READ_FAILURE: {
                        Map<InetAddress, Integer> failuresMap;
                        ConsistencyLevel clt = CBUtil.readConsistencyLevel(body);
                        int received = body.readInt();
                        int blockFor = body.readInt();
                        int failures = body.readInt();
                        if (version.compareTo(ProtocolVersion.V5) < 0) {
                            failuresMap = Collections.emptyMap();
                        } else {
                            failuresMap = new HashMap();
                            for (int i = 0; i < failures; ++i) {
                                InetAddress address = CBUtil.readInetWithoutPort(body);
                                int reasonCode = body.readUnsignedShort();
                                failuresMap.put(address, reasonCode);
                            }
                        }
                        if (code == ExceptionCode.WRITE_FAILURE) {
                            WriteType writeType = Enum.valueOf(WriteType.class, CBUtil.readString(body));
                            infos = new WriteFailureException(clt, writeType, received, blockFor, failures, failuresMap);
                            break;
                        }
                        byte dataPresent = body.readByte();
                        infos = new ReadFailureException(clt, received, blockFor, failures, failuresMap, dataPresent != 0);
                        break;
                    }
                    case UNPREPARED: {
                        infos = MD5Digest.wrap(CBUtil.readBytes(body));
                        break;
                    }
                    case ALREADY_EXISTS: {
                        String ksName = CBUtil.readString(body);
                        String cfName = CBUtil.readString(body);
                        infos = new AlreadyExistsException(ksName, cfName);
                        break;
                    }
                    case CLIENT_WRITE_FAILURE: {
                        infos = new ClientWriteException(msg);
                    }
                }
                return new Error(version, code, msg, infos);
            }
        };
        final ProtocolVersion serverProtocolVersion;
        final ExceptionCode code;
        final String message;
        final Object infos;

        private Error(ProtocolVersion serverProtocolVersion, ExceptionCode code, String message, Object infos) {
            super(Message.Response.Type.ERROR);
            this.serverProtocolVersion = serverProtocolVersion;
            this.code = code;
            this.message = message;
            this.infos = infos;
        }

        DriverException asException(InetSocketAddress host) {
            switch (this.code) {
                case SERVER_ERROR: {
                    return new ServerError(host, this.message);
                }
                case PROTOCOL_ERROR: {
                    return new ProtocolError(host, this.message);
                }
                case BAD_CREDENTIALS: {
                    return new AuthenticationException(host, this.message);
                }
                case UNAVAILABLE: {
                    return ((UnavailableException)this.infos).copy(host);
                }
                case OVERLOADED: {
                    return new OverloadedException(host, this.message);
                }
                case IS_BOOTSTRAPPING: {
                    return new BootstrappingException(host, this.message);
                }
                case TRUNCATE_ERROR: {
                    return new TruncateException(host, this.message);
                }
                case WRITE_TIMEOUT: {
                    return ((WriteTimeoutException)this.infos).copy(host);
                }
                case READ_TIMEOUT: {
                    return ((ReadTimeoutException)this.infos).copy(host);
                }
                case WRITE_FAILURE: {
                    return ((WriteFailureException)this.infos).copy(host);
                }
                case READ_FAILURE: {
                    return ((ReadFailureException)this.infos).copy(host);
                }
                case FUNCTION_FAILURE: {
                    return new FunctionExecutionException(host, this.message);
                }
                case SYNTAX_ERROR: {
                    return new SyntaxError(host, this.message);
                }
                case UNAUTHORIZED: {
                    return new UnauthorizedException(host, this.message);
                }
                case INVALID: {
                    return new InvalidQueryException(host, this.message);
                }
                case CONFIG_ERROR: {
                    return new InvalidConfigurationInQueryException(host, this.message);
                }
                case ALREADY_EXISTS: {
                    return ((AlreadyExistsException)this.infos).copy(host);
                }
                case UNPREPARED: {
                    return new UnpreparedException(host, this.message);
                }
                case CLIENT_WRITE_FAILURE: {
                    return ((ClientWriteException)this.infos).copy();
                }
            }
            return new DriverInternalError(String.format("Unknown protocol error code %s returned by %s. The error message was: %s", new Object[]{this.code, host, this.message}));
        }

        public String toString() {
            return "ERROR " + (Object)((Object)this.code) + ": " + this.message;
        }
    }
}

