/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.SchemaChangeListenerBase;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import com.datastax.driver.mapping.AccessorMapper;
import com.datastax.driver.mapping.AccessorReflectionMapper;
import com.datastax.driver.mapping.AnnotationParser;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.MappedUDTCodec;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.ReflectionMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingManager.class);
    private final Session session;
    final boolean isCassandraV1;
    private volatile Map<Class<?>, Mapper<?>> mappers = Collections.emptyMap();
    private volatile Map<Class<?>, MappedUDTCodec<?>> udtCodecs = Collections.emptyMap();
    private volatile Map<Class<?>, Object> accessors = Collections.emptyMap();

    public MappingManager(Session session) {
        this(session, MappingManager.getProtocolVersion(session));
    }

    private static ProtocolVersion getProtocolVersion(Session session) {
        session.init();
        return session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
    }

    public MappingManager(Session session, ProtocolVersion protocolVersion) {
        this.session = session;
        this.isCassandraV1 = protocolVersion == ProtocolVersion.V1;
        session.getCluster().register((SchemaChangeListener)new SchemaChangeListenerBase(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTableRemoved(TableMetadata table) {
                Map map = MappingManager.this.mappers;
                synchronized (map) {
                    Iterator it = MappingManager.this.mappers.values().iterator();
                    while (it.hasNext()) {
                        Mapper mapper = (Mapper)it.next();
                        if (!mapper.getTableMetadata().equals((Object)table)) continue;
                        LOGGER.error("Table {} has been removed; existing mappers for @Entity annotated {} will not work anymore", (Object)table.getName(), mapper.getMappedClass());
                        it.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTableChanged(TableMetadata current, TableMetadata previous) {
                Map map = MappingManager.this.mappers;
                synchronized (map) {
                    Iterator it = MappingManager.this.mappers.values().iterator();
                    while (it.hasNext()) {
                        Mapper mapper = (Mapper)it.next();
                        if (!mapper.getTableMetadata().equals((Object)previous)) continue;
                        LOGGER.warn("Table {} has been altered; existing mappers for @Entity annotated {} might not work properly anymore", (Object)previous.getName(), mapper.getMappedClass());
                        it.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onUserTypeRemoved(UserType type) {
                Map map = MappingManager.this.udtCodecs;
                synchronized (map) {
                    Iterator it = MappingManager.this.udtCodecs.values().iterator();
                    while (it.hasNext()) {
                        MappedUDTCodec codec = (MappedUDTCodec)((Object)it.next());
                        if (!type.equals((Object)codec.getCqlType())) continue;
                        LOGGER.error("User type {} has been removed; existing mappers for @UDT annotated {} will not work anymore", (Object)type, codec.getUdtClass());
                        it.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onUserTypeChanged(UserType current, UserType previous) {
                Map map = MappingManager.this.udtCodecs;
                synchronized (map) {
                    HashSet udtClasses = new HashSet();
                    Iterator it = MappingManager.this.udtCodecs.values().iterator();
                    while (it.hasNext()) {
                        MappedUDTCodec codec = (MappedUDTCodec)((Object)it.next());
                        if (!previous.equals((Object)codec.getCqlType())) continue;
                        LOGGER.warn("User type {} has been altered; existing mappers for @UDT annotated {} might not work properly anymore", (Object)previous, codec.getUdtClass());
                        udtClasses.add(codec.getUdtClass());
                        it.remove();
                    }
                    for (Class clazz : udtClasses) {
                        try {
                            MappingManager.this.getUDTCodec(clazz);
                        }
                        catch (Exception e) {
                            LOGGER.error("Could not update mapping for @UDT annotated " + clazz, (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    public Session getSession() {
        return this.session;
    }

    public <T> Mapper<T> mapper(Class<T> klass) {
        return this.getMapper(klass);
    }

    public <T> TypeCodec<T> udtCodec(Class<T> klass) {
        return this.getUDTCodec(klass);
    }

    public <T> T createAccessor(Class<T> klass) {
        return this.getAccessor(klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Mapper<T> getMapper(Class<T> klass) {
        Mapper<Object> mapper = this.mappers.get(klass);
        if (mapper == null) {
            Map<Class<?>, Mapper<?>> map = this.mappers;
            synchronized (map) {
                mapper = this.mappers.get(klass);
                if (mapper == null) {
                    EntityMapper<T> entityMapper = AnnotationParser.parseEntity(klass, ReflectionMapper.factory(), this);
                    mapper = new Mapper<T>(this, klass, entityMapper);
                    HashMap newMappers = new HashMap(this.mappers);
                    newMappers.put(klass, mapper);
                    this.mappers = newMappers;
                }
            }
        }
        return mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> TypeCodec<T> getUDTCodec(Class<T> mappedClass) {
        MappedUDTCodec<Object> codec = this.udtCodecs.get(mappedClass);
        if (codec == null) {
            Map<Class<?>, MappedUDTCodec<?>> map = this.udtCodecs;
            synchronized (map) {
                codec = this.udtCodecs.get(mappedClass);
                if (codec == null) {
                    codec = AnnotationParser.parseUDT(mappedClass, ReflectionMapper.factory(), this);
                    this.session.getCluster().getConfiguration().getCodecRegistry().register(codec);
                    HashMap newCodecs = new HashMap(this.udtCodecs);
                    newCodecs.put(mappedClass, codec);
                    this.udtCodecs = newCodecs;
                }
            }
        }
        return codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getAccessor(Class<T> klass) {
        Object accessor = this.accessors.get(klass);
        if (accessor == null) {
            Map<Class<?>, Object> map = this.accessors;
            synchronized (map) {
                accessor = this.accessors.get(klass);
                if (accessor == null) {
                    AccessorMapper<T> mapper = AnnotationParser.parseAccessor(klass, AccessorReflectionMapper.factory(), this);
                    mapper.prepare(this);
                    accessor = mapper.createProxy();
                    HashMap newAccessors = new HashMap(this.accessors);
                    newAccessors.put(klass, accessor);
                    this.accessors = newAccessors;
                }
            }
        }
        return (T)accessor;
    }
}

