/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.mapping.AccessorInvocationHandler;
import com.datastax.driver.mapping.AccessorMapper;
import com.datastax.driver.mapping.MethodMapper;
import java.lang.reflect.Proxy;
import java.util.List;

class AccessorReflectionMapper<T>
extends AccessorMapper<T> {
    private static AccessorReflectionFactory factory = new AccessorReflectionFactory();
    private final Class<T>[] proxyClasses;
    private final AccessorInvocationHandler<T> handler;

    private AccessorReflectionMapper(Class<T> daoClass, List<MethodMapper> methods) {
        super(daoClass, methods);
        this.proxyClasses = new Class[]{daoClass};
        this.handler = new AccessorInvocationHandler(this);
    }

    public static AccessorMapper.Factory factory() {
        return factory;
    }

    @Override
    public T createProxy() {
        try {
            return (T)Proxy.newProxyInstance(this.daoClass.getClassLoader(), this.proxyClasses, this.handler);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create instance for Accessor interface " + this.daoClass.getName());
        }
    }

    private static class AccessorReflectionFactory
    implements AccessorMapper.Factory {
        private AccessorReflectionFactory() {
        }

        @Override
        public <T> AccessorMapper<T> create(Class<T> daoClass, List<MethodMapper> methods) {
            return new AccessorReflectionMapper(daoClass, methods);
        }
    }
}

