/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.mapping.AnnotationParser;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.EnumType;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.TypeMappings;
import com.google.common.reflect.TypeToken;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class ReflectionMapper<T>
extends EntityMapper<T> {
    private static ReflectionFactory factory = new ReflectionFactory();

    private ReflectionMapper(Class<T> entityClass, String keyspace, String table, ConsistencyLevel writeConsistency, ConsistencyLevel readConsistency) {
        super(entityClass, keyspace, table, writeConsistency, readConsistency);
    }

    public static EntityMapper.Factory factory() {
        return factory;
    }

    @Override
    public T newEntity() {
        try {
            return this.entityClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create an instance of " + this.entityClass.getName());
        }
    }

    private static class ReflectionFactory
    implements EntityMapper.Factory {
        private ReflectionFactory() {
        }

        @Override
        public <T> EntityMapper<T> create(Class<T> entityClass, String keyspace, String table, ConsistencyLevel writeConsistency, ConsistencyLevel readConsistency) {
            return new ReflectionMapper(entityClass, keyspace, table, writeConsistency, readConsistency);
        }

        @Override
        public <T> ColumnMapper<T> createColumnMapper(Class<T> entityClass, Field field, int position, MappingManager mappingManager, AtomicInteger columnCounter) {
            String fieldName = field.getName();
            try {
                PropertyDescriptor pd = new PropertyDescriptor(fieldName, field.getDeclaringClass());
                if (field.getType().isEnum()) {
                    return new EnumMapper(field, position, pd, AnnotationParser.enumType(field), columnCounter);
                }
                for (Class<?> udt : TypeMappings.findUDTs(field.getGenericType())) {
                    mappingManager.getUDTCodec(udt);
                }
                return new LiteralMapper(field, position, pd, columnCounter);
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException("Cannot find matching getter and setter for field '" + fieldName + "'");
            }
        }
    }

    private static class EnumMapper<T>
    extends LiteralMapper<T> {
        private final EnumType enumType;
        private final Map<String, Object> fromString;

        private EnumMapper(Field field, int position, PropertyDescriptor pd, EnumType enumType, AtomicInteger columnCounter) {
            super(field, position, pd, columnCounter);
            this.enumType = enumType;
            if (enumType == EnumType.STRING) {
                this.fromString = new HashMap<String, Object>(this.fieldType.getRawType().getEnumConstants().length);
                for (Object constant : this.fieldType.getRawType().getEnumConstants()) {
                    this.fromString.put(constant.toString().toLowerCase(), constant);
                }
            } else {
                this.fromString = null;
            }
        }

        @Override
        public Object getValue(T entity) {
            Object value = super.getValue(entity);
            switch (this.enumType) {
                case STRING: {
                    return value == null ? null : value.toString();
                }
                case ORDINAL: {
                    return value == null ? null : Integer.valueOf(((Enum)value).ordinal());
                }
            }
            throw new AssertionError();
        }

        @Override
        public void setValue(Object entity, Object value) {
            Object converted = null;
            switch (this.enumType) {
                case STRING: {
                    converted = this.fromString.get(value.toString().toLowerCase());
                    break;
                }
                case ORDINAL: {
                    converted = this.fieldType.getRawType().getEnumConstants()[(Integer)value];
                }
            }
            super.setValue(entity, converted);
        }

        @Override
        public TypeToken<Object> getPivotType() {
            return this.enumType.pivotType;
        }
    }

    private static class LiteralMapper<T>
    extends ColumnMapper<T> {
        private final Method readMethod;
        private final Method writeMethod;

        private LiteralMapper(Field field, int position, PropertyDescriptor pd, AtomicInteger columnCounter) {
            super(field, position, columnCounter);
            this.readMethod = pd.getReadMethod();
            this.writeMethod = pd.getWriteMethod();
        }

        @Override
        public Object getValue(T entity) {
            try {
                return this.readMethod.invoke(entity, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not get field '" + this.fieldName + "'");
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to access getter for '" + this.fieldName + "' in " + entity.getClass().getName(), e);
            }
        }

        @Override
        public void setValue(Object entity, Object value) {
            try {
                this.writeMethod.invoke(entity, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not set field '" + this.fieldName + "' to value '" + value + "'");
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to access setter for '" + this.fieldName + "' in " + entity.getClass().getName(), e);
            }
        }
    }
}

