/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.CodecUtils;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.MappingManager;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class MappedUDTCodec<T>
extends TypeCodec<T> {
    private final UserType cqlUserType;
    private final Class<T> udtClass;
    private final List<ColumnMapper<T>> columnMappers;
    private final CodecRegistry codecRegistry;

    public MappedUDTCodec(UserType cqlUserType, Class<T> udtClass, List<ColumnMapper<T>> columnMappers, MappingManager mappingManager) {
        super((DataType)cqlUserType, udtClass);
        this.cqlUserType = cqlUserType;
        this.udtClass = udtClass;
        this.columnMappers = columnMappers;
        this.codecRegistry = mappingManager.getSession().getCluster().getConfiguration().getCodecRegistry();
    }

    public ByteBuffer serialize(T sourceObject, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (sourceObject == null) {
            return null;
        }
        int size = 0;
        ArrayList serializedFields = Lists.newArrayList();
        for (ColumnMapper<T> cm : this.columnMappers) {
            ByteBuffer serializedField;
            Object value = cm.getValue(sourceObject);
            TypeCodec codec = cm.getCustomCodec();
            if (codec == null) {
                codec = this.codecRegistry.codecFor(this.cqlUserType.getFieldType(cm.getColumnName()), cm.getPivotType());
            }
            size += 4 + ((serializedField = codec.serialize(value, protocolVersion)) == null ? 0 : serializedField.remaining());
            serializedFields.add(serializedField);
        }
        ByteBuffer result = ByteBuffer.allocate(size);
        for (ByteBuffer bb : serializedFields) {
            if (bb == null) {
                result.putInt(-1);
                continue;
            }
            result.putInt(bb.remaining());
            result.put(bb.duplicate());
        }
        return (ByteBuffer)result.flip();
    }

    public T deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        ByteBuffer input = bytes.duplicate();
        T targetObject = this.newInstance();
        for (ColumnMapper<T> cm : this.columnMappers) {
            int size = input.getInt();
            ByteBuffer serialized = size < 0 ? null : CodecUtils.readBytes((ByteBuffer)input, (int)size);
            TypeCodec codec = cm.getCustomCodec();
            if (codec == null) {
                codec = this.codecRegistry.codecFor(this.cqlUserType.getFieldType(cm.getColumnName()), cm.getPivotType());
            }
            cm.setValue(targetObject, codec.deserialize(serialized, protocolVersion));
        }
        return targetObject;
    }

    private T newInstance() {
        try {
            return this.udtClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating instance of @UDT-annotated class " + this.udtClass, e);
        }
    }

    public T parse(String value) throws InvalidTypeException {
        throw new UnsupportedOperationException();
    }

    public String format(T value) throws InvalidTypeException {
        throw new UnsupportedOperationException();
    }
}

