/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.mapping.annotations.Computed;
import com.datastax.driver.mapping.annotations.Table;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

class AnnotationChecks {
    private static final Package MAPPING_PACKAGE = Table.class.getPackage();

    AnnotationChecks() {
    }

    static <T extends Annotation> T getTypeAnnotation(Class<T> annotation, Class<?> annotatedClass) {
        T instance = annotatedClass.getAnnotation(annotation);
        if (instance == null) {
            throw new IllegalArgumentException(String.format("@%s annotation was not found on type %s", annotation.getSimpleName(), annotatedClass.getName()));
        }
        AnnotationChecks.validateAnnotations(annotatedClass, annotation);
        return instance;
    }

    private static void validateAnnotations(Class<?> clazz, Class<? extends Annotation> allowed) {
        Class<? extends Annotation> invalid = AnnotationChecks.validateAnnotations(clazz.getAnnotations(), allowed);
        if (invalid != null) {
            throw new IllegalArgumentException(String.format("Cannot have both @%s and @%s on type %s", allowed.getSimpleName(), invalid.getSimpleName(), clazz.getName()));
        }
    }

    static void validateAnnotations(Field field, String classDescription, Class<? extends Annotation> ... allowed) {
        Class<? extends Annotation> invalid = AnnotationChecks.validateAnnotations(field.getAnnotations(), allowed);
        if (invalid != null) {
            throw new IllegalArgumentException(String.format("Annotation @%s is not allowed on field %s of %s %s", invalid.getSimpleName(), field.getName(), classDescription, field.getDeclaringClass().getName()));
        }
        AnnotationChecks.checkValidComputed(field);
    }

    private static Class<? extends Annotation> validateAnnotations(Annotation[] annotations, Class<? extends Annotation> ... allowed) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> actual = annotation.annotationType();
            if (!actual.getPackage().equals(MAPPING_PACKAGE) || AnnotationChecks.contains(allowed, actual)) continue;
            return actual;
        }
        return null;
    }

    private static boolean contains(Object[] array, Object target) {
        for (Object element : array) {
            if (!element.equals(target)) continue;
            return true;
        }
        return false;
    }

    static void checkValidComputed(Field field) {
        Computed computed = field.getAnnotation(Computed.class);
        if (computed != null && computed.value().isEmpty()) {
            throw new IllegalArgumentException(String.format("Field %s: attribute 'value' of annotation @Computed is mandatory for computed fields", field.getName()));
        }
    }
}

