/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.mapping.AnnotationParser;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;

abstract class ColumnMapper<T> {
    private final String columnName;
    private final String alias;
    protected final String fieldName;
    protected final Class<?> javaType;
    protected final DataType dataType;
    protected final Kind kind;
    protected final int position;

    protected ColumnMapper(Field field, DataType dataType, int position, AtomicInteger columnCounter) {
        this.columnName = AnnotationParser.columnName(field);
        this.alias = columnCounter != null ? AnnotationParser.newAlias(field, columnCounter.incrementAndGet()) : null;
        this.fieldName = field.getName();
        this.javaType = field.getType();
        this.dataType = dataType;
        this.kind = AnnotationParser.kind(field);
        this.position = position;
    }

    abstract Object getValue(T var1);

    abstract void setValue(T var1, Object var2);

    String getColumnName() {
        return this.kind == Kind.COMPUTED ? this.columnName : QueryBuilder.quote((String)this.columnName);
    }

    String getAlias() {
        return this.alias;
    }

    DataType getDataType() {
        return this.dataType;
    }

    Object toSerializableValue(Object value) {
        return value;
    }

    static enum Kind {
        PARTITION_KEY,
        CLUSTERING_COLUMN,
        REGULAR,
        COMPUTED;

    }
}

