/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.mapping.AnnotationParser;
import java.lang.reflect.Field;

abstract class ColumnMapper<T> {
    private final String columnName;
    protected final String fieldName;
    protected final Class<?> javaType;
    protected final DataType dataType;
    protected final Kind kind;
    protected final int position;

    protected ColumnMapper(Field field, DataType dataType, int position) {
        this(AnnotationParser.columnName(field), field.getName(), field.getType(), dataType, AnnotationParser.kind(field), position);
    }

    private ColumnMapper(String columnName, String fieldName, Class<?> javaType, DataType dataType, Kind kind, int position) {
        this.columnName = columnName;
        this.fieldName = fieldName;
        this.javaType = javaType;
        this.dataType = dataType;
        this.kind = kind;
        this.position = position;
    }

    public abstract Object getValue(T var1);

    public abstract void setValue(T var1, Object var2);

    public String getColumnName() {
        return QueryBuilder.quote((String)this.columnName);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public static enum Kind {
        PARTITION_KEY,
        CLUSTERING_COLUMN,
        REGULAR;

    }
}

