/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.arrays;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.extras.codecs.arrays.AbstractPrimitiveArrayCodec;
import java.nio.ByteBuffer;

public class DoubleArrayCodec
extends AbstractPrimitiveArrayCodec<double[]> {
    public static final DoubleArrayCodec instance = new DoubleArrayCodec();

    public DoubleArrayCodec() {
        super(DataType.list((DataType)DataType.cdouble()), double[].class);
    }

    @Override
    protected int sizeOfComponentType() {
        return 8;
    }

    @Override
    protected void serializeElement(ByteBuffer output, double[] array, int index, ProtocolVersion protocolVersion) {
        output.putDouble(array[index]);
    }

    @Override
    protected void deserializeElement(ByteBuffer input, double[] array, int index, ProtocolVersion protocolVersion) {
        array[index] = input.getDouble();
    }

    @Override
    protected void formatElement(StringBuilder output, double[] array, int index) {
        output.append(array[index]);
    }

    @Override
    protected void parseElement(String input, double[] array, int index) {
        array[index] = Double.parseDouble(input);
    }

    @Override
    protected double[] newInstance(int size) {
        return new double[size];
    }
}

