/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.joda;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimeCodec
extends TypeCodec.AbstractTupleCodec<DateTime> {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateOptionalTimeParser().getParser()).appendOptional(new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toParser()).toFormatter().withZoneUTC();
    private static final DateTimeFormatter ZONE_FORMATTER = DateTimeFormat.forPattern((String)"ZZ");

    public DateTimeCodec(TupleType tupleType) {
        super(tupleType, DateTime.class);
        List types = tupleType.getComponentTypes();
        Preconditions.checkArgument((types.size() == 2 && ((DataType)types.get(0)).equals(DataType.timestamp()) && ((DataType)types.get(1)).equals(DataType.varchar()) ? 1 : 0) != 0, (String)"Expected tuple<timestamp,varchar>, got %s", (Object[])new Object[]{tupleType});
    }

    protected DateTime newInstance() {
        return null;
    }

    protected ByteBuffer serializeField(DateTime source, int index, ProtocolVersion protocolVersion) {
        if (index == 0) {
            long millis = source.getMillis();
            return DateTimeCodec.bigint().serializeNoBoxing(millis, protocolVersion);
        }
        if (index == 1) {
            return DateTimeCodec.varchar().serialize((Object)ZONE_FORMATTER.print((ReadableInstant)source), protocolVersion);
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }

    protected DateTime deserializeAndSetField(ByteBuffer input, DateTime target, int index, ProtocolVersion protocolVersion) {
        if (index == 0) {
            long millis = DateTimeCodec.bigint().deserializeNoBoxing(input, protocolVersion);
            return new DateTime(millis);
        }
        if (index == 1) {
            String zoneId = (String)DateTimeCodec.varchar().deserialize(input, protocolVersion);
            return target.withZone(DateTimeZone.forID((String)zoneId));
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }

    protected String formatField(DateTime value, int index) {
        if (index == 0) {
            return ParseUtils.quote((String)value.withZone(DateTimeZone.UTC).toString());
        }
        if (index == 1) {
            return ParseUtils.quote((String)ZONE_FORMATTER.print((ReadableInstant)value));
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }

    protected DateTime parseAndSetField(String input, DateTime target, int index) {
        if (index == 0) {
            if (ParseUtils.isQuoted((String)input)) {
                input = ParseUtils.unquote((String)input);
            }
            if (ParseUtils.isLongLiteral((String)input)) {
                try {
                    long millis = Long.parseLong(input);
                    return new DateTime(millis);
                }
                catch (NumberFormatException e) {
                    throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", input));
                }
            }
            try {
                return FORMATTER.parseDateTime(input);
            }
            catch (RuntimeException e) {
                throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", target));
            }
        }
        if (index == 1) {
            String zoneId = (String)DateTimeCodec.varchar().parse(input);
            return target.withZone(DateTimeZone.forID((String)zoneId));
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }
}

