/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Select
extends BuiltStatement {
    private static final List<Object> COUNT_ALL = Collections.singletonList(new Utils.FCall("count", new Utils.RawString("*")));
    private final String table;
    private final boolean isDistinct;
    private final boolean isJson;
    private final List<Object> columnNames;
    private final Where where;
    private List<Ordering> orderings;
    private Object limit;
    private Object perPartitionLimit;
    private boolean allowFiltering;

    Select(String keyspace, String table, List<Object> columnNames, boolean isDistinct, boolean isJson) {
        this(keyspace, table, null, null, columnNames, isDistinct, isJson);
    }

    Select(TableMetadata table, List<Object> columnNames, boolean isDistinct, boolean isJson) {
        this(Metadata.quoteIfNecessary(table.getKeyspace().getName()), Metadata.quoteIfNecessary(table.getName()), Arrays.asList(new Object[table.getPartitionKey().size()]), table.getPartitionKey(), columnNames, isDistinct, isJson);
    }

    Select(String keyspace, String table, List<Object> routingKeyValues, List<ColumnMetadata> partitionKey, List<Object> columnNames, boolean isDistinct, boolean isJson) {
        super(keyspace, partitionKey, routingKeyValues);
        this.table = table;
        this.columnNames = columnNames;
        this.isDistinct = isDistinct;
        this.isJson = isJson;
        this.where = new Where(this);
    }

    @Override
    StringBuilder buildQueryString(List<Object> variables, CodecRegistry codecRegistry) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        if (this.isJson) {
            builder.append("JSON ");
        }
        if (this.isDistinct) {
            builder.append("DISTINCT ");
        }
        if (this.columnNames == null) {
            builder.append('*');
        } else {
            Utils.joinAndAppendNames(builder, codecRegistry, this.columnNames);
        }
        builder.append(" FROM ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append('.');
        }
        Utils.appendName(this.table, builder);
        if (!this.where.clauses.isEmpty()) {
            builder.append(" WHERE ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.where.clauses, variables);
        }
        if (this.orderings != null) {
            builder.append(" ORDER BY ");
            Utils.joinAndAppend(builder, codecRegistry, ",", this.orderings, variables);
        }
        if (this.perPartitionLimit != null) {
            builder.append(" PER PARTITION LIMIT ").append(this.perPartitionLimit);
        }
        if (this.limit != null) {
            builder.append(" LIMIT ").append(this.limit);
        }
        if (this.allowFiltering) {
            builder.append(" ALLOW FILTERING");
        }
        return builder;
    }

    public Where where(Clause clause) {
        return this.where.and(clause);
    }

    public Where where() {
        return this.where;
    }

    public Select orderBy(Ordering ... orderings) {
        if (this.orderings != null) {
            throw new IllegalStateException("An ORDER BY clause has already been provided");
        }
        this.orderings = Arrays.asList(orderings);
        for (int i = 0; i < orderings.length; ++i) {
            this.checkForBindMarkers(orderings[i]);
        }
        return this;
    }

    public Select limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Invalid LIMIT value, must be strictly positive");
        }
        if (this.limit != null) {
            throw new IllegalStateException("A LIMIT value has already been provided");
        }
        this.limit = limit;
        this.setDirty();
        return this;
    }

    public Select limit(BindMarker marker) {
        if (this.limit != null) {
            throw new IllegalStateException("A LIMIT value has already been provided");
        }
        this.limit = marker;
        this.checkForBindMarkers(marker);
        return this;
    }

    public Select perPartitionLimit(int perPartitionLimit) {
        if (perPartitionLimit <= 0) {
            throw new IllegalArgumentException("Invalid PER PARTITION LIMIT value, must be strictly positive");
        }
        if (this.perPartitionLimit != null) {
            throw new IllegalStateException("A PER PARTITION LIMIT value has already been provided");
        }
        if (this.isDistinct) {
            throw new IllegalStateException("PER PARTITION LIMIT is not allowed with SELECT DISTINCT queries");
        }
        this.perPartitionLimit = perPartitionLimit;
        this.setDirty();
        return this;
    }

    public Select perPartitionLimit(BindMarker marker) {
        if (this.perPartitionLimit != null) {
            throw new IllegalStateException("A PER PARTITION LIMIT value has already been provided");
        }
        if (this.isDistinct) {
            throw new IllegalStateException("PER PARTITION LIMIT is not allowed with SELECT DISTINCT queries");
        }
        this.perPartitionLimit = marker;
        this.checkForBindMarkers(marker);
        return this;
    }

    public Select allowFiltering() {
        this.allowFiltering = true;
        return this;
    }

    public static class SelectionOrAlias
    extends Selection {
        private Object previousSelection;

        public Selection as(String alias) {
            assert (this.previousSelection != null);
            Utils.Alias a = new Utils.Alias(this.previousSelection, alias);
            this.previousSelection = null;
            return this.addName(a);
        }

        private Selection addName(Object name) {
            if (this.columnNames == null) {
                this.columnNames = new ArrayList();
            }
            this.columnNames.add(name);
            return this;
        }

        private SelectionOrAlias queueName(Object name) {
            if (this.previousSelection != null) {
                this.addName(this.previousSelection);
            }
            this.previousSelection = name;
            return this;
        }

        @Override
        public Builder all() {
            if (this.columnNames != null) {
                throw new IllegalStateException(String.format("Some columns (%s) have already been selected.", this.columnNames));
            }
            if (this.previousSelection != null) {
                throw new IllegalStateException(String.format("Some columns ([%s]) have already been selected.", this.previousSelection));
            }
            return this;
        }

        @Override
        public Builder countAll() {
            if (this.columnNames != null) {
                throw new IllegalStateException(String.format("Some columns (%s) have already been selected.", this.columnNames));
            }
            if (this.previousSelection != null) {
                throw new IllegalStateException(String.format("Some columns ([%s]) have already been selected.", this.previousSelection));
            }
            this.columnNames = COUNT_ALL;
            return this;
        }

        @Override
        public SelectionOrAlias column(String name) {
            return this.queueName(name);
        }

        @Override
        public SelectionOrAlias writeTime(String name) {
            return this.queueName(new Utils.FCall("writetime", new Utils.CName(name)));
        }

        @Override
        public SelectionOrAlias ttl(String name) {
            return this.queueName(new Utils.FCall("ttl", new Utils.CName(name)));
        }

        @Override
        public SelectionOrAlias fcall(String name, Object ... parameters) {
            return this.queueName(new Utils.FCall(name, parameters));
        }

        @Override
        public SelectionOrAlias cast(Object column, DataType targetType) {
            return this.queueName(new Utils.Cast(column, targetType));
        }

        @Override
        public SelectionOrAlias raw(String rawString) {
            return this.queueName(QueryBuilder.raw(rawString));
        }

        @Override
        public SelectionOrAlias path(String ... segments) {
            return this.queueName(QueryBuilder.path(segments));
        }

        @Override
        public SelectionOrAlias toJson(String name) {
            return this.queueName(new Utils.FCall("toJson", new Utils.CName(name)));
        }

        @Override
        public Select from(String keyspace, String table) {
            if (this.previousSelection != null) {
                this.addName(this.previousSelection);
            }
            this.previousSelection = null;
            return super.from(keyspace, table);
        }

        @Override
        public Select from(TableMetadata table) {
            if (this.previousSelection != null) {
                this.addName(this.previousSelection);
            }
            this.previousSelection = null;
            return super.from(table);
        }
    }

    public static abstract class Selection
    extends Builder {
        @Override
        public Selection distinct() {
            this.isDistinct = true;
            return this;
        }

        @Override
        public Selection json() {
            this.isJson = true;
            return this;
        }

        public abstract Builder all();

        public abstract Builder countAll();

        public abstract SelectionOrAlias column(String var1);

        public abstract SelectionOrAlias writeTime(String var1);

        public abstract SelectionOrAlias ttl(String var1);

        public abstract SelectionOrAlias fcall(String var1, Object ... var2);

        public SelectionOrAlias cast(Object column, DataType targetType) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }

        public SelectionOrAlias raw(String rawString) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }

        public SelectionOrAlias path(String ... segments) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }

        public SelectionOrAlias toJson(String name) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }
    }

    public static class Builder {
        List<Object> columnNames;
        boolean isDistinct;
        boolean isJson;

        Builder() {
        }

        Builder(List<Object> columnNames) {
            this.columnNames = columnNames;
        }

        public Builder distinct() {
            this.isDistinct = true;
            return this;
        }

        public Builder json() {
            this.isJson = true;
            return this;
        }

        public Select from(String table) {
            return this.from(null, table);
        }

        public Select from(String keyspace, String table) {
            return new Select(keyspace, table, this.columnNames, this.isDistinct, this.isJson);
        }

        public Select from(TableMetadata table) {
            return new Select(table, this.columnNames, this.isDistinct, this.isJson);
        }
    }

    public static class Where
    extends BuiltStatement.ForwardingStatement<Select> {
        private final List<Clause> clauses = new ArrayList<Clause>();

        Where(Select statement) {
            super(statement);
        }

        public Where and(Clause clause) {
            this.clauses.add(clause);
            ((Select)this.statement).maybeAddRoutingKey(clause.name(), clause.firstValue());
            this.checkForBindMarkers(clause);
            return this;
        }

        public Select orderBy(Ordering ... orderings) {
            return ((Select)this.statement).orderBy(orderings);
        }

        public Select limit(int limit) {
            return ((Select)this.statement).limit(limit);
        }

        public Select limit(BindMarker limit) {
            return ((Select)this.statement).limit(limit);
        }

        public Select perPartitionLimit(int perPartitionLimit) {
            return ((Select)this.statement).perPartitionLimit(perPartitionLimit);
        }

        public Select perPartitionLimit(BindMarker limit) {
            return ((Select)this.statement).perPartitionLimit(limit);
        }
    }
}

