/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.querybuilder.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public abstract class BuiltStatement
extends RegularStatement {
    private static final Pattern lowercaseId = Pattern.compile("[a-z][a-z0-9_]*");
    private final List<ColumnMetadata> partitionKey;
    private final List<Object> routingKeyValues;
    final String keyspace;
    private final ProtocolVersion protocolVersion;
    private final CodecRegistry codecRegistry;
    private boolean dirty;
    private String cache;
    private List<Object> values;
    Boolean isCounterOp;
    boolean hasNonIdempotentOps;
    boolean hasBindMarkers;
    private boolean forceNoValues;

    BuiltStatement(String keyspace, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        this.partitionKey = null;
        this.routingKeyValues = null;
        this.keyspace = keyspace;
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
    }

    BuiltStatement(TableMetadata tableMetadata, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        this.partitionKey = tableMetadata.getPartitionKey();
        this.routingKeyValues = Arrays.asList(new Object[tableMetadata.getPartitionKey().size()]);
        this.keyspace = BuiltStatement.escapeId(tableMetadata.getKeyspace().getName());
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
    }

    protected static String escapeId(String ident) {
        return lowercaseId.matcher(ident).matches() ? ident : Metadata.quote(ident);
    }

    @Override
    public String getQueryString() {
        this.maybeRebuildCache();
        return this.cache;
    }

    public Object getObject(int i) {
        this.maybeRebuildCache();
        if (this.values == null || this.values.isEmpty()) {
            throw new IllegalStateException("This statement does not have values");
        }
        if (i < 0 || i >= this.values.size()) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.values.get(i);
    }

    private void maybeRebuildCache() {
        StringBuilder sb;
        if (!this.dirty && this.cache != null) {
            return;
        }
        this.values = null;
        if (this.hasBindMarkers || this.forceNoValues) {
            sb = this.buildQueryString(null);
        } else {
            this.values = new ArrayList<Object>();
            sb = this.buildQueryString(this.values);
            if (this.values.size() > 65535) {
                throw new IllegalArgumentException("Too many values for built statement, the maximum allowed is 65535");
            }
            if (this.values.isEmpty()) {
                this.values = null;
            }
        }
        BuiltStatement.maybeAddSemicolon(sb);
        this.cache = sb.toString();
        this.dirty = false;
    }

    static StringBuilder maybeAddSemicolon(StringBuilder sb) {
        int l;
        for (l = sb.length(); l > 0 && sb.charAt(l - 1) <= ' '; --l) {
        }
        if (l != sb.length()) {
            sb.setLength(l);
        }
        if (l == 0 || sb.charAt(l - 1) != ';') {
            sb.append(';');
        }
        return sb;
    }

    abstract StringBuilder buildQueryString(List<Object> var1);

    boolean isCounterOp() {
        return this.isCounterOp == null ? false : this.isCounterOp;
    }

    void setCounterOp(boolean isCounterOp) {
        this.isCounterOp = isCounterOp;
    }

    boolean hasNonIdempotentOps() {
        return this.hasNonIdempotentOps;
    }

    void setNonIdempotentOps() {
        this.hasNonIdempotentOps = true;
    }

    void checkForBindMarkers(Object value) {
        this.dirty = true;
        if (Utils.containsBindMarker(value)) {
            this.hasBindMarkers = true;
        }
    }

    void checkForBindMarkers(Utils.Appendeable value) {
        this.dirty = true;
        if (value != null && value.containsBindMarker()) {
            this.hasBindMarkers = true;
        }
    }

    void maybeAddRoutingKey(String name, Object value) {
        if (this.routingKeyValues == null || name == null || value == null || Utils.containsSpecialValue(value)) {
            return;
        }
        for (int i = 0; i < this.partitionKey.size(); ++i) {
            if (!name.equals(this.partitionKey.get(i).getName())) continue;
            this.routingKeyValues.set(i, value);
            return;
        }
    }

    CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        if (this.routingKeyValues == null) {
            return null;
        }
        ByteBuffer[] routingKeyParts = new ByteBuffer[this.partitionKey.size()];
        CodecRegistry codecRegistry = this.getCodecRegistry();
        for (int i = 0; i < this.partitionKey.size(); ++i) {
            Object value = this.routingKeyValues.get(i);
            if (value == null) {
                return null;
            }
            TypeCodec<Object> codec = codecRegistry.codecFor(this.partitionKey.get(i).getType(), value);
            routingKeyParts[i] = codec.serialize(value, this.getProtocolVersion());
        }
        return routingKeyParts.length == 1 ? routingKeyParts[0] : Utils.compose(routingKeyParts);
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    @Override
    public ByteBuffer[] getValues() {
        this.maybeRebuildCache();
        return this.values == null ? null : Utils.convert(this.values.toArray(), this.getProtocolVersion(), this.getCodecRegistry());
    }

    @Override
    public boolean hasValues() {
        this.maybeRebuildCache();
        return this.values != null;
    }

    @Override
    public Boolean isIdempotent() {
        if (this.idempotent != null) {
            return this.idempotent;
        }
        return !this.hasNonIdempotentOps();
    }

    @Override
    public String toString() {
        if (this.forceNoValues) {
            return this.getQueryString();
        }
        return BuiltStatement.maybeAddSemicolon(this.buildQueryString(null)).toString();
    }

    public RegularStatement setForceNoValues(boolean forceNoValues) {
        this.forceNoValues = forceNoValues;
        this.dirty = true;
        return this;
    }

    static abstract class ForwardingStatement<T extends BuiltStatement>
    extends BuiltStatement {
        T statement;

        ForwardingStatement(T statement) {
            super((String)null, ((BuiltStatement)statement).getProtocolVersion(), ((BuiltStatement)statement).getCodecRegistry());
            this.statement = statement;
        }

        @Override
        public String getQueryString() {
            return ((BuiltStatement)this.statement).getQueryString();
        }

        @Override
        StringBuilder buildQueryString(List<Object> values) {
            return ((BuiltStatement)this.statement).buildQueryString(values);
        }

        @Override
        public ByteBuffer getRoutingKey() {
            return ((BuiltStatement)this.statement).getRoutingKey();
        }

        @Override
        public String getKeyspace() {
            return ((BuiltStatement)this.statement).getKeyspace();
        }

        @Override
        boolean isCounterOp() {
            return ((BuiltStatement)this.statement).isCounterOp();
        }

        @Override
        boolean hasNonIdempotentOps() {
            return ((BuiltStatement)this.statement).hasNonIdempotentOps();
        }

        @Override
        public RegularStatement setForceNoValues(boolean forceNoValues) {
            ((BuiltStatement)this.statement).setForceNoValues(forceNoValues);
            return this;
        }

        @Override
        public Statement setConsistencyLevel(ConsistencyLevel consistency) {
            ((Statement)this.statement).setConsistencyLevel(consistency);
            return this;
        }

        @Override
        public ConsistencyLevel getConsistencyLevel() {
            return ((Statement)this.statement).getConsistencyLevel();
        }

        @Override
        public Statement enableTracing() {
            ((Statement)this.statement).enableTracing();
            return this;
        }

        @Override
        public Statement disableTracing() {
            ((Statement)this.statement).disableTracing();
            return this;
        }

        @Override
        public boolean isTracing() {
            return ((Statement)this.statement).isTracing();
        }

        @Override
        public Statement setRetryPolicy(RetryPolicy policy) {
            ((Statement)this.statement).setRetryPolicy(policy);
            return this;
        }

        @Override
        public RetryPolicy getRetryPolicy() {
            return ((Statement)this.statement).getRetryPolicy();
        }

        @Override
        public ByteBuffer[] getValues() {
            return ((BuiltStatement)this.statement).getValues();
        }

        @Override
        public boolean hasValues() {
            return ((BuiltStatement)this.statement).hasValues();
        }

        @Override
        void checkForBindMarkers(Object value) {
            ((BuiltStatement)this.statement).checkForBindMarkers(value);
        }

        @Override
        void checkForBindMarkers(Utils.Appendeable value) {
            ((BuiltStatement)this.statement).checkForBindMarkers(value);
        }

        @Override
        public String toString() {
            return ((BuiltStatement)this.statement).toString();
        }
    }
}

