/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ColumnDefinitions
implements Iterable<Definition> {
    static final ColumnDefinitions EMPTY = new ColumnDefinitions(new Definition[0]);
    private final Definition[] byIdx;
    private final Map<String, int[]> byName;
    private volatile CodecRegistry codecRegistry;

    ColumnDefinitions(Definition[] defs) {
        this.byIdx = defs;
        this.byName = new HashMap<String, int[]>(defs.length);
        for (int i = 0; i < defs.length; ++i) {
            int[] previous = this.byName.put(defs[i].name.toLowerCase(), new int[]{i});
            if (previous == null) continue;
            int[] indexes = new int[previous.length + 1];
            System.arraycopy(previous, 0, indexes, 0, previous.length);
            indexes[indexes.length - 1] = i;
            this.byName.put(defs[i].name.toLowerCase(), indexes);
        }
    }

    public int size() {
        return this.byIdx.length;
    }

    public boolean contains(String name) {
        return this.findAllIdx(name) != null;
    }

    public int getIndexOf(String name) {
        return this.findFirstIdx(name);
    }

    @Override
    public Iterator<Definition> iterator() {
        return Arrays.asList(this.byIdx).iterator();
    }

    public List<Definition> asList() {
        return Arrays.asList(this.byIdx);
    }

    public String getName(int i) {
        return this.byIdx[i].name;
    }

    public DataType getType(int i) {
        return this.byIdx[i].type;
    }

    public DataType getType(String name) {
        return this.getType(this.getFirstIdx(name));
    }

    public String getKeyspace(int i) {
        return this.byIdx[i].keyspace;
    }

    public String getKeyspace(String name) {
        return this.getKeyspace(this.getFirstIdx(name));
    }

    public String getTable(int i) {
        return this.byIdx[i].table;
    }

    public String getTable(String name) {
        return this.getTable(this.getFirstIdx(name));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Columns[");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            Definition def = this.byIdx[i];
            sb.append(def.name).append('(').append(def.type).append(')');
        }
        sb.append(']');
        return sb.toString();
    }

    int findFirstIdx(String name) {
        int[] indexes = this.findAllIdx(name);
        return indexes == null ? -1 : indexes[0];
    }

    int[] findAllIdx(String name) {
        boolean caseSensitive = false;
        if (name.length() >= 2 && name.charAt(0) == '\"' && name.charAt(name.length() - 1) == '\"') {
            name = name.substring(1, name.length() - 1);
            caseSensitive = true;
        }
        int[] indexes = this.byName.get(name.toLowerCase());
        if (!caseSensitive || indexes == null) {
            return indexes;
        }
        int nbMatch = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (!name.equals(this.byIdx[indexes[i]].name)) continue;
            ++nbMatch;
        }
        if (nbMatch == indexes.length) {
            return indexes;
        }
        int[] result = new int[nbMatch];
        int j = 0;
        for (int i = 0; i < indexes.length; ++i) {
            int idx = indexes[i];
            if (!name.equals(this.byIdx[idx].name)) continue;
            result[j++] = idx;
        }
        return result;
    }

    int[] getAllIdx(String name) {
        int[] indexes = this.findAllIdx(name);
        if (indexes == null) {
            throw new IllegalArgumentException(name + " is not a column defined in this metadata");
        }
        return indexes;
    }

    int getFirstIdx(String name) {
        return this.getAllIdx(name)[0];
    }

    CodecRegistry getCodecRegistry() {
        assert (this.codecRegistry != null);
        return this.codecRegistry;
    }

    void setCodecRegistry(CodecRegistry codecRegistry) {
        for (Definition definition : this.byIdx) {
            ColumnDefinitions.propagateCodecRegistry(definition.type, codecRegistry);
        }
        this.codecRegistry = codecRegistry;
    }

    static void propagateCodecRegistry(DataType cqlType, CodecRegistry codecRegistry) {
        block4: {
            block5: {
                block3: {
                    if (!(cqlType instanceof UserType)) break block3;
                    UserType userType = (UserType)cqlType;
                    userType.setCodecRegistry(codecRegistry);
                    for (UserType.Field field : userType.byIdx) {
                        ColumnDefinitions.propagateCodecRegistry(field.getType(), codecRegistry);
                    }
                    break block4;
                }
                if (!(cqlType instanceof TupleType)) break block5;
                TupleType tupleType = (TupleType)cqlType;
                tupleType.setCodecRegistry(codecRegistry);
                for (DataType componentType : tupleType.getComponentTypes()) {
                    ColumnDefinitions.propagateCodecRegistry(componentType, codecRegistry);
                }
                break block4;
            }
            if (!cqlType.isCollection()) break block4;
            for (DataType inner : cqlType.getTypeArguments()) {
                ColumnDefinitions.propagateCodecRegistry(inner, codecRegistry);
            }
        }
    }

    public static class Definition {
        private final String keyspace;
        private final String table;
        private final String name;
        private final DataType type;

        Definition(String keyspace, String table, String name, DataType type) {
            this.keyspace = keyspace;
            this.table = table;
            this.name = name;
            this.type = type;
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        public String getTable() {
            return this.table;
        }

        public String getName() {
            return this.name;
        }

        public DataType getType() {
            return this.type;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.keyspace, this.table, this.name, this.type});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Definition)) {
                return false;
            }
            Definition other = (Definition)o;
            return this.keyspace.equals(other.keyspace) && this.table.equals(other.table) && this.name.equals(other.name) && this.type.equals(other.type);
        }
    }
}

