/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AggregateMetadata;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SchemaElement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.VersionNumber;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SchemaParser {
    private static final Logger logger = LoggerFactory.getLogger(SchemaParser.class);
    private static final TypeCodec<List<String>> LIST_OF_TEXT_CODEC = TypeCodec.list(TypeCodec.varchar());
    private static final SchemaParser V2_PARSER = new V2SchemaParser();
    private static final SchemaParser V3_PARSER = new V3SchemaParser();

    SchemaParser() {
    }

    static SchemaParser forVersion(VersionNumber cassandraVersion) {
        if (cassandraVersion.getMajor() >= 3) {
            return V3_PARSER;
        }
        return V2_PARSER;
    }

    abstract SystemRows fetchSystemRows(Metadata var1, SchemaElement var2, String var3, String var4, List<String> var5, Connection var6, VersionNumber var7) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException;

    abstract String tableNameColumn();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void refresh(Metadata metadata, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature, Connection connection, VersionNumber cassandraVersion) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException {
        SystemRows rows = this.fetchSystemRows(metadata, targetType, targetKeyspace, targetName, targetSignature, connection, cassandraVersion);
        metadata.lock.lock();
        try {
            if (targetType == null || targetType == SchemaElement.KEYSPACE) {
                assert (rows.keyspaces != null);
                Map<String, KeyspaceMetadata> keyspaces = this.buildKeyspaces(metadata, rows, cassandraVersion);
                this.updateKeyspaces(metadata, metadata.keyspaces, keyspaces, targetKeyspace);
                return;
            }
            assert (targetKeyspace != null);
            KeyspaceMetadata keyspace = (KeyspaceMetadata)metadata.keyspaces.get(targetKeyspace);
            if (keyspace == null) {
                logger.info(String.format("Asked to rebuild %s %s.%s but I don't know keyspace %s", new Object[]{targetType, targetKeyspace, targetName, targetKeyspace}));
                metadata.cluster.submitSchemaRefresh(null, null, null, null);
                return;
            }
            switch (targetType) {
                case TABLE: {
                    if (rows.tables.containsKey(targetKeyspace)) {
                        Map<String, TableMetadata> map = this.buildTables(metadata, keyspace, rows.tables.get(targetKeyspace), rows.columns.get(targetKeyspace), rows.indexes.get(targetKeyspace), cassandraVersion);
                        this.updateTables(metadata, keyspace.tables, map, targetName);
                    }
                    if (!rows.views.containsKey(targetKeyspace)) return;
                    Map<String, MaterializedViewMetadata> map = this.buildViews(keyspace, rows.views.get(targetKeyspace), rows.columns.get(targetKeyspace), cassandraVersion);
                    this.updateViews(metadata, keyspace.views, map, targetName);
                    return;
                }
                case TYPE: {
                    if (!rows.udts.containsKey(targetKeyspace)) return;
                    Map<String, UserType> map = this.buildUserTypes(metadata, rows.udts.get(targetKeyspace));
                    this.updateUserTypes(metadata, keyspace.userTypes, map, targetName);
                    return;
                }
                case FUNCTION: {
                    if (!rows.functions.containsKey(targetKeyspace)) return;
                    Map<String, FunctionMetadata> map = this.buildFunctions(metadata, keyspace, rows.functions.get(targetKeyspace));
                    this.updateFunctions(metadata, keyspace.functions, map, targetName);
                    return;
                }
                case AGGREGATE: {
                    if (!rows.aggregates.containsKey(targetKeyspace)) return;
                    Map<String, AggregateMetadata> map = this.buildAggregates(metadata, keyspace, rows.aggregates.get(targetKeyspace));
                    this.updateAggregates(metadata, keyspace.aggregates, map, targetName);
                    return;
                }
            }
            return;
        }
        finally {
            metadata.lock.unlock();
        }
    }

    private Map<String, KeyspaceMetadata> buildKeyspaces(Metadata metadata, SystemRows rows, VersionNumber cassandraVersion) {
        LinkedHashMap<String, KeyspaceMetadata> keyspaces = new LinkedHashMap<String, KeyspaceMetadata>();
        for (Row keyspaceRow : rows.keyspaces) {
            Object userType2;
            KeyspaceMetadata keyspace = KeyspaceMetadata.build(keyspaceRow, cassandraVersion);
            Map<String, TableMetadata> tables = this.buildTables(metadata, keyspace, rows.tables.get(keyspace.getName()), rows.columns.get(keyspace.getName()), rows.indexes.get(keyspace.getName()), cassandraVersion);
            for (TableMetadata tableMetadata : tables.values()) {
                keyspace.add(tableMetadata);
            }
            Map<String, UserType> userTypes = this.buildUserTypes(metadata, rows.udts.get(keyspace.getName()));
            for (Object userType2 : userTypes.values()) {
                keyspace.add((UserType)userType2);
            }
            Map<String, FunctionMetadata> map = this.buildFunctions(metadata, keyspace, rows.functions.get(keyspace.getName()));
            userType2 = map.values().iterator();
            while (userType2.hasNext()) {
                FunctionMetadata functionMetadata = (FunctionMetadata)userType2.next();
                keyspace.add(functionMetadata);
            }
            Map<String, AggregateMetadata> aggregates = this.buildAggregates(metadata, keyspace, rows.aggregates.get(keyspace.getName()));
            for (AggregateMetadata aggregate : aggregates.values()) {
                keyspace.add(aggregate);
            }
            Map<String, MaterializedViewMetadata> map2 = this.buildViews(keyspace, rows.views.get(keyspace.getName()), rows.columns.get(keyspace.getName()), cassandraVersion);
            for (MaterializedViewMetadata view : map2.values()) {
                keyspace.add(view);
            }
            keyspaces.put(keyspace.getName(), keyspace);
        }
        return keyspaces;
    }

    private Map<String, TableMetadata> buildTables(Metadata metadata, KeyspaceMetadata keyspace, List<Row> tableRows, Map<String, Map<String, ColumnMetadata.Raw>> colsDefs, Map<String, List<Row>> indexDefs, VersionNumber cassandraVersion) {
        LinkedHashMap<String, TableMetadata> tables = new LinkedHashMap<String, TableMetadata>();
        if (tableRows != null) {
            ProtocolVersion protocolVersion = metadata.cluster.protocolVersion();
            CodecRegistry codecRegistry = metadata.cluster.configuration.getCodecRegistry();
            for (Row tableDef : tableRows) {
                String cfName = tableDef.getString(this.tableNameColumn());
                try {
                    Map<String, ColumnMetadata.Raw> cols;
                    Map<String, ColumnMetadata.Raw> map = cols = colsDefs == null ? null : colsDefs.get(cfName);
                    if (cols == null || cols.isEmpty()) {
                        if (cassandraVersion.getMajor() >= 2) continue;
                        cols = Collections.emptyMap();
                    }
                    List<Row> cfIndexes = indexDefs == null ? null : indexDefs.get(cfName);
                    TableMetadata table = TableMetadata.build(keyspace, tableDef, cols, cfIndexes, this.tableNameColumn(), cassandraVersion, protocolVersion, codecRegistry);
                    tables.put(table.getName(), table);
                }
                catch (RuntimeException e) {
                    logger.error(String.format("Error parsing schema for table %s.%s: Cluster.getMetadata().getKeyspace(\"%s\").getTable(\"%s\") will be missing or incomplete", keyspace.getName(), cfName, keyspace.getName(), cfName), (Throwable)e);
                }
            }
        }
        return tables;
    }

    private Map<String, UserType> buildUserTypes(Metadata metadata, List<Row> udtRows) {
        LinkedHashMap<String, UserType> userTypes = new LinkedHashMap<String, UserType>();
        if (udtRows != null) {
            ProtocolVersion protocolVersion = metadata.cluster.protocolVersion();
            CodecRegistry codecRegistry = metadata.cluster.configuration.getCodecRegistry();
            for (Row udtRow : udtRows) {
                UserType type = UserType.build(udtRow, protocolVersion, codecRegistry);
                userTypes.put(type.getTypeName(), type);
            }
        }
        return userTypes;
    }

    private Map<String, FunctionMetadata> buildFunctions(Metadata metadata, KeyspaceMetadata keyspace, List<Row> functionRows) {
        LinkedHashMap<String, FunctionMetadata> functions = new LinkedHashMap<String, FunctionMetadata>();
        if (functionRows != null) {
            ProtocolVersion protocolVersion = metadata.cluster.protocolVersion();
            CodecRegistry codecRegistry = metadata.cluster.configuration.getCodecRegistry();
            for (Row functionRow : functionRows) {
                FunctionMetadata function = FunctionMetadata.build(keyspace, functionRow, protocolVersion, codecRegistry);
                if (function == null) continue;
                functions.put(function.getFullName(), function);
            }
        }
        return functions;
    }

    private Map<String, AggregateMetadata> buildAggregates(Metadata metadata, KeyspaceMetadata keyspace, List<Row> aggregateRows) {
        LinkedHashMap<String, AggregateMetadata> aggregates = new LinkedHashMap<String, AggregateMetadata>();
        if (aggregateRows != null) {
            ProtocolVersion protocolVersion = metadata.cluster.protocolVersion();
            CodecRegistry codecRegistry = metadata.cluster.configuration.getCodecRegistry();
            for (Row aggregateRow : aggregateRows) {
                AggregateMetadata aggregate = AggregateMetadata.build(keyspace, aggregateRow, protocolVersion, codecRegistry);
                if (aggregate == null) continue;
                aggregates.put(aggregate.getFullName(), aggregate);
            }
        }
        return aggregates;
    }

    private Map<String, MaterializedViewMetadata> buildViews(KeyspaceMetadata keyspace, List<Row> viewRows, Map<String, Map<String, ColumnMetadata.Raw>> colsDefs, VersionNumber cassandraVersion) {
        LinkedHashMap<String, MaterializedViewMetadata> views = new LinkedHashMap<String, MaterializedViewMetadata>();
        if (viewRows != null) {
            for (Row viewRow : viewRows) {
                String viewName = viewRow.getString("view_name");
                try {
                    MaterializedViewMetadata view;
                    Map<String, ColumnMetadata.Raw> cols = colsDefs.get(viewName);
                    if (cols == null || cols.isEmpty() || (view = MaterializedViewMetadata.build(keyspace, viewRow, cols, cassandraVersion)) == null) continue;
                    views.put(view.getName(), view);
                }
                catch (RuntimeException e) {
                    logger.error(String.format("Error parsing schema for view %s.%s: Cluster.getMetadata().getKeyspace(\"%s\").getView(\"%s\") will be missing or incomplete", keyspace.getName(), viewName, keyspace.getName(), viewName), (Throwable)e);
                }
            }
        }
        return views;
    }

    private void updateKeyspaces(Metadata metadata, Map<String, KeyspaceMetadata> oldKeyspaces, Map<String, KeyspaceMetadata> newKeyspaces, String keyspaceToRebuild) {
        Iterator<KeyspaceMetadata> it = oldKeyspaces.values().iterator();
        while (it.hasNext()) {
            KeyspaceMetadata oldKeyspace = it.next();
            String keyspaceName = oldKeyspace.getName();
            if (keyspaceToRebuild != null && !keyspaceToRebuild.equals(keyspaceName) || newKeyspaces.containsKey(keyspaceName)) continue;
            it.remove();
            metadata.triggerOnKeyspaceRemoved(oldKeyspace);
        }
        for (KeyspaceMetadata newKeyspace : newKeyspaces.values()) {
            KeyspaceMetadata oldKeyspace = oldKeyspaces.put(newKeyspace.getName(), newKeyspace);
            if (oldKeyspace == null) {
                metadata.triggerOnKeyspaceAdded(newKeyspace);
            } else if (!oldKeyspace.equals(newKeyspace)) {
                metadata.triggerOnKeyspaceChanged(newKeyspace, oldKeyspace);
            }
            HashMap<String, TableMetadata> oldTables = oldKeyspace == null ? new HashMap() : oldKeyspace.tables;
            this.updateTables(metadata, oldTables, newKeyspace.tables, null);
            HashMap<String, UserType> oldTypes = oldKeyspace == null ? new HashMap() : oldKeyspace.userTypes;
            this.updateUserTypes(metadata, oldTypes, newKeyspace.userTypes, null);
            HashMap<String, FunctionMetadata> oldFunctions = oldKeyspace == null ? new HashMap() : oldKeyspace.functions;
            this.updateFunctions(metadata, oldFunctions, newKeyspace.functions, null);
            HashMap<String, AggregateMetadata> oldAggregates = oldKeyspace == null ? new HashMap() : oldKeyspace.aggregates;
            this.updateAggregates(metadata, oldAggregates, newKeyspace.aggregates, null);
            HashMap<String, MaterializedViewMetadata> oldViews = oldKeyspace == null ? new HashMap() : oldKeyspace.views;
            this.updateViews(metadata, oldViews, newKeyspace.views, null);
        }
    }

    private void updateTables(Metadata metadata, Map<String, TableMetadata> oldTables, Map<String, TableMetadata> newTables, String tableToRebuild) {
        Iterator<TableMetadata> it = oldTables.values().iterator();
        while (it.hasNext()) {
            TableMetadata oldTable = it.next();
            String tableName = oldTable.getName();
            if (tableToRebuild != null && !tableToRebuild.equals(tableName) || newTables.containsKey(tableName)) continue;
            it.remove();
            metadata.triggerOnTableRemoved(oldTable);
        }
        for (TableMetadata newTable : newTables.values()) {
            TableMetadata oldTable = oldTables.put(newTable.getName(), newTable);
            if (oldTable == null) {
                metadata.triggerOnTableAdded(newTable);
                continue;
            }
            if (oldTable.equals(newTable)) continue;
            metadata.triggerOnTableChanged(newTable, oldTable);
        }
    }

    private void updateUserTypes(Metadata metadata, Map<String, UserType> oldTypes, Map<String, UserType> newTypes, String typeToRebuild) {
        Iterator<UserType> it = oldTypes.values().iterator();
        while (it.hasNext()) {
            UserType oldType = it.next();
            String typeName = oldType.getTypeName();
            if (typeToRebuild != null && !typeToRebuild.equals(typeName) || newTypes.containsKey(typeName)) continue;
            it.remove();
            metadata.triggerOnUserTypeRemoved(oldType);
        }
        for (UserType newType : newTypes.values()) {
            UserType oldType = oldTypes.put(newType.getTypeName(), newType);
            if (oldType == null) {
                metadata.triggerOnUserTypeAdded(newType);
                continue;
            }
            if (newType.equals(oldType)) continue;
            metadata.triggerOnUserTypeChanged(newType, oldType);
        }
    }

    private void updateFunctions(Metadata metadata, Map<String, FunctionMetadata> oldFunctions, Map<String, FunctionMetadata> newFunctions, String functionToRebuild) {
        Iterator<FunctionMetadata> it = oldFunctions.values().iterator();
        while (it.hasNext()) {
            FunctionMetadata oldFunction = it.next();
            String functionName = oldFunction.getFullName();
            if (functionToRebuild != null && !functionToRebuild.equals(functionName) || newFunctions.containsKey(functionName)) continue;
            it.remove();
            metadata.triggerOnFunctionRemoved(oldFunction);
        }
        for (FunctionMetadata newFunction : newFunctions.values()) {
            FunctionMetadata oldFunction = oldFunctions.put(newFunction.getFullName(), newFunction);
            if (oldFunction == null) {
                metadata.triggerOnFunctionAdded(newFunction);
                continue;
            }
            if (newFunction.equals(oldFunction)) continue;
            metadata.triggerOnFunctionChanged(newFunction, oldFunction);
        }
    }

    private void updateAggregates(Metadata metadata, Map<String, AggregateMetadata> oldAggregates, Map<String, AggregateMetadata> newAggregates, String aggregateToRebuild) {
        Iterator<AggregateMetadata> it = oldAggregates.values().iterator();
        while (it.hasNext()) {
            AggregateMetadata oldAggregate = it.next();
            String aggregateName = oldAggregate.getFullName();
            if (aggregateToRebuild != null && !aggregateToRebuild.equals(aggregateName) || newAggregates.containsKey(aggregateName)) continue;
            it.remove();
            metadata.triggerOnAggregateRemoved(oldAggregate);
        }
        for (AggregateMetadata newAggregate : newAggregates.values()) {
            AggregateMetadata oldAggregate = oldAggregates.put(newAggregate.getFullName(), newAggregate);
            if (oldAggregate == null) {
                metadata.triggerOnAggregateAdded(newAggregate);
                continue;
            }
            if (newAggregate.equals(oldAggregate)) continue;
            metadata.triggerOnAggregateChanged(newAggregate, oldAggregate);
        }
    }

    private void updateViews(Metadata metadata, Map<String, MaterializedViewMetadata> oldViews, Map<String, MaterializedViewMetadata> newViews, String viewToRebuild) {
        Iterator<MaterializedViewMetadata> it = oldViews.values().iterator();
        while (it.hasNext()) {
            MaterializedViewMetadata oldView = it.next();
            String aggregateName = oldView.getName();
            if (viewToRebuild != null && !viewToRebuild.equals(aggregateName) || newViews.containsKey(aggregateName)) continue;
            it.remove();
            metadata.triggerOnMaterializedViewRemoved(oldView);
        }
        for (MaterializedViewMetadata newView : newViews.values()) {
            MaterializedViewMetadata oldView = oldViews.put(newView.getName(), newView);
            if (oldView == null) {
                metadata.triggerOnMaterializedViewAdded(newView);
                continue;
            }
            if (newView.equals(oldView)) continue;
            metadata.triggerOnMaterializedViewChanged(newView, oldView);
        }
    }

    static Map<String, List<Row>> groupByKeyspace(ResultSet rs) {
        if (rs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Row>> result = new HashMap<String, List<Row>>();
        for (Row row : rs) {
            String ksName = row.getString("keyspace_name");
            ArrayList<Row> l = (ArrayList<Row>)result.get(ksName);
            if (l == null) {
                l = new ArrayList<Row>();
                result.put(ksName, l);
            }
            l.add(row);
        }
        return result;
    }

    static Map<String, Map<String, List<Row>>> groupByKeyspaceAndCf(ResultSet rs, String tableName) {
        if (rs == null) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (Row row : rs) {
            List l;
            String ksName = row.getString("keyspace_name");
            String cfName = row.getString(tableName);
            Map rowsByCf = (Map)result.get(ksName);
            if (rowsByCf == null) {
                rowsByCf = Maps.newHashMap();
                result.put(ksName, rowsByCf);
            }
            if ((l = (List)rowsByCf.get(cfName)) == null) {
                l = Lists.newArrayList();
                rowsByCf.put(cfName, l);
            }
            l.add(row);
        }
        return result;
    }

    static Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> groupByKeyspaceAndCf(ResultSet rs, VersionNumber cassandraVersion, ProtocolVersion protocolVersion, CodecRegistry codecRegistry, String tableName) {
        if (rs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Map<String, ColumnMetadata.Raw>>> result = new HashMap<String, Map<String, Map<String, ColumnMetadata.Raw>>>();
        for (Row row : rs) {
            HashMap<String, ColumnMetadata.Raw> l;
            String ksName = row.getString("keyspace_name");
            String cfName = row.getString(tableName);
            HashMap colsByCf = (HashMap)result.get(ksName);
            if (colsByCf == null) {
                colsByCf = new HashMap();
                result.put(ksName, colsByCf);
            }
            if ((l = (HashMap<String, ColumnMetadata.Raw>)colsByCf.get(cfName)) == null) {
                l = new HashMap<String, ColumnMetadata.Raw>();
                colsByCf.put(cfName, l);
            }
            ColumnMetadata.Raw c = ColumnMetadata.Raw.fromRow(row, cassandraVersion, protocolVersion, codecRegistry);
            l.put(c.name, c);
        }
        return result;
    }

    private static ResultSetFuture queryAsync(String query, Connection connection, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException {
        DefaultResultSetFuture future = new DefaultResultSetFuture(null, protocolVersion, new Requests.Query(query));
        connection.write(future);
        return future;
    }

    private static ResultSet get(ResultSetFuture future) throws InterruptedException, ExecutionException {
        return future == null ? null : (ResultSet)future.get();
    }

    private static class V3SchemaParser
    extends SchemaParser {
        private static final String SELECT_KEYSPACES = "SELECT * FROM system_schema.keyspaces";
        private static final String SELECT_TABLES = "SELECT * FROM system_schema.tables";
        private static final String SELECT_COLUMNS = "SELECT * FROM system_schema.columns";
        private static final String SELECT_USERTYPES = "SELECT * FROM system_schema.types";
        private static final String SELECT_FUNCTIONS = "SELECT * FROM system_schema.functions";
        private static final String SELECT_AGGREGATES = "SELECT * FROM system_schema.aggregates";
        private static final String SELECT_INDEXES = "SELECT * FROM system_schema.indexes";
        private static final String SELECT_VIEWS = "SELECT * FROM system_schema.views";
        private static final String TABLE_NAME = "table_name";

        private V3SchemaParser() {
        }

        @Override
        SystemRows fetchSystemRows(Metadata metadata, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature, Connection connection, VersionNumber cassandraVersion) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException {
            boolean isSchemaOrKeyspace = targetType == null || targetType == SchemaElement.KEYSPACE;
            ProtocolVersion protocolVersion = metadata.cluster.protocolVersion();
            CodecRegistry codecRegistry = metadata.cluster.configuration.getCodecRegistry();
            ResultSetFuture ksFuture = null;
            ResultSetFuture udtFuture = null;
            ResultSetFuture cfFuture = null;
            ResultSetFuture colsFuture = null;
            ResultSetFuture functionsFuture = null;
            ResultSetFuture aggregatesFuture = null;
            ResultSetFuture indexesFuture = null;
            ResultSetFuture viewsFuture = null;
            if (isSchemaOrKeyspace) {
                ksFuture = SchemaParser.queryAsync(SELECT_KEYSPACES + this.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.TYPE) {
                udtFuture = SchemaParser.queryAsync(SELECT_USERTYPES + this.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.TABLE) {
                cfFuture = SchemaParser.queryAsync(SELECT_TABLES + this.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
                colsFuture = SchemaParser.queryAsync(SELECT_COLUMNS + this.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
                indexesFuture = SchemaParser.queryAsync(SELECT_INDEXES + this.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
                viewsFuture = SchemaParser.queryAsync(SELECT_VIEWS + this.whereClause(targetType == SchemaElement.TABLE ? SchemaElement.VIEW : targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.FUNCTION) {
                functionsFuture = SchemaParser.queryAsync(SELECT_FUNCTIONS + this.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.AGGREGATE) {
                aggregatesFuture = SchemaParser.queryAsync(SELECT_AGGREGATES + this.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            return new SystemRows(SchemaParser.get(ksFuture), V3SchemaParser.groupByKeyspace(SchemaParser.get(cfFuture)), V3SchemaParser.groupByKeyspaceAndCf(SchemaParser.get(colsFuture), cassandraVersion, protocolVersion, codecRegistry, TABLE_NAME), V3SchemaParser.groupByKeyspace(SchemaParser.get(udtFuture)), V3SchemaParser.groupByKeyspace(SchemaParser.get(functionsFuture)), V3SchemaParser.groupByKeyspace(SchemaParser.get(aggregatesFuture)), V3SchemaParser.groupByKeyspace(SchemaParser.get(viewsFuture)), V3SchemaParser.groupByKeyspaceAndCf(SchemaParser.get(indexesFuture), TABLE_NAME));
        }

        @Override
        String tableNameColumn() {
            return TABLE_NAME;
        }

        private String whereClause(SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature) {
            String whereClause = "";
            if (targetType != null) {
                whereClause = " WHERE keyspace_name = '" + targetKeyspace + '\'';
                if (targetType == SchemaElement.TABLE) {
                    whereClause = whereClause + " AND table_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.VIEW) {
                    whereClause = whereClause + " AND view_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.TYPE) {
                    whereClause = whereClause + " AND type_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.FUNCTION) {
                    whereClause = whereClause + " AND function_name = '" + targetName + "' AND signature = " + LIST_OF_TEXT_CODEC.format(targetSignature);
                } else if (targetType == SchemaElement.AGGREGATE) {
                    whereClause = whereClause + " AND aggregate_name = '" + targetName + "' AND signature = " + LIST_OF_TEXT_CODEC.format(targetSignature);
                }
            }
            return whereClause;
        }
    }

    private static class V2SchemaParser
    extends SchemaParser {
        private static final String SELECT_KEYSPACES = "SELECT * FROM system.schema_keyspaces";
        private static final String SELECT_COLUMN_FAMILIES = "SELECT * FROM system.schema_columnfamilies";
        private static final String SELECT_COLUMNS = "SELECT * FROM system.schema_columns";
        private static final String SELECT_USERTYPES = "SELECT * FROM system.schema_usertypes";
        private static final String SELECT_FUNCTIONS = "SELECT * FROM system.schema_functions";
        private static final String SELECT_AGGREGATES = "SELECT * FROM system.schema_aggregates";
        private static final String CF_NAME = "columnfamily_name";

        private V2SchemaParser() {
        }

        @Override
        SystemRows fetchSystemRows(Metadata metadata, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature, Connection connection, VersionNumber cassandraVersion) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException {
            boolean isSchemaOrKeyspace = targetType == null || targetType == SchemaElement.KEYSPACE;
            ProtocolVersion protocolVersion = metadata.cluster.protocolVersion();
            CodecRegistry codecRegistry = metadata.cluster.configuration.getCodecRegistry();
            String whereClause = "";
            if (targetType != null) {
                whereClause = " WHERE keyspace_name = '" + targetKeyspace + '\'';
                if (targetType == SchemaElement.TABLE) {
                    whereClause = whereClause + " AND columnfamily_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.TYPE) {
                    whereClause = whereClause + " AND type_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.FUNCTION) {
                    whereClause = whereClause + " AND function_name = '" + targetName + "' AND signature = " + LIST_OF_TEXT_CODEC.format(targetSignature);
                } else if (targetType == SchemaElement.AGGREGATE) {
                    whereClause = whereClause + " AND aggregate_name = '" + targetName + "' AND signature = " + LIST_OF_TEXT_CODEC.format(targetSignature);
                }
            }
            ResultSetFuture ksFuture = null;
            ResultSetFuture udtFuture = null;
            ResultSetFuture cfFuture = null;
            ResultSetFuture colsFuture = null;
            ResultSetFuture functionsFuture = null;
            ResultSetFuture aggregatesFuture = null;
            if (isSchemaOrKeyspace) {
                ksFuture = SchemaParser.queryAsync(SELECT_KEYSPACES + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace && this.supportsUdts(cassandraVersion) || targetType == SchemaElement.TYPE) {
                udtFuture = SchemaParser.queryAsync(SELECT_USERTYPES + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.TABLE) {
                cfFuture = SchemaParser.queryAsync(SELECT_COLUMN_FAMILIES + whereClause, connection, protocolVersion);
                colsFuture = SchemaParser.queryAsync(SELECT_COLUMNS + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace && this.supportsUdfs(cassandraVersion) || targetType == SchemaElement.FUNCTION) {
                functionsFuture = SchemaParser.queryAsync(SELECT_FUNCTIONS + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace && this.supportsUdfs(cassandraVersion) || targetType == SchemaElement.AGGREGATE) {
                aggregatesFuture = SchemaParser.queryAsync(SELECT_AGGREGATES + whereClause, connection, protocolVersion);
            }
            return new SystemRows(SchemaParser.get(ksFuture), V2SchemaParser.groupByKeyspace(SchemaParser.get(cfFuture)), V2SchemaParser.groupByKeyspaceAndCf(SchemaParser.get(colsFuture), cassandraVersion, protocolVersion, codecRegistry, CF_NAME), V2SchemaParser.groupByKeyspace(SchemaParser.get(udtFuture)), V2SchemaParser.groupByKeyspace(SchemaParser.get(functionsFuture)), V2SchemaParser.groupByKeyspace(SchemaParser.get(aggregatesFuture)), Collections.<String, List<Row>>emptyMap(), Collections.<String, Map<String, List<Row>>>emptyMap());
        }

        @Override
        String tableNameColumn() {
            return CF_NAME;
        }

        private boolean supportsUdts(VersionNumber cassandraVersion) {
            return cassandraVersion.getMajor() > 2 || cassandraVersion.getMajor() == 2 && cassandraVersion.getMinor() >= 1;
        }

        private boolean supportsUdfs(VersionNumber cassandraVersion) {
            return cassandraVersion.getMajor() > 2 || cassandraVersion.getMajor() == 2 && cassandraVersion.getMinor() >= 2;
        }
    }

    private static class SystemRows {
        final ResultSet keyspaces;
        final Map<String, List<Row>> tables;
        final Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> columns;
        final Map<String, List<Row>> udts;
        final Map<String, List<Row>> functions;
        final Map<String, List<Row>> aggregates;
        final Map<String, List<Row>> views;
        final Map<String, Map<String, List<Row>>> indexes;

        public SystemRows(ResultSet keyspaces, Map<String, List<Row>> tables, Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> columns, Map<String, List<Row>> udts, Map<String, List<Row>> functions, Map<String, List<Row>> aggregates, Map<String, List<Row>> views, Map<String, Map<String, List<Row>>> indexes) {
            this.keyspaces = keyspaces;
            this.tables = tables;
            this.columns = columns;
            this.udts = udts;
            this.functions = functions;
            this.aggregates = aggregates;
            this.views = views;
            this.indexes = indexes;
        }
    }
}

