/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CassandraTypeParser;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.IndexMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.VersionNumber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ColumnMetadata {
    static final String COLUMN_NAME = "column_name";
    static final String VALIDATOR = "validator";
    static final String COMPONENT_INDEX = "component_index";
    static final String KIND = "type";
    static final String INDEX_TYPE = "index_type";
    static final String INDEX_OPTIONS = "index_options";
    static final String INDEX_NAME = "index_name";
    private final TableMetadata table;
    private final String name;
    private final DataType type;
    private final boolean isStatic;
    final Map<String, IndexMetadata> indexes = new LinkedHashMap<String, IndexMetadata>();

    private ColumnMetadata(TableMetadata table, String name, DataType type, boolean isStatic) {
        this.table = table;
        this.name = name;
        this.type = type;
        this.isStatic = isStatic;
    }

    static ColumnMetadata fromRaw(TableMetadata tm, Raw raw) {
        return new ColumnMetadata(tm, raw.name, raw.dataType, raw.kind == Raw.Kind.STATIC);
    }

    static ColumnMetadata forAlias(TableMetadata tm, String name, DataType type) {
        return new ColumnMetadata(tm, name, type, false);
    }

    public String getName() {
        return this.name;
    }

    public TableMetadata getTable() {
        return this.table;
    }

    public DataType getType() {
        return this.type;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public IndexMetadata getIndex(String name) {
        return this.indexes.get(Metadata.handleId(name));
    }

    public List<IndexMetadata> getIndexes() {
        return new ArrayList<IndexMetadata>(this.indexes.values());
    }

    public String toString() {
        String str = Metadata.escapeId(this.name) + ' ' + this.type;
        return this.isStatic ? str + " static" : str;
    }

    static class Raw {
        public final String name;
        public Kind kind;
        public final int componentIndex;
        public final DataType dataType;
        public final boolean isReversed;
        public final Map<String, String> indexColumns = new HashMap<String, String>();

        Raw(String name, Kind kind, int componentIndex, DataType dataType, boolean isReversed) {
            this.name = name;
            this.kind = kind;
            this.componentIndex = componentIndex;
            this.dataType = dataType;
            this.isReversed = isReversed;
        }

        static Raw fromRow(Row row, VersionNumber version, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
            String name = row.getString(ColumnMetadata.COLUMN_NAME);
            Kind kind = version.getMajor() < 2 || row.isNull(ColumnMetadata.KIND) ? Kind.REGULAR : (version.getMajor() < 3 ? Kind.fromStringV2(row.getString(ColumnMetadata.KIND)) : Kind.fromStringV3(row.getString(ColumnMetadata.KIND)));
            int componentIndex = row.isNull(ColumnMetadata.COMPONENT_INDEX) ? 0 : row.getInt(ColumnMetadata.COMPONENT_INDEX);
            String validatorStr = row.getString(ColumnMetadata.VALIDATOR);
            boolean reversed = CassandraTypeParser.isReversed(validatorStr);
            DataType dataType = CassandraTypeParser.parseOne(validatorStr, protocolVersion, codecRegistry);
            Raw c = new Raw(name, kind, componentIndex, dataType, reversed);
            for (String str : Arrays.asList(ColumnMetadata.INDEX_TYPE, ColumnMetadata.INDEX_NAME, ColumnMetadata.INDEX_OPTIONS)) {
                if (!row.getColumnDefinitions().contains(str) || row.isNull(str)) continue;
                c.indexColumns.put(str, row.getString(str));
            }
            return c;
        }

        public static enum Kind {
            PARTITION_KEY("PARTITION_KEY", "PARTITION_KEY"),
            CLUSTERING_COLUMN("CLUSTERING_KEY", "CLUSTERING"),
            REGULAR("REGULAR", "REGULAR"),
            COMPACT_VALUE("COMPACT_VALUE", ""),
            STATIC("STATIC", "STATIC");

            final String v2;
            final String v3;

            private Kind(String v2, String v3) {
                this.v2 = v2;
                this.v3 = v3;
            }

            static Kind fromStringV2(String s) {
                for (Kind kind : Kind.values()) {
                    if (!kind.v2.equalsIgnoreCase(s)) continue;
                    return kind;
                }
                throw new IllegalArgumentException(s);
            }

            static Kind fromStringV3(String s) {
                for (Kind kind : Kind.values()) {
                    if (!kind.v3.equalsIgnoreCase(s)) continue;
                    return kind;
                }
                throw new IllegalArgumentException(s);
            }
        }
    }
}

