/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Using;
import com.datastax.driver.core.querybuilder.Utils;
import java.util.ArrayList;
import java.util.List;

public class Delete
extends BuiltStatement {
    private final String table;
    private final List<Selector> columns;
    private final Where where;
    private final Options usings;
    private final Conditions conditions;
    private boolean ifExists;

    Delete(Cluster cluster, String keyspace, String table, List<Selector> columns) {
        super(keyspace, cluster);
        this.table = table;
        this.columns = columns;
        this.where = new Where(this);
        this.usings = new Options(this);
        this.conditions = new Conditions(this);
    }

    Delete(Cluster cluster, TableMetadata table, List<Selector> columns) {
        super(table, cluster);
        this.table = this.escapeId(table.getName());
        this.columns = columns;
        this.where = new Where(this);
        this.usings = new Options(this);
        this.conditions = new Conditions(this);
    }

    @Override
    StringBuilder buildQueryString(List<Object> variables) {
        StringBuilder builder = new StringBuilder();
        CodecRegistry codecRegistry = this.getCodecRegistry();
        builder.append("DELETE");
        if (!this.columns.isEmpty()) {
            Utils.joinAndAppend(builder.append(" "), codecRegistry, ",", this.columns, variables);
        }
        builder.append(" FROM ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append('.');
        }
        Utils.appendName(this.table, builder);
        if (!this.usings.usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.usings.usings, variables);
        }
        if (!this.where.clauses.isEmpty()) {
            builder.append(" WHERE ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.where.clauses, variables);
        }
        if (this.ifExists) {
            builder.append(" IF EXISTS ");
        }
        if (!this.conditions.conditions.isEmpty()) {
            builder.append(" IF ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.conditions.conditions, variables);
        }
        return builder;
    }

    public Where where(Clause clause) {
        return this.where.and(clause);
    }

    public Where where() {
        return this.where;
    }

    public Conditions onlyIf(Clause condition) {
        return this.conditions.and(condition);
    }

    public Conditions onlyIf() {
        return this.conditions;
    }

    public Options using(Using using) {
        return this.usings.and(using);
    }

    public Options using() {
        return this.usings;
    }

    public Delete ifExists() {
        this.ifExists = true;
        return this;
    }

    public static class Conditions
    extends BuiltStatement.ForwardingStatement<Delete> {
        private final List<Clause> conditions = new ArrayList<Clause>();

        Conditions(Delete statement) {
            super(statement);
        }

        public Conditions and(Clause condition) {
            this.conditions.add(condition);
            this.checkForBindMarkers(condition);
            return this;
        }

        public Where where(Clause clause) {
            return ((Delete)this.statement).where(clause);
        }

        public Options using(Using using) {
            return ((Delete)this.statement).using(using);
        }
    }

    static class CollectionElementSelector
    extends Selector {
        private final Object key;

        CollectionElementSelector(String columnName, Object key) {
            super(columnName);
            this.key = key;
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> values, CodecRegistry codecRegistry) {
            super.appendTo(sb, values, codecRegistry);
            sb.append('[');
            Utils.appendValue(this.key, codecRegistry, sb, values);
            sb.append(']');
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.key);
        }
    }

    static class Selector
    extends Utils.Appendeable {
        private final String columnName;

        Selector(String columnName) {
            this.columnName = columnName;
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> values, CodecRegistry codecRegistry) {
            Utils.appendName(this.columnName, sb);
        }

        @Override
        boolean containsBindMarker() {
            return false;
        }

        public String toString() {
            return this.columnName;
        }
    }

    public static class Selection
    extends Builder {
        Selection(Cluster cluster) {
            super(cluster);
        }

        public Builder all() {
            if (!this.columns.isEmpty()) {
                throw new IllegalStateException(String.format("Some columns (%s) have already been selected.", this.columns));
            }
            return this;
        }

        public Selection column(String columnName) {
            this.columns.add(new Selector(columnName));
            return this;
        }

        public Selection listElt(String columnName, int idx) {
            this.columns.add(new CollectionElementSelector(columnName, idx));
            return this;
        }

        public Selection listElt(String columnName, BindMarker idx) {
            this.columns.add(new CollectionElementSelector(columnName, idx));
            return this;
        }

        public Selection setElt(String columnName, Object element) {
            this.columns.add(new CollectionElementSelector(columnName, element));
            return this;
        }

        public Selection setElt(String columnName, BindMarker element) {
            this.columns.add(new CollectionElementSelector(columnName, element));
            return this;
        }

        public Selection mapElt(String columnName, Object key) {
            this.columns.add(new CollectionElementSelector(columnName, key));
            return this;
        }
    }

    public static class Builder {
        private final Cluster cluster;
        List<Selector> columns = new ArrayList<Selector>();

        Builder(Cluster cluster) {
            this.cluster = cluster;
        }

        Builder(Cluster cluster, String ... columnNames) {
            this.cluster = cluster;
            for (String columnName : columnNames) {
                this.columns.add(new Selector(columnName));
            }
        }

        public Delete from(String table) {
            return this.from(null, table);
        }

        public Delete from(String keyspace, String table) {
            return new Delete(this.cluster, keyspace, table, this.columns);
        }

        public Delete from(TableMetadata table) {
            return new Delete(this.cluster, table, this.columns);
        }
    }

    public static class Options
    extends BuiltStatement.ForwardingStatement<Delete> {
        private final List<Using> usings = new ArrayList<Using>();

        Options(Delete statement) {
            super(statement);
        }

        public Options and(Using using) {
            this.usings.add(using);
            this.checkForBindMarkers(using);
            return this;
        }

        public Where where(Clause clause) {
            return ((Delete)this.statement).where(clause);
        }
    }

    public static class Where
    extends BuiltStatement.ForwardingStatement<Delete> {
        private final List<Clause> clauses = new ArrayList<Clause>();

        Where(Delete statement) {
            super(statement);
        }

        public Where and(Clause clause) {
            this.clauses.add(clause);
            ((Delete)this.statement).maybeAddRoutingKey(clause.name(), clause.firstValue());
            this.checkForBindMarkers(clause);
            return this;
        }

        public Options using(Using using) {
            return ((Delete)this.statement).using(using);
        }

        public Delete ifExists() {
            return ((Delete)this.statement).ifExists();
        }

        public Conditions onlyIf(Clause condition) {
            return ((Delete)this.statement).onlyIf(condition);
        }
    }
}

