/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AggregateMetadata;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SchemaElement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.VersionNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SchemaParser {
    private static final Logger logger = LoggerFactory.getLogger(SchemaParser.class);
    private static final TypeCodec.ListCodec<String> LIST_OF_TEXT_CODEC = new TypeCodec.ListCodec<String>(TypeCodec.VarcharCodec.instance);
    private static SchemaParser V2_PARSER = new SchemaParser(){
        private static final String SELECT_KEYSPACES = "SELECT * FROM system.schema_keyspaces";
        private static final String SELECT_COLUMN_FAMILIES = "SELECT * FROM system.schema_columnfamilies";
        private static final String SELECT_COLUMNS = "SELECT * FROM system.schema_columns";
        private static final String SELECT_USERTYPES = "SELECT * FROM system.schema_usertypes";
        private static final String SELECT_FUNCTIONS = "SELECT * FROM system.schema_functions";
        private static final String SELECT_AGGREGATES = "SELECT * FROM system.schema_aggregates";
        private static final String CF_NAME = "columnfamily_name";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        void refresh(Metadata metadata, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature, Connection connection, VersionNumber cassandraVersion) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException {
            boolean isSchemaOrKeyspace = targetType == null || targetType == SchemaElement.KEYSPACE;
            ProtocolVersion protocolVersion = metadata.cluster.protocolVersion();
            CodecRegistry codecRegistry = metadata.cluster.configuration.getCodecRegistry();
            String whereClause = "";
            if (targetType != null) {
                whereClause = " WHERE keyspace_name = '" + targetKeyspace + '\'';
                if (targetType == SchemaElement.TABLE) {
                    whereClause = whereClause + " AND columnfamily_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.TYPE) {
                    whereClause = whereClause + " AND type_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.FUNCTION) {
                    whereClause = whereClause + " AND function_name = '" + targetName + "' AND signature = " + LIST_OF_TEXT_CODEC.format(targetSignature);
                } else if (targetType == SchemaElement.AGGREGATE) {
                    whereClause = whereClause + " AND aggregate_name = '" + targetName + "' AND signature = " + LIST_OF_TEXT_CODEC.format(targetSignature);
                }
            }
            ResultSetFuture ksFuture = null;
            ResultSetFuture udtFuture = null;
            ResultSetFuture cfFuture = null;
            ResultSetFuture colsFuture = null;
            ResultSetFuture functionsFuture = null;
            ResultSetFuture aggregatesFuture = null;
            if (isSchemaOrKeyspace) {
                ksFuture = SchemaParser.queryAsync(SELECT_KEYSPACES + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace && this.supportsUdts(cassandraVersion) || targetType == SchemaElement.TYPE) {
                udtFuture = SchemaParser.queryAsync(SELECT_USERTYPES + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.TABLE) {
                cfFuture = SchemaParser.queryAsync(SELECT_COLUMN_FAMILIES + whereClause, connection, protocolVersion);
                colsFuture = SchemaParser.queryAsync(SELECT_COLUMNS + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace && this.supportsUdfs(cassandraVersion) || targetType == SchemaElement.FUNCTION) {
                functionsFuture = SchemaParser.queryAsync(SELECT_FUNCTIONS + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace && this.supportsUdfs(cassandraVersion) || targetType == SchemaElement.AGGREGATE) {
                aggregatesFuture = SchemaParser.queryAsync(SELECT_AGGREGATES + whereClause, connection, protocolVersion);
            }
            ResultSet ks = SchemaParser.get(ksFuture);
            Map<String, List<Row>> udtDefs = 1.groupByKeyspace(SchemaParser.get(udtFuture));
            Map<String, List<Row>> cfDefs = 1.groupByKeyspace(SchemaParser.get(cfFuture));
            Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> colsDefs = 1.groupByKeyspaceAndCf(SchemaParser.get(colsFuture), cassandraVersion, protocolVersion, codecRegistry, CF_NAME);
            Map<String, List<Row>> functionDefs = 1.groupByKeyspace(SchemaParser.get(functionsFuture));
            Map<String, List<Row>> aggregateDefs = 1.groupByKeyspace(SchemaParser.get(aggregatesFuture));
            metadata.lock.lock();
            try {
                if (targetType == null || targetType == SchemaElement.KEYSPACE) {
                    assert (ks != null);
                    HashSet<String> addedKs = new HashSet<String>();
                    for (Row ksRow : ks) {
                        String ksName = ksRow.getString("keyspace_name");
                        KeyspaceMetadata ksm = KeyspaceMetadata.buildV2(ksRow);
                        if (udtDefs.containsKey(ksName)) {
                            1.buildUserTypes(ksm, udtDefs.get(ksName), protocolVersion, codecRegistry);
                        }
                        if (cfDefs.containsKey(ksName)) {
                            1.buildTableMetadata(ksm, cfDefs.get(ksName), colsDefs.get(ksName), cassandraVersion, protocolVersion, codecRegistry, CF_NAME);
                        }
                        if (functionDefs.containsKey(ksName)) {
                            1.buildFunctionMetadata(ksm, functionDefs.get(ksName), protocolVersion, codecRegistry);
                        }
                        if (aggregateDefs.containsKey(ksName)) {
                            1.buildAggregateMetadata(ksm, aggregateDefs.get(ksName), protocolVersion, codecRegistry);
                        }
                        addedKs.add(ksName);
                        metadata.keyspaces.put(ksName, ksm);
                    }
                    if (targetKeyspace != null) return;
                    Iterator iter = metadata.keyspaces.keySet().iterator();
                    while (iter.hasNext()) {
                        if (addedKs.contains(iter.next())) continue;
                        iter.remove();
                    }
                    return;
                }
                assert (targetKeyspace != null);
                KeyspaceMetadata ksm = (KeyspaceMetadata)metadata.keyspaces.get(targetKeyspace);
                if (ksm == null) {
                    logger.error(String.format("Asked to rebuild %s %s.%s but I don't know keyspace %s", new Object[]{targetType, targetKeyspace, targetName, targetKeyspace}));
                    metadata.cluster.submitSchemaRefresh(null, null, null, null);
                    return;
                }
                switch (targetType) {
                    case TABLE: {
                        if (!cfDefs.containsKey(targetKeyspace)) return;
                        1.buildTableMetadata(ksm, cfDefs.get(targetKeyspace), colsDefs.get(targetKeyspace), cassandraVersion, protocolVersion, codecRegistry, CF_NAME);
                        return;
                    }
                    case TYPE: {
                        if (!udtDefs.containsKey(targetKeyspace)) return;
                        1.buildUserTypes(ksm, udtDefs.get(targetKeyspace), protocolVersion, codecRegistry);
                        return;
                    }
                    case FUNCTION: {
                        if (!functionDefs.containsKey(targetKeyspace)) return;
                        1.buildFunctionMetadata(ksm, functionDefs.get(targetKeyspace), protocolVersion, codecRegistry);
                        return;
                    }
                    case AGGREGATE: {
                        if (!functionDefs.containsKey(targetKeyspace)) return;
                        1.buildAggregateMetadata(ksm, aggregateDefs.get(targetKeyspace), protocolVersion, codecRegistry);
                        return;
                    }
                    default: {
                        logger.warn("Unexpected element type to rebuild: {}", (Object)targetType);
                        return;
                    }
                }
            }
            finally {
                metadata.lock.unlock();
            }
        }

        private boolean supportsUdts(VersionNumber cassandraVersion) {
            return cassandraVersion.getMajor() > 2 || cassandraVersion.getMajor() == 2 && cassandraVersion.getMinor() >= 1;
        }

        private boolean supportsUdfs(VersionNumber cassandraVersion) {
            return cassandraVersion.getMajor() > 2 || cassandraVersion.getMajor() == 2 && cassandraVersion.getMinor() >= 2;
        }
    };
    private static SchemaParser V3_PARSER = new SchemaParser(){
        private static final String SELECT_KEYSPACES = "SELECT * FROM system_schema.keyspaces";
        private static final String SELECT_TABLES = "SELECT * FROM system_schema.tables";
        private static final String SELECT_COLUMNS = "SELECT * FROM system_schema.columns";
        private static final String SELECT_USERTYPES = "SELECT * FROM system_schema.types";
        private static final String SELECT_FUNCTIONS = "SELECT * FROM system_schema.functions";
        private static final String SELECT_AGGREGATES = "SELECT * FROM system_schema.aggregates";
        private static final String TABLE_NAME = "table_name";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        void refresh(Metadata metadata, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature, Connection connection, VersionNumber cassandraVersion) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException {
            boolean isSchemaOrKeyspace = targetType == null || targetType == SchemaElement.KEYSPACE;
            ProtocolVersion protocolVersion = metadata.cluster.protocolVersion();
            CodecRegistry codecRegistry = metadata.cluster.configuration.getCodecRegistry();
            String whereClause = "";
            if (targetType != null) {
                whereClause = " WHERE keyspace_name = '" + targetKeyspace + '\'';
                if (targetType == SchemaElement.TABLE) {
                    whereClause = whereClause + " AND table_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.TYPE) {
                    whereClause = whereClause + " AND type_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.FUNCTION) {
                    whereClause = whereClause + " AND function_name = '" + targetName + "' AND signature = " + LIST_OF_TEXT_CODEC.format(targetSignature);
                } else if (targetType == SchemaElement.AGGREGATE) {
                    whereClause = whereClause + " AND aggregate_name = '" + targetName + "' AND signature = " + LIST_OF_TEXT_CODEC.format(targetSignature);
                }
            }
            ResultSetFuture ksFuture = null;
            ResultSetFuture udtFuture = null;
            ResultSetFuture cfFuture = null;
            ResultSetFuture colsFuture = null;
            ResultSetFuture functionsFuture = null;
            ResultSetFuture aggregatesFuture = null;
            if (isSchemaOrKeyspace) {
                ksFuture = SchemaParser.queryAsync(SELECT_KEYSPACES + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.TYPE) {
                udtFuture = SchemaParser.queryAsync(SELECT_USERTYPES + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.TABLE) {
                cfFuture = SchemaParser.queryAsync(SELECT_TABLES + whereClause, connection, protocolVersion);
                colsFuture = SchemaParser.queryAsync(SELECT_COLUMNS + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.FUNCTION) {
                functionsFuture = SchemaParser.queryAsync(SELECT_FUNCTIONS + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.AGGREGATE) {
                aggregatesFuture = SchemaParser.queryAsync(SELECT_AGGREGATES + whereClause, connection, protocolVersion);
            }
            ResultSet ks = SchemaParser.get(ksFuture);
            Map<String, List<Row>> udtDefs = 2.groupByKeyspace(SchemaParser.get(udtFuture));
            Map<String, List<Row>> cfDefs = 2.groupByKeyspace(SchemaParser.get(cfFuture));
            Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> colsDefs = 2.groupByKeyspaceAndCf(SchemaParser.get(colsFuture), cassandraVersion, protocolVersion, codecRegistry, TABLE_NAME);
            Map<String, List<Row>> functionDefs = 2.groupByKeyspace(SchemaParser.get(functionsFuture));
            Map<String, List<Row>> aggregateDefs = 2.groupByKeyspace(SchemaParser.get(aggregatesFuture));
            metadata.lock.lock();
            try {
                if (targetType == null || targetType == SchemaElement.KEYSPACE) {
                    assert (ks != null);
                    HashSet<String> addedKs = new HashSet<String>();
                    for (Row ksRow : ks) {
                        String ksName = ksRow.getString("keyspace_name");
                        KeyspaceMetadata ksm = KeyspaceMetadata.buildV3(ksRow);
                        if (udtDefs.containsKey(ksName)) {
                            2.buildUserTypes(ksm, udtDefs.get(ksName), protocolVersion, codecRegistry);
                        }
                        if (cfDefs.containsKey(ksName)) {
                            2.buildTableMetadata(ksm, cfDefs.get(ksName), colsDefs.get(ksName), cassandraVersion, protocolVersion, codecRegistry, TABLE_NAME);
                        }
                        if (functionDefs.containsKey(ksName)) {
                            2.buildFunctionMetadata(ksm, functionDefs.get(ksName), protocolVersion, codecRegistry);
                        }
                        if (aggregateDefs.containsKey(ksName)) {
                            2.buildAggregateMetadata(ksm, aggregateDefs.get(ksName), protocolVersion, codecRegistry);
                        }
                        addedKs.add(ksName);
                        metadata.keyspaces.put(ksName, ksm);
                    }
                    if (targetKeyspace != null) return;
                    Iterator iter = metadata.keyspaces.keySet().iterator();
                    while (iter.hasNext()) {
                        if (addedKs.contains(iter.next())) continue;
                        iter.remove();
                    }
                    return;
                }
                assert (targetKeyspace != null);
                KeyspaceMetadata ksm = (KeyspaceMetadata)metadata.keyspaces.get(targetKeyspace);
                if (ksm == null) {
                    logger.error(String.format("Asked to rebuild %s %s.%s but I don't know keyspace %s", new Object[]{targetType, targetKeyspace, targetName, targetKeyspace}));
                    metadata.cluster.submitSchemaRefresh(null, null, null, null);
                    return;
                }
                switch (targetType) {
                    case TABLE: {
                        if (!cfDefs.containsKey(targetKeyspace)) return;
                        2.buildTableMetadata(ksm, cfDefs.get(targetKeyspace), colsDefs.get(targetKeyspace), cassandraVersion, protocolVersion, codecRegistry, TABLE_NAME);
                        return;
                    }
                    case TYPE: {
                        if (!udtDefs.containsKey(targetKeyspace)) return;
                        2.buildUserTypes(ksm, udtDefs.get(targetKeyspace), protocolVersion, codecRegistry);
                        return;
                    }
                    case FUNCTION: {
                        if (!functionDefs.containsKey(targetKeyspace)) return;
                        2.buildFunctionMetadata(ksm, functionDefs.get(targetKeyspace), protocolVersion, codecRegistry);
                        return;
                    }
                    case AGGREGATE: {
                        if (!functionDefs.containsKey(targetKeyspace)) return;
                        2.buildAggregateMetadata(ksm, aggregateDefs.get(targetKeyspace), protocolVersion, codecRegistry);
                        return;
                    }
                    default: {
                        logger.warn("Unexpected element type to rebuild: {}", (Object)targetType);
                        return;
                    }
                }
            }
            finally {
                metadata.lock.unlock();
            }
        }
    };

    SchemaParser() {
    }

    static SchemaParser forVersion(VersionNumber cassandraVersion) {
        if (cassandraVersion.getMajor() >= 3) {
            return V3_PARSER;
        }
        return V2_PARSER;
    }

    abstract void refresh(Metadata var1, SchemaElement var2, String var3, String var4, List<String> var5, Connection var6, VersionNumber var7) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException;

    static void buildTableMetadata(KeyspaceMetadata ksm, List<Row> cfRows, Map<String, Map<String, ColumnMetadata.Raw>> colsDefs, VersionNumber cassandraVersion, ProtocolVersion protocolVersion, CodecRegistry codecRegistry, String tableName) {
        for (Row cfRow : cfRows) {
            String cfName = cfRow.getString(tableName);
            try {
                Map<String, ColumnMetadata.Raw> cols;
                Map<String, ColumnMetadata.Raw> map = cols = colsDefs == null ? null : colsDefs.get(cfName);
                if (cols == null || cols.isEmpty()) {
                    if (cassandraVersion.getMajor() >= 2) continue;
                    cols = Collections.emptyMap();
                }
                ksm.add(TableMetadata.build(ksm, cfRow, cols, tableName, cassandraVersion, protocolVersion, codecRegistry));
            }
            catch (RuntimeException e) {
                logger.error(String.format("Error parsing schema for table %s.%s: Cluster.getMetadata().getKeyspace(\"%s\").getTable(\"%s\") will be missing or incomplete", ksm.getName(), cfName, ksm.getName(), cfName), (Throwable)e);
            }
        }
    }

    static void buildUserTypes(KeyspaceMetadata ksm, List<Row> rows, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        for (Row row : rows) {
            ksm.add(UserType.build(row, protocolVersion, codecRegistry));
        }
    }

    static void buildFunctionMetadata(KeyspaceMetadata ksm, List<Row> rows, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        for (Row row : rows) {
            ksm.add(FunctionMetadata.build(ksm, row, protocolVersion, codecRegistry));
        }
    }

    static void buildAggregateMetadata(KeyspaceMetadata ksm, List<Row> rows, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        for (Row row : rows) {
            ksm.add(AggregateMetadata.build(ksm, row, protocolVersion, codecRegistry));
        }
    }

    static Map<String, List<Row>> groupByKeyspace(ResultSet rs) {
        if (rs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Row>> result = new HashMap<String, List<Row>>();
        for (Row row : rs) {
            String ksName = row.getString("keyspace_name");
            ArrayList<Row> l = (ArrayList<Row>)result.get(ksName);
            if (l == null) {
                l = new ArrayList<Row>();
                result.put(ksName, l);
            }
            l.add(row);
        }
        return result;
    }

    static Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> groupByKeyspaceAndCf(ResultSet rs, VersionNumber cassandraVersion, ProtocolVersion protocolVersion, CodecRegistry codecRegistry, String tableName) {
        if (rs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Map<String, ColumnMetadata.Raw>>> result = new HashMap<String, Map<String, Map<String, ColumnMetadata.Raw>>>();
        for (Row row : rs) {
            HashMap<String, ColumnMetadata.Raw> l;
            String ksName = row.getString("keyspace_name");
            String cfName = row.getString(tableName);
            HashMap colsByCf = (HashMap)result.get(ksName);
            if (colsByCf == null) {
                colsByCf = new HashMap();
                result.put(ksName, colsByCf);
            }
            if ((l = (HashMap<String, ColumnMetadata.Raw>)colsByCf.get(cfName)) == null) {
                l = new HashMap<String, ColumnMetadata.Raw>();
                colsByCf.put(cfName, l);
            }
            ColumnMetadata.Raw c = ColumnMetadata.Raw.fromRow(row, cassandraVersion, protocolVersion, codecRegistry);
            l.put(c.name, c);
        }
        return result;
    }

    private static ResultSetFuture queryAsync(String query, Connection connection, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException {
        DefaultResultSetFuture future = new DefaultResultSetFuture(null, protocolVersion, new Requests.Query(query));
        connection.write(future);
        return future;
    }

    private static ResultSet get(ResultSetFuture future) throws InterruptedException, ExecutionException {
        return future == null ? null : (ResultSet)future.get();
    }
}

