/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public final class DateWithoutTime {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final long millisSinceEpoch;
    private final int daysSinceEpoch;
    private volatile GregorianCalendar calendar;

    private DateWithoutTime(int daysSinceEpoch) {
        this.daysSinceEpoch = daysSinceEpoch;
        this.millisSinceEpoch = TimeUnit.DAYS.toMillis(daysSinceEpoch);
    }

    public static DateWithoutTime fromDaysSinceEpoch(int daysSinceEpoch) {
        return new DateWithoutTime(daysSinceEpoch);
    }

    public static DateWithoutTime fromMillisSinceEpoch(long millisSinceEpoch) throws IllegalArgumentException {
        long daysSinceEpoch = TimeUnit.MILLISECONDS.toDays(millisSinceEpoch);
        Preconditions.checkArgument((daysSinceEpoch >= Integer.MIN_VALUE && daysSinceEpoch <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Date should be in the range [-5877641-06-23; 5881580-07-11]");
        return new DateWithoutTime((int)daysSinceEpoch);
    }

    public static DateWithoutTime fromYearMonthDay(int year, int month, int dayOfMonth) {
        int calendarYear = year <= 0 ? -year + 1 : year;
        int calendarEra = year <= 0 ? 0 : 1;
        GregorianCalendar calendar = DateWithoutTime.isoCalendar();
        calendar.setLenient(false);
        calendar.clear();
        calendar.set(calendarYear, month - 1, dayOfMonth, 0, 0, 0);
        calendar.set(0, calendarEra);
        DateWithoutTime date = DateWithoutTime.fromMillisSinceEpoch(calendar.getTimeInMillis());
        date.calendar = calendar;
        return date;
    }

    public int getDaysSinceEpoch() {
        return this.daysSinceEpoch;
    }

    public long getMillisSinceEpoch() {
        return this.millisSinceEpoch;
    }

    public int getYear() {
        GregorianCalendar c = this.getCalendar();
        int year = c.get(1);
        if (c.get(0) == 0) {
            year = -year + 1;
        }
        return year;
    }

    public int getMonth() {
        return this.getCalendar().get(2) + 1;
    }

    public int getDay() {
        return this.getCalendar().get(5);
    }

    public DateWithoutTime plusYears(int years) {
        return this.add(1, years);
    }

    public DateWithoutTime plusMonths(int months) {
        return this.add(2, months);
    }

    public DateWithoutTime plusDays(int days) {
        return this.add(5, days);
    }

    private DateWithoutTime add(int field, int amount) {
        GregorianCalendar newCalendar = DateWithoutTime.isoCalendar();
        newCalendar.setTimeInMillis(this.millisSinceEpoch);
        newCalendar.add(field, amount);
        DateWithoutTime newDate = DateWithoutTime.fromMillisSinceEpoch(newCalendar.getTimeInMillis());
        newDate.calendar = newCalendar;
        return newDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DateWithoutTime) {
            DateWithoutTime that = (DateWithoutTime)o;
            return this.daysSinceEpoch == that.daysSinceEpoch;
        }
        return false;
    }

    public int hashCode() {
        return this.daysSinceEpoch;
    }

    public String toString() {
        return String.format("%d-%s-%s", this.getYear(), DateWithoutTime.pad2(this.getMonth()), DateWithoutTime.pad2(this.getDay()));
    }

    private static String pad2(int i) {
        String s = Integer.toString(i);
        return s.length() == 2 ? s : "0" + s;
    }

    private GregorianCalendar getCalendar() {
        if (this.calendar == null) {
            GregorianCalendar tmp = DateWithoutTime.isoCalendar();
            tmp.setTimeInMillis(this.millisSinceEpoch);
            this.calendar = tmp;
        }
        return this.calendar;
    }

    private static GregorianCalendar isoCalendar() {
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        return calendar;
    }
}

