/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CassandraTypeParser;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleJSONParser;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.VersionNumber;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ColumnMetadata {
    static final String COLUMN_NAME = "column_name";
    static final String VALIDATOR = "validator";
    static final String COMPONENT_INDEX = "component_index";
    static final String KIND = "type";
    static final String INDEX_TYPE = "index_type";
    static final String INDEX_OPTIONS = "index_options";
    static final String INDEX_NAME = "index_name";
    private static final String CUSTOM_INDEX_CLASS = "class_name";
    private static final String INDEX_MAP_KEYS = "index_keys";
    private static final String INDEX_MAP_ENTRIES = "index_keys_and_values";
    private final TableMetadata table;
    private final String name;
    private final DataType type;
    private final IndexMetadata index;
    private final boolean isStatic;

    private ColumnMetadata(TableMetadata table, String name, DataType type, boolean isStatic, Map<String, String> indexColumns) {
        this.table = table;
        this.name = name;
        this.type = type;
        this.isStatic = isStatic;
        this.index = IndexMetadata.build(this, indexColumns);
    }

    static ColumnMetadata fromRaw(TableMetadata tm, Raw raw) {
        return new ColumnMetadata(tm, raw.name, raw.dataType, raw.kind == Raw.Kind.STATIC, raw.indexColumns);
    }

    static ColumnMetadata forAlias(TableMetadata tm, String name, DataType type) {
        return new ColumnMetadata(tm, name, type, false, Collections.<String, String>emptyMap());
    }

    public String getName() {
        return this.name;
    }

    public TableMetadata getTable() {
        return this.table;
    }

    public DataType getType() {
        return this.type;
    }

    public IndexMetadata getIndex() {
        return this.index;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String toString() {
        String str = Metadata.escapeId(this.name) + ' ' + this.type;
        return this.isStatic ? str + " static" : str;
    }

    static class Raw {
        public final String name;
        public final Kind kind;
        public final int componentIndex;
        public final DataType dataType;
        public final boolean isReversed;
        public final Map<String, String> indexColumns = new HashMap<String, String>();

        Raw(String name, Kind kind, int componentIndex, DataType dataType, boolean isReversed) {
            this.name = name;
            this.kind = kind;
            this.componentIndex = componentIndex;
            this.dataType = dataType;
            this.isReversed = isReversed;
        }

        static Raw fromRow(Row row, VersionNumber version) {
            String name = row.getString(ColumnMetadata.COLUMN_NAME);
            Kind kind = version.getMajor() < 2 || row.isNull(ColumnMetadata.KIND) ? Kind.REGULAR : Enum.valueOf(Kind.class, row.getString(ColumnMetadata.KIND).toUpperCase());
            int componentIndex = row.isNull(ColumnMetadata.COMPONENT_INDEX) ? 0 : row.getInt(ColumnMetadata.COMPONENT_INDEX);
            String validatorStr = row.getString(ColumnMetadata.VALIDATOR);
            boolean reversed = CassandraTypeParser.isReversed(validatorStr);
            DataType dataType = CassandraTypeParser.parseOne(validatorStr);
            Raw c = new Raw(name, kind, componentIndex, dataType, reversed);
            for (String str : Arrays.asList(ColumnMetadata.INDEX_TYPE, ColumnMetadata.INDEX_NAME, ColumnMetadata.INDEX_OPTIONS)) {
                if (row.isNull(str)) continue;
                c.indexColumns.put(str, row.getString(str));
            }
            return c;
        }

        public static enum Kind {
            PARTITION_KEY,
            CLUSTERING_KEY,
            REGULAR,
            COMPACT_VALUE,
            STATIC;

        }
    }

    public static class IndexMetadata {
        private final ColumnMetadata column;
        private final String name;
        private final Map<String, String> indexOptions;

        private IndexMetadata(ColumnMetadata column, String name) {
            this(column, name, null);
        }

        private IndexMetadata(ColumnMetadata column, String name, Map<String, String> indexOptions) {
            this.column = column;
            this.name = name;
            this.indexOptions = indexOptions;
        }

        public ColumnMetadata getIndexedColumn() {
            return this.column;
        }

        public String getName() {
            return this.name;
        }

        public boolean isCustomIndex() {
            return this.getIndexClassName() != null;
        }

        public String getIndexClassName() {
            return this.getOption(ColumnMetadata.CUSTOM_INDEX_CLASS);
        }

        public boolean isKeys() {
            return this.getOption(ColumnMetadata.INDEX_MAP_KEYS) != null;
        }

        public boolean isFull() {
            return !this.isKeys() && !this.isEntries() && this.column.getType().isCollection() && this.column.getType().isFrozen();
        }

        public boolean isEntries() {
            return this.getOption(ColumnMetadata.INDEX_MAP_ENTRIES) != null;
        }

        public String getOption(String name) {
            return this.indexOptions != null ? this.indexOptions.get(name) : null;
        }

        public String asCQLQuery() {
            TableMetadata table = this.column.getTable();
            String ksName = Metadata.escapeId(table.getKeyspace().getName());
            String cfName = Metadata.escapeId(table.getName());
            String colName = Metadata.escapeId(this.column.getName());
            return this.isCustomIndex() ? String.format("CREATE CUSTOM INDEX %s ON %s.%s (%s) USING '%s' WITH OPTIONS = %s;", this.name, ksName, cfName, colName, this.getIndexClassName(), this.getOptionsAsCql()) : String.format("CREATE INDEX %s ON %s.%s (%s);", this.name, ksName, cfName, this.getIndexFunction(colName));
        }

        private String getOptionsAsCql() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            Iterator<Map.Entry<String, String>> it = this.indexOptions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> option = it.next();
                builder.append(String.format("'%s' : '%s'", option.getKey(), option.getValue()));
                if (!it.hasNext()) continue;
                builder.append(", ");
            }
            builder.append("}");
            return builder.toString();
        }

        private String getIndexFunction(String colName) {
            if (this.isKeys()) {
                return String.format("KEYS(%s)", colName);
            }
            if (this.isFull()) {
                return String.format("FULL(%s)", colName);
            }
            if (this.isEntries()) {
                return String.format("ENTRIES(%s)", colName);
            }
            return colName;
        }

        private static IndexMetadata build(ColumnMetadata column, Map<String, String> indexColumns) {
            if (indexColumns.isEmpty()) {
                return null;
            }
            String type = indexColumns.get(ColumnMetadata.INDEX_TYPE);
            if (type == null) {
                return null;
            }
            if (!indexColumns.containsKey(ColumnMetadata.INDEX_OPTIONS)) {
                return new IndexMetadata(column, indexColumns.get(ColumnMetadata.INDEX_NAME));
            }
            Map<String, String> indexOptions = SimpleJSONParser.parseStringMap(indexColumns.get(ColumnMetadata.INDEX_OPTIONS));
            return new IndexMetadata(column, indexColumns.get(ColumnMetadata.INDEX_NAME), indexOptions);
        }
    }
}

