/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.FrameCompressor;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SSLOptions;

public class ProtocolOptions {
    public static final int DEFAULT_PORT = 9042;
    @Deprecated
    public static final int NEWEST_SUPPORTED_PROTOCOL_VERSION = ProtocolVersion.NEWEST_SUPPORTED.toInt();
    private volatile Cluster.Manager manager;
    private final int port;
    final ProtocolVersion initialProtocolVersion;
    private final SSLOptions sslOptions;
    private final AuthProvider authProvider;
    private volatile Compression compression = Compression.NONE;

    public ProtocolOptions() {
        this(9042);
    }

    public ProtocolOptions(int port) {
        this(port, null, null, AuthProvider.NONE);
    }

    public ProtocolOptions(int port, ProtocolVersion protocolVersion, SSLOptions sslOptions, AuthProvider authProvider) {
        this.port = port;
        this.initialProtocolVersion = protocolVersion;
        this.sslOptions = sslOptions;
        this.authProvider = authProvider;
    }

    @Deprecated
    public ProtocolOptions(int port, int protocolVersion, SSLOptions sslOptions, AuthProvider authProvider) {
        this.port = port;
        this.initialProtocolVersion = ProtocolVersion.fromInt(protocolVersion);
        this.sslOptions = sslOptions;
        this.authProvider = authProvider;
    }

    void register(Cluster.Manager manager) {
        this.manager = manager;
    }

    public int getPort() {
        return this.port;
    }

    public ProtocolVersion getProtocolVersionEnum() {
        return this.manager.connectionFactory.protocolVersion;
    }

    @Deprecated
    public int getProtocolVersion() {
        return this.getProtocolVersionEnum().toInt();
    }

    public Compression getCompression() {
        return this.compression;
    }

    public ProtocolOptions setCompression(Compression compression) {
        if (compression != Compression.NONE && compression.compressor == null) {
            throw new IllegalStateException("The requested compression is not available (some compression require a JAR to be found in the classpath)");
        }
        this.compression = compression;
        return this;
    }

    public SSLOptions getSSLOptions() {
        return this.sslOptions;
    }

    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public static enum Compression {
        NONE("", null),
        SNAPPY("snappy", FrameCompressor.SnappyCompressor.instance),
        LZ4("lz4", FrameCompressor.LZ4Compressor.instance);

        final String protocolName;
        final FrameCompressor compressor;

        private Compression(String protocolName, FrameCompressor compressor) {
            this.protocolName = protocolName;
            this.compressor = compressor;
        }

        FrameCompressor compressor() {
            return this.compressor;
        }

        static Compression fromString(String str) {
            for (Compression c : Compression.values()) {
                if (!c.protocolName.equalsIgnoreCase(str)) continue;
                return c;
            }
            return null;
        }

        public String toString() {
            return this.protocolName;
        }
    }
}

