/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.ServerSideTimestampGenerator;
import com.datastax.driver.core.TimestampGenerator;
import com.datastax.driver.core.policies.AddressTranslater;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.IdentityTranslater;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.NoSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.google.common.base.Objects;

public class Policies {
    private static final ReconnectionPolicy DEFAULT_RECONNECTION_POLICY = new ExponentialReconnectionPolicy(1000L, 600000L);
    private static final RetryPolicy DEFAULT_RETRY_POLICY = DefaultRetryPolicy.INSTANCE;
    private static final AddressTranslater DEFAULT_ADDRESS_TRANSLATER = new IdentityTranslater();
    private static final SpeculativeExecutionPolicy DEFAULT_SPECULATIVE_EXECUTION_POLICY = NoSpeculativeExecutionPolicy.INSTANCE;
    private final LoadBalancingPolicy loadBalancingPolicy;
    private final ReconnectionPolicy reconnectionPolicy;
    private final RetryPolicy retryPolicy;
    private final AddressTranslater addressTranslater;
    private final TimestampGenerator timestampGenerator;
    private final SpeculativeExecutionPolicy speculativeExecutionPolicy;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public Policies(LoadBalancingPolicy loadBalancingPolicy, ReconnectionPolicy reconnectionPolicy, RetryPolicy retryPolicy, AddressTranslater addressTranslater, TimestampGenerator timestampGenerator, SpeculativeExecutionPolicy speculativeExecutionPolicy) {
        this.loadBalancingPolicy = loadBalancingPolicy;
        this.reconnectionPolicy = reconnectionPolicy;
        this.retryPolicy = retryPolicy;
        this.addressTranslater = addressTranslater;
        this.timestampGenerator = timestampGenerator;
        this.speculativeExecutionPolicy = speculativeExecutionPolicy;
    }

    public static LoadBalancingPolicy defaultLoadBalancingPolicy() {
        return new TokenAwarePolicy(DCAwareRoundRobinPolicy.builder().build());
    }

    public static ReconnectionPolicy defaultReconnectionPolicy() {
        return DEFAULT_RECONNECTION_POLICY;
    }

    public static RetryPolicy defaultRetryPolicy() {
        return DEFAULT_RETRY_POLICY;
    }

    public static AddressTranslater defaultAddressTranslater() {
        return DEFAULT_ADDRESS_TRANSLATER;
    }

    public static TimestampGenerator defaultTimestampGenerator() {
        return ServerSideTimestampGenerator.INSTANCE;
    }

    public static SpeculativeExecutionPolicy defaultSpeculativeExecutionPolicy() {
        return DEFAULT_SPECULATIVE_EXECUTION_POLICY;
    }

    public LoadBalancingPolicy getLoadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    public ReconnectionPolicy getReconnectionPolicy() {
        return this.reconnectionPolicy;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public AddressTranslater getAddressTranslater() {
        return this.addressTranslater;
    }

    public TimestampGenerator getTimestampGenerator() {
        return this.timestampGenerator;
    }

    public SpeculativeExecutionPolicy getSpeculativeExecutionPolicy() {
        return this.speculativeExecutionPolicy;
    }

    @Deprecated
    public Policies() {
        this(Policies.defaultLoadBalancingPolicy(), Policies.defaultReconnectionPolicy(), Policies.defaultRetryPolicy(), Policies.defaultAddressTranslater(), Policies.defaultTimestampGenerator(), Policies.defaultSpeculativeExecutionPolicy());
    }

    public Policies(LoadBalancingPolicy loadBalancingPolicy, ReconnectionPolicy reconnectionPolicy, RetryPolicy retryPolicy) {
        this(loadBalancingPolicy, reconnectionPolicy, retryPolicy, Policies.defaultAddressTranslater(), Policies.defaultTimestampGenerator(), Policies.defaultSpeculativeExecutionPolicy());
    }

    public Policies(LoadBalancingPolicy loadBalancingPolicy, ReconnectionPolicy reconnectionPolicy, RetryPolicy retryPolicy, AddressTranslater addressTranslater) {
        this(loadBalancingPolicy, reconnectionPolicy, retryPolicy, addressTranslater, Policies.defaultTimestampGenerator(), Policies.defaultSpeculativeExecutionPolicy());
    }

    public Policies(LoadBalancingPolicy loadBalancingPolicy, ReconnectionPolicy reconnectionPolicy, RetryPolicy retryPolicy, SpeculativeExecutionPolicy speculativeExecutionPolicy) {
        this(loadBalancingPolicy, reconnectionPolicy, retryPolicy, Policies.defaultAddressTranslater(), Policies.defaultTimestampGenerator(), speculativeExecutionPolicy);
    }

    public Policies(LoadBalancingPolicy loadBalancingPolicy, ReconnectionPolicy reconnectionPolicy, RetryPolicy retryPolicy, AddressTranslater addressTranslater, TimestampGenerator timestampGenerator) {
        this(loadBalancingPolicy, reconnectionPolicy, retryPolicy, addressTranslater, timestampGenerator, Policies.defaultSpeculativeExecutionPolicy());
    }

    public Policies(LoadBalancingPolicy loadBalancingPolicy, ReconnectionPolicy reconnectionPolicy, RetryPolicy retryPolicy, AddressTranslater addressTranslater, SpeculativeExecutionPolicy speculativeExecutionPolicy) {
        this(loadBalancingPolicy, reconnectionPolicy, retryPolicy, addressTranslater, Policies.defaultTimestampGenerator(), speculativeExecutionPolicy);
    }

    public static class Builder {
        private LoadBalancingPolicy loadBalancingPolicy;
        private ReconnectionPolicy reconnectionPolicy;
        private RetryPolicy retryPolicy;
        private AddressTranslater addressTranslater;
        private TimestampGenerator timestampGenerator;
        private SpeculativeExecutionPolicy speculativeExecutionPolicy;

        public Builder withLoadBalancingPolicy(LoadBalancingPolicy loadBalancingPolicy) {
            this.loadBalancingPolicy = loadBalancingPolicy;
            return this;
        }

        public Builder withReconnectionPolicy(ReconnectionPolicy reconnectionPolicy) {
            this.reconnectionPolicy = reconnectionPolicy;
            return this;
        }

        public Builder withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder withAddressTranslater(AddressTranslater addressTranslater) {
            this.addressTranslater = addressTranslater;
            return this;
        }

        public Builder withTimestampGenerator(TimestampGenerator timestampGenerator) {
            this.timestampGenerator = timestampGenerator;
            return this;
        }

        public Builder withSpeculativeExecutionPolicy(SpeculativeExecutionPolicy speculativeExecutionPolicy) {
            this.speculativeExecutionPolicy = speculativeExecutionPolicy;
            return this;
        }

        public Policies build() {
            return new Policies(this.loadBalancingPolicy == null ? Policies.defaultLoadBalancingPolicy() : this.loadBalancingPolicy, (ReconnectionPolicy)Objects.firstNonNull((Object)this.reconnectionPolicy, (Object)Policies.defaultReconnectionPolicy()), (RetryPolicy)Objects.firstNonNull((Object)this.retryPolicy, (Object)Policies.defaultRetryPolicy()), (AddressTranslater)Objects.firstNonNull((Object)this.addressTranslater, (Object)Policies.defaultAddressTranslater()), (TimestampGenerator)Objects.firstNonNull((Object)this.timestampGenerator, (Object)Policies.defaultTimestampGenerator()), (SpeculativeExecutionPolicy)Objects.firstNonNull((Object)this.speculativeExecutionPolicy, (Object)Policies.defaultSpeculativeExecutionPolicy()));
        }
    }
}

