/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;

class ProtocolEvent {
    public final Type type;

    private ProtocolEvent(Type type) {
        this.type = type;
    }

    public static ProtocolEvent deserialize(ByteBuf bb) {
        switch (CBUtil.readEnumValue(Type.class, bb)) {
            case TOPOLOGY_CHANGE: {
                return TopologyChange.deserializeEvent(bb);
            }
            case STATUS_CHANGE: {
                return StatusChange.deserializeEvent(bb);
            }
            case SCHEMA_CHANGE: {
                return SchemaChange.deserializeEvent(bb);
            }
        }
        throw new AssertionError();
    }

    public static class SchemaChange
    extends ProtocolEvent {
        public final Change change;
        public final String keyspace;
        public final String table;

        public SchemaChange(Change change, String keyspace, String table) {
            super(Type.SCHEMA_CHANGE);
            this.change = change;
            this.keyspace = keyspace;
            this.table = table;
        }

        private static SchemaChange deserializeEvent(ByteBuf bb) {
            Change change = CBUtil.readEnumValue(Change.class, bb);
            String keyspace = CBUtil.readString(bb);
            String table = CBUtil.readString(bb);
            return new SchemaChange(change, keyspace, table);
        }

        public String toString() {
            return (Object)((Object)this.change) + " " + this.keyspace + (this.table.isEmpty() ? "" : '.' + this.table);
        }

        public static enum Change {
            CREATED,
            UPDATED,
            DROPPED;

        }
    }

    public static class StatusChange
    extends ProtocolEvent {
        public final Status status;
        public final InetSocketAddress node;

        private StatusChange(Status status, InetSocketAddress node) {
            super(Type.STATUS_CHANGE);
            this.status = status;
            this.node = node;
        }

        private static StatusChange deserializeEvent(ByteBuf bb) {
            Status status = CBUtil.readEnumValue(Status.class, bb);
            InetSocketAddress node = CBUtil.readInet(bb);
            return new StatusChange(status, node);
        }

        public String toString() {
            return (Object)((Object)this.status) + " " + this.node;
        }

        public static enum Status {
            UP,
            DOWN;

        }
    }

    public static class TopologyChange
    extends ProtocolEvent {
        public final Change change;
        public final InetSocketAddress node;

        private TopologyChange(Change change, InetSocketAddress node) {
            super(Type.TOPOLOGY_CHANGE);
            this.change = change;
            this.node = node;
        }

        private static TopologyChange deserializeEvent(ByteBuf bb) {
            Change change = CBUtil.readEnumValue(Change.class, bb);
            InetSocketAddress node = CBUtil.readInet(bb);
            return new TopologyChange(change, node);
        }

        public String toString() {
            return (Object)((Object)this.change) + " " + this.node;
        }

        public static enum Change {
            NEW_NODE,
            REMOVED_NODE,
            MOVED_NODE;

        }
    }

    public static enum Type {
        TOPOLOGY_CHANGE,
        STATUS_CHANGE,
        SCHEMA_CHANGE;

    }
}

