/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Frame;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.exceptions.DriverInternalError;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Message {
    protected static final Logger logger = LoggerFactory.getLogger(Message.class);
    private volatile int streamId = -1;

    protected Message() {
    }

    public Message setStreamId(int streamId) {
        this.streamId = streamId;
        return this;
    }

    public int getStreamId() {
        return this.streamId;
    }

    @ChannelHandler.Sharable
    public static class ProtocolEncoder
    extends MessageToMessageEncoder<Request> {
        private final int protocolVersion;

        public ProtocolEncoder(int version) {
            this.protocolVersion = version;
        }

        protected void encode(ChannelHandlerContext ctx, Request request, List<Object> out) throws Exception {
            EnumSet<Frame.Header.Flag> flags = EnumSet.noneOf(Frame.Header.Flag.class);
            if (request.isTracingRequested()) {
                flags.add(Frame.Header.Flag.TRACING);
            }
            Coder<?> coder = request.type.coder(this.protocolVersion);
            ByteBuf body = ctx.alloc().buffer(coder.encodedSize(request));
            coder.encode(request, body);
            out.add(Frame.create(this.protocolVersion, request.type.opcode, request.getStreamId(), flags, body));
        }
    }

    @ChannelHandler.Sharable
    public static class ProtocolDecoder
    extends MessageToMessageDecoder<Frame> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void decode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            boolean isTracing = frame.header.flags.contains((Object)Frame.Header.Flag.TRACING);
            UUID tracingId = isTracing ? CBUtil.readUUID(frame.body) : null;
            try {
                Object response = Response.Type.fromOpcode(frame.header.opcode).decoder(frame.header.version).decode(frame.body);
                ((Response)response).setTracingId(tracingId).setStreamId(frame.header.streamId);
                out.add(response);
            }
            finally {
                frame.body.release();
            }
        }
    }

    public static abstract class Response
    extends Message {
        public final Type type;
        protected UUID tracingId;

        protected Response(Type type) {
            this.type = type;
        }

        public Response setTracingId(UUID tracingId) {
            this.tracingId = tracingId;
            return this;
        }

        public UUID getTracingId() {
            return this.tracingId;
        }

        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type ERROR = new Type(0, Responses.Error.decoder, Responses.Error.decoder);
            public static final /* enum */ Type READY = new Type(2, Responses.Ready.decoder, Responses.Ready.decoder);
            public static final /* enum */ Type AUTHENTICATE = new Type(3, Responses.Authenticate.decoder, Responses.Authenticate.decoder);
            public static final /* enum */ Type SUPPORTED = new Type(6, Responses.Supported.decoder, Responses.Supported.decoder);
            public static final /* enum */ Type RESULT = new Type(8, Responses.Result.decoderV1, Responses.Result.decoderV2);
            public static final /* enum */ Type EVENT = new Type(12, Responses.Event.decoder, Responses.Event.decoder);
            public static final /* enum */ Type AUTH_CHALLENGE = new Type(14, Responses.AuthChallenge.decoder, Responses.AuthChallenge.decoder);
            public static final /* enum */ Type AUTH_SUCCESS = new Type(16, Responses.AuthSuccess.decoder, Responses.AuthSuccess.decoder);
            public final int opcode;
            private final Decoder<?> decoderV1;
            private final Decoder<?> decoderV2;
            private static final Type[] opcodeIdx;
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String name) {
                return Enum.valueOf(Type.class, name);
            }

            private Type(int opcode, Decoder<?> decoderV1, Decoder<?> decoderV2) {
                this.opcode = opcode;
                this.decoderV1 = decoderV1;
                this.decoderV2 = decoderV2;
            }

            public static Type fromOpcode(int opcode) {
                Type t = opcodeIdx[opcode];
                if (t == null) {
                    throw new DriverInternalError(String.format("Unknown response opcode %d", opcode));
                }
                return t;
            }

            public Decoder<?> decoder(int version) {
                assert (version == 1 || version == 2) : "Unsupported protocol version, we shouldn't have arrived here";
                return version == 1 ? this.decoderV1 : this.decoderV2;
            }

            static {
                $VALUES = new Type[]{ERROR, READY, AUTHENTICATE, SUPPORTED, RESULT, EVENT, AUTH_CHALLENGE, AUTH_SUCCESS};
                int maxOpcode = -1;
                for (Type type : Type.values()) {
                    maxOpcode = Math.max(maxOpcode, type.opcode);
                }
                opcodeIdx = new Type[maxOpcode + 1];
                for (Type type : Type.values()) {
                    if (opcodeIdx[type.opcode] != null) {
                        throw new IllegalStateException("Duplicate opcode");
                    }
                    Type.opcodeIdx[type.opcode] = type;
                }
            }
        }
    }

    public static abstract class Request
    extends Message {
        public final Type type;
        private final boolean tracingRequested;

        protected Request(Type type) {
            this(type, false);
        }

        protected Request(Type type, boolean tracingRequested) {
            this.type = type;
            this.tracingRequested = tracingRequested;
        }

        @Override
        public Request setStreamId(int streamId) {
            if (this.getStreamId() < 0) {
                return (Request)super.setStreamId(streamId);
            }
            Request copy = this.copy();
            copy.setStreamId(streamId);
            return copy;
        }

        public boolean isTracingRequested() {
            return this.tracingRequested;
        }

        ConsistencyLevel consistency() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.consistency;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.consistency;
                }
                case BATCH: {
                    return ((Requests.Batch)this).consistency;
                }
            }
            return null;
        }

        ConsistencyLevel serialConsistency() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.serialConsistency;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.serialConsistency;
                }
            }
            return null;
        }

        ByteBuffer pagingState() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.pagingState;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.pagingState;
                }
            }
            return null;
        }

        abstract Request copy();

        Request copy(ConsistencyLevel newConsistencyLevel) {
            throw new UnsupportedOperationException();
        }

        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type STARTUP = new Type(1, Requests.Startup.coder, Requests.Startup.coder);
            public static final /* enum */ Type CREDENTIALS = new Type(4, Requests.Credentials.coder, null);
            public static final /* enum */ Type OPTIONS = new Type(5, Requests.Options.coder, Requests.Options.coder);
            public static final /* enum */ Type QUERY = new Type(7, Requests.Query.coderV1, Requests.Query.coderV2);
            public static final /* enum */ Type PREPARE = new Type(9, Requests.Prepare.coder, Requests.Prepare.coder);
            public static final /* enum */ Type EXECUTE = new Type(10, Requests.Execute.coderV1, Requests.Execute.coderV2);
            public static final /* enum */ Type REGISTER = new Type(11, Requests.Register.coder, Requests.Register.coder);
            public static final /* enum */ Type BATCH = new Type(13, null, Requests.Batch.coder);
            public static final /* enum */ Type AUTH_RESPONSE = new Type(15, Requests.AuthResponse.coder, Requests.AuthResponse.coder);
            public final int opcode;
            private final Coder<?> coderV1;
            private final Coder<?> coderV2;
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String name) {
                return Enum.valueOf(Type.class, name);
            }

            private Type(int opcode, Coder<?> coderV1, Coder<?> coderV2) {
                this.opcode = opcode;
                this.coderV1 = coderV1;
                this.coderV2 = coderV2;
            }

            public Coder<?> coder(int version) {
                assert (version == 1 || version == 2) : "Unsupported protocol version, we shouldn't have arrived here";
                return version == 1 ? this.coderV1 : this.coderV2;
            }

            static {
                $VALUES = new Type[]{STARTUP, CREDENTIALS, OPTIONS, QUERY, PREPARE, EXECUTE, REGISTER, BATCH, AUTH_RESPONSE};
            }
        }
    }

    public static interface Decoder<R extends Response> {
        public R decode(ByteBuf var1);
    }

    public static interface Coder<R extends Request> {
        public void encode(R var1, ByteBuf var2);

        public int encodedSize(R var1);
    }
}

