/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Using;
import com.datastax.driver.core.querybuilder.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Insert
extends BuiltStatement {
    private final String table;
    private final List<Object> names = new ArrayList<Object>();
    private final List<Object> values = new ArrayList<Object>();
    private final Options usings;
    private boolean ifNotExists;

    Insert(String keyspace, String table) {
        super(keyspace);
        this.table = table;
        this.usings = new Options(this);
    }

    Insert(TableMetadata table) {
        super(table);
        this.table = this.escapeId(table.getName());
        this.usings = new Options(this);
    }

    @Override
    StringBuilder buildQueryString(List<Object> variables) {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append('.');
        }
        Utils.appendName(this.table, builder);
        builder.append('(');
        Utils.joinAndAppendNames(builder, ",", this.names);
        builder.append(") VALUES (");
        Utils.joinAndAppendValues(builder, ",", this.values, variables);
        builder.append(')');
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        if (!this.usings.usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(builder, " AND ", this.usings.usings, variables);
        }
        return builder;
    }

    public Insert value(String name, Object value) {
        this.names.add(name);
        this.values.add(value);
        this.checkForBindMarkers(value);
        if (!this.hasNonIdempotentOps() && !Utils.isIdempotent(value)) {
            this.setNonIdempotentOps();
        }
        this.maybeAddRoutingKey(name, value);
        return this;
    }

    public Insert values(String[] names, Object[] values) {
        return this.values(Arrays.asList(names), Arrays.asList(values));
    }

    public Insert values(List<String> names, List<Object> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException(String.format("Got %d names but %d values", names.size(), values.size()));
        }
        this.names.addAll(names);
        this.values.addAll(values);
        for (int i = 0; i < names.size(); ++i) {
            Object value = values.get(i);
            this.checkForBindMarkers(value);
            this.maybeAddRoutingKey(names.get(i), value);
            if (this.hasNonIdempotentOps() || Utils.isIdempotent(value)) continue;
            this.setNonIdempotentOps();
        }
        return this;
    }

    public Options using(Using using) {
        return this.usings.and(using);
    }

    public Insert ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    public static class Options
    extends BuiltStatement.ForwardingStatement<Insert> {
        private final List<Using> usings = new ArrayList<Using>();

        Options(Insert st) {
            super(st);
        }

        public Options and(Using using) {
            this.usings.add(using);
            this.checkForBindMarkers(using);
            return this;
        }

        public Insert value(String name, Object value) {
            return ((Insert)this.statement).value(name, value);
        }

        public Insert values(String[] names, Object[] values) {
            return ((Insert)this.statement).values(names, values);
        }
    }
}

