/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ArrayBackedRow;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DriverThrowables;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.utils.MoreFutures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ArrayBackedResultSet
implements ResultSet {
    private static final Logger logger = LoggerFactory.getLogger(ResultSet.class);
    private static final Queue<List<ByteBuffer>> EMPTY_QUEUE = new ArrayDeque<List<ByteBuffer>>(0);
    protected final ColumnDefinitions metadata;
    protected final Token.Factory tokenFactory;
    private final boolean wasApplied;

    private ArrayBackedResultSet(ColumnDefinitions metadata, Token.Factory tokenFactory, List<ByteBuffer> firstRow) {
        this.metadata = metadata;
        this.tokenFactory = tokenFactory;
        this.wasApplied = ArrayBackedResultSet.checkWasApplied(firstRow, metadata);
    }

    static ArrayBackedResultSet fromMessage(Responses.Result msg, SessionManager session, ExecutionInfo info, Statement statement) {
        info = ArrayBackedResultSet.update(info, msg, session);
        switch (msg.kind) {
            case VOID: {
                return ArrayBackedResultSet.empty(info);
            }
            case ROWS: {
                Token.Factory tokenFactory;
                ColumnDefinitions columnDefs;
                Responses.Result.Rows r = (Responses.Result.Rows)msg;
                if (r.metadata.columns == null) {
                    assert (statement instanceof BoundStatement);
                    columnDefs = ((BoundStatement)statement).statement.getPreparedId().resultSetMetadata;
                    assert (columnDefs != null);
                } else {
                    columnDefs = r.metadata.columns;
                }
                Token.Factory factory = tokenFactory = session == null ? null : session.getCluster().manager.metadata.tokenFactory();
                assert (r.metadata.pagingState == null || info != null);
                return r.metadata.pagingState == null ? new SinglePage(columnDefs, tokenFactory, r.data, info) : new MultiPage(columnDefs, tokenFactory, r.data, info, r.metadata.pagingState, session, statement);
            }
            case SET_KEYSPACE: 
            case SCHEMA_CHANGE: {
                return ArrayBackedResultSet.empty(info);
            }
            case PREPARED: {
                throw new RuntimeException("Prepared statement received when a ResultSet was expected");
            }
        }
        logger.error("Received unknown result type '{}'; returning empty result set", (Object)msg.kind);
        return ArrayBackedResultSet.empty(info);
    }

    private static ExecutionInfo update(ExecutionInfo info, Responses.Result msg, SessionManager session) {
        UUID tracingId = msg.getTracingId();
        return tracingId == null || info == null ? info : info.withTrace(new QueryTrace(tracingId, session));
    }

    private static ArrayBackedResultSet empty(ExecutionInfo info) {
        return new SinglePage(ColumnDefinitions.EMPTY, null, EMPTY_QUEUE, info);
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.metadata;
    }

    @Override
    public List<Row> all() {
        if (this.isExhausted()) {
            return Collections.emptyList();
        }
        ArrayList<Row> result = new ArrayList<Row>(this.getAvailableWithoutFetching());
        for (Row row : this) {
            result.add(row);
        }
        return result;
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return !ArrayBackedResultSet.this.isExhausted();
            }

            @Override
            public Row next() {
                return ArrayBackedResultSet.this.one();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean wasApplied() {
        return this.wasApplied;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResultSet[ exhausted: ").append(this.isExhausted());
        sb.append(", ").append(this.metadata).append(']');
        return sb.toString();
    }

    private static boolean checkWasApplied(List<ByteBuffer> firstRow, ColumnDefinitions metadata) {
        if (firstRow == null) {
            return true;
        }
        int[] is = metadata.findAllIdx("[applied]");
        if (is == null) {
            return true;
        }
        int i = is[0];
        if (!DataType.cboolean().equals(metadata.getType(i))) {
            return true;
        }
        ByteBuffer value = firstRow.get(i);
        if (value == null || value.remaining() == 0) {
            return false;
        }
        return TypeCodec.BooleanCodec.instance.deserializeNoBoxing(value);
    }

    private static class MultiPage
    extends ArrayBackedResultSet {
        private Queue<List<ByteBuffer>> currentPage;
        private final Queue<Queue<List<ByteBuffer>>> nextPages = new ConcurrentLinkedQueue<Queue<List<ByteBuffer>>>();
        private final Deque<ExecutionInfo> infos = new LinkedBlockingDeque<ExecutionInfo>();
        private volatile FetchingState fetchState;
        private final SessionManager session;
        private final Statement statement;

        private MultiPage(ColumnDefinitions metadata, Token.Factory tokenFactory, Queue<List<ByteBuffer>> rows, ExecutionInfo info, ByteBuffer pagingState, SessionManager session, Statement statement) {
            super(metadata, tokenFactory, rows.peek());
            this.currentPage = rows;
            this.infos.offer(info.withPagingState(pagingState).withStatement(statement));
            this.fetchState = new FetchingState(pagingState, null);
            this.session = session;
            this.statement = statement;
        }

        @Override
        public boolean isExhausted() {
            this.prepareNextRow();
            return this.currentPage.isEmpty();
        }

        @Override
        public Row one() {
            this.prepareNextRow();
            return ArrayBackedRow.fromData(this.metadata, this.tokenFactory, this.currentPage.poll());
        }

        @Override
        public int getAvailableWithoutFetching() {
            int available = this.currentPage.size();
            for (Queue queue : this.nextPages) {
                available += queue.size();
            }
            return available;
        }

        @Override
        public boolean isFullyFetched() {
            return this.fetchState == null;
        }

        private void prepareNextRow() {
            while (this.currentPage.isEmpty()) {
                FetchingState fetchingState = this.fetchState;
                Queue<List<ByteBuffer>> nextPage = this.nextPages.poll();
                if (nextPage != null) {
                    this.currentPage = nextPage;
                    continue;
                }
                if (fetchingState == null) {
                    return;
                }
                try {
                    Uninterruptibles.getUninterruptibly(this.fetchMoreResults());
                }
                catch (ExecutionException e) {
                    throw DriverThrowables.propagateCause(e);
                }
            }
        }

        @Override
        public ListenableFuture<Void> fetchMoreResults() {
            return this.fetchMoreResults(this.fetchState);
        }

        private ListenableFuture<Void> fetchMoreResults(FetchingState fetchState) {
            if (fetchState == null) {
                return MoreFutures.VOID_SUCCESS;
            }
            if (fetchState.inProgress != null) {
                return fetchState.inProgress;
            }
            assert (fetchState.nextStart != null);
            ByteBuffer state = fetchState.nextStart;
            SettableFuture future = SettableFuture.create();
            this.fetchState = new FetchingState(null, (ListenableFuture<Void>)future);
            return this.queryNextPage(state, (SettableFuture<Void>)future);
        }

        private ListenableFuture<Void> queryNextPage(ByteBuffer nextStart, final SettableFuture<Void> future) {
            assert (!(this.statement instanceof BatchStatement));
            final Message.Request request = this.session.makeRequestMessage(this.statement, nextStart);
            this.session.execute(new RequestHandler.Callback(){

                @Override
                public Message.Request request() {
                    return request;
                }

                @Override
                public void register(RequestHandler handler) {
                }

                @Override
                public void onSet(Connection connection, Message.Response response, ExecutionInfo info, Statement statement, long latency) {
                    try {
                        switch (response.type) {
                            case RESULT: {
                                Responses.Result rm = (Responses.Result)response;
                                info = ArrayBackedResultSet.update(info, rm, MultiPage.this.session);
                                if (rm.kind == Responses.Result.Kind.ROWS) {
                                    Responses.Result.Rows rows = (Responses.Result.Rows)rm;
                                    if (rows.metadata.pagingState != null) {
                                        info = info.withPagingState(rows.metadata.pagingState).withStatement(statement);
                                    }
                                    MultiPage.this.nextPages.offer(rows.data);
                                    MultiPage.this.fetchState = rows.metadata.pagingState == null ? null : new FetchingState(rows.metadata.pagingState, null);
                                } else if (rm.kind == Responses.Result.Kind.VOID) {
                                    MultiPage.this.fetchState = null;
                                } else {
                                    logger.error("Received unknown result type '{}' during paging: ignoring message", (Object)rm.kind);
                                    connection.defunct(new ConnectionException(connection.address, String.format("Got unexpected %s result response", new Object[]{rm.kind})));
                                    future.setException((Throwable)new DriverInternalError(String.format("Got unexpected %s result response from %s", new Object[]{rm.kind, connection.address})));
                                    return;
                                }
                                MultiPage.this.infos.offer(info);
                                future.set(null);
                                break;
                            }
                            case ERROR: {
                                future.setException((Throwable)((Responses.Error)response).asException(connection.address));
                                break;
                            }
                            default: {
                                connection.defunct(new ConnectionException(connection.address, String.format("Got unexpected %s response", new Object[]{response.type})));
                                future.setException((Throwable)new DriverInternalError(String.format("Got unexpected %s response from %s", new Object[]{response.type, connection.address})));
                                break;
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        future.setException((Throwable)new DriverInternalError("Unexpected error while processing response from " + connection.address, e));
                    }
                }

                @Override
                public void onSet(Connection connection, Message.Response response, long latency, int retryCount) {
                    this.onSet(connection, response, null, null, latency);
                }

                @Override
                public void onException(Connection connection, Exception exception, long latency, int retryCount) {
                    future.setException((Throwable)exception);
                }

                @Override
                public boolean onTimeout(Connection connection, long latency, int retryCount) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int retryCount() {
                    return 0;
                }
            }, this.statement);
            return future;
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.infos.getLast();
        }

        @Override
        public List<ExecutionInfo> getAllExecutionInfo() {
            return new ArrayList<ExecutionInfo>(this.infos);
        }

        private static class FetchingState {
            public final ByteBuffer nextStart;
            public final ListenableFuture<Void> inProgress;

            FetchingState(ByteBuffer nextStart, ListenableFuture<Void> inProgress) {
                assert (nextStart == null != (inProgress == null));
                this.nextStart = nextStart;
                this.inProgress = inProgress;
            }
        }
    }

    private static class SinglePage
    extends ArrayBackedResultSet {
        private final Queue<List<ByteBuffer>> rows;
        private final ExecutionInfo info;

        private SinglePage(ColumnDefinitions metadata, Token.Factory tokenFactory, Queue<List<ByteBuffer>> rows, ExecutionInfo info) {
            super(metadata, tokenFactory, rows.peek());
            this.info = info;
            this.rows = rows;
        }

        @Override
        public boolean isExhausted() {
            return this.rows.isEmpty();
        }

        @Override
        public Row one() {
            return ArrayBackedRow.fromData(this.metadata, this.tokenFactory, this.rows.poll());
        }

        @Override
        public int getAvailableWithoutFetching() {
            return this.rows.size();
        }

        @Override
        public boolean isFullyFetched() {
            return true;
        }

        @Override
        public ListenableFuture<Void> fetchMoreResults() {
            return MoreFutures.VOID_SUCCESS;
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.info;
        }

        @Override
        public List<ExecutionInfo> getAllExecutionInfo() {
            return Collections.singletonList(this.info);
        }
    }
}

