/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;

public class QueryOptions {
    public static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.ONE;
    public static final ConsistencyLevel DEFAULT_SERIAL_CONSISTENCY_LEVEL = ConsistencyLevel.SERIAL;
    public static final int DEFAULT_FETCH_SIZE = 5000;
    public static final boolean DEFAULT_IDEMPOTENCE = false;
    private volatile ConsistencyLevel consistency = DEFAULT_CONSISTENCY_LEVEL;
    private volatile ConsistencyLevel serialConsistency = DEFAULT_SERIAL_CONSISTENCY_LEVEL;
    private volatile int fetchSize = 5000;
    private volatile boolean defaultIdempotence = false;
    private volatile Cluster.Manager manager;

    void register(Cluster.Manager manager) {
        this.manager = manager;
    }

    public QueryOptions setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistency = consistencyLevel;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public QueryOptions setSerialConsistencyLevel(ConsistencyLevel serialConsistencyLevel) {
        this.serialConsistency = serialConsistencyLevel;
        return this;
    }

    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistency;
    }

    public QueryOptions setFetchSize(int fetchSize) {
        int version;
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("Invalid fetchSize, should be > 0, got " + fetchSize);
        }
        int n = version = this.manager == null ? -1 : this.manager.protocolVersion();
        if (fetchSize != Integer.MAX_VALUE && version == 1) {
            throw new UnsupportedFeatureException("Paging is not supported");
        }
        this.fetchSize = fetchSize;
        return this;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public QueryOptions setDefaultIdempotence(boolean defaultIdempotence) {
        this.defaultIdempotence = defaultIdempotence;
        return this;
    }

    public boolean getDefaultIdempotence() {
        return this.defaultIdempotence;
    }
}

