/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.utils.Bytes;
import java.nio.ByteBuffer;
import java.util.List;

public class ExecutionInfo {
    private final List<Host> triedHosts;
    private final ConsistencyLevel achievedConsistency;
    private final QueryTrace trace;
    private final ByteBuffer pagingState;
    private final Statement statement;
    private volatile boolean schemaInAgreement;

    private ExecutionInfo(List<Host> triedHosts, ConsistencyLevel achievedConsistency, QueryTrace trace, ByteBuffer pagingState, Statement statement, boolean schemaAgreement) {
        this.triedHosts = triedHosts;
        this.achievedConsistency = achievedConsistency;
        this.trace = trace;
        this.pagingState = pagingState;
        this.statement = statement;
        this.schemaInAgreement = schemaAgreement;
    }

    ExecutionInfo(List<Host> triedHosts) {
        this(triedHosts, null, null, null, null, true);
    }

    ExecutionInfo withTrace(QueryTrace newTrace) {
        return new ExecutionInfo(this.triedHosts, this.achievedConsistency, newTrace, this.pagingState, this.statement, this.schemaInAgreement);
    }

    ExecutionInfo withAchievedConsistency(ConsistencyLevel newConsistency) {
        return new ExecutionInfo(this.triedHosts, newConsistency, this.trace, this.pagingState, this.statement, this.schemaInAgreement);
    }

    ExecutionInfo withPagingState(ByteBuffer pagingState) {
        return new ExecutionInfo(this.triedHosts, this.achievedConsistency, this.trace, pagingState, this.statement, this.schemaInAgreement);
    }

    ExecutionInfo withStatement(Statement statement) {
        return new ExecutionInfo(this.triedHosts, this.achievedConsistency, this.trace, this.pagingState, statement, this.schemaInAgreement);
    }

    public List<Host> getTriedHosts() {
        return this.triedHosts;
    }

    public Host getQueriedHost() {
        return this.triedHosts.get(this.triedHosts.size() - 1);
    }

    public ConsistencyLevel getAchievedConsistencyLevel() {
        return this.achievedConsistency;
    }

    public QueryTrace getQueryTrace() {
        return this.trace;
    }

    public PagingState getPagingState() {
        if (this.pagingState == null) {
            return null;
        }
        return new PagingState(this.pagingState, this.statement);
    }

    public byte[] getPagingStateUnsafe() {
        if (this.pagingState == null) {
            return null;
        }
        return Bytes.getArray(this.pagingState);
    }

    public boolean isSchemaInAgreement() {
        return this.schemaInAgreement;
    }

    void setSchemaInAgreement(boolean schemaAgreement) {
        this.schemaInAgreement = schemaAgreement;
    }
}

