/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DefaultPreparedStatement;
import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.PooledConnection;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UnsupportedProtocolVersionException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionManager
implements Session {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    final Cluster cluster;
    final ConcurrentMap<Host, HostConnectionPool> pools;
    final HostConnectionPool.PoolState poolsState;
    final AtomicReference<CloseFuture> closeFuture = new AtomicReference();
    private volatile boolean isInit;

    SessionManager(Cluster cluster) {
        this.cluster = cluster;
        this.pools = new ConcurrentHashMap<Host, HostConnectionPool>();
        this.poolsState = new HostConnectionPool.PoolState();
    }

    @Override
    public synchronized Session init() {
        if (this.isInit) {
            return this;
        }
        this.cluster.init();
        for (Host host : this.cluster.getMetadata().allHosts()) {
            try {
                this.addOrRenewPool(host, false).get();
            }
            catch (ExecutionException e) {
                throw new DriverInternalError(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.isInit = true;
        return this;
    }

    @Override
    public String getLoggedKeyspace() {
        return this.poolsState.keyspace;
    }

    @Override
    public ResultSet execute(String query) {
        return this.execute(new SimpleStatement(query));
    }

    @Override
    public ResultSet execute(String query, Object ... values) {
        return this.execute(new SimpleStatement(query, values));
    }

    @Override
    public ResultSet execute(Statement statement) {
        return this.executeAsync(statement).getUninterruptibly();
    }

    @Override
    public ResultSetFuture executeAsync(String query) {
        return this.executeAsync(new SimpleStatement(query));
    }

    @Override
    public ResultSetFuture executeAsync(String query, Object ... values) {
        return this.executeAsync(new SimpleStatement(query, values));
    }

    @Override
    public ResultSetFuture executeAsync(Statement statement) {
        return this.executeQuery(this.makeRequestMessage(statement, null), statement);
    }

    @Override
    public PreparedStatement prepare(String query) {
        try {
            return (PreparedStatement)Uninterruptibles.getUninterruptibly(this.prepareAsync(query));
        }
        catch (ExecutionException e) {
            throw DefaultResultSetFuture.extractCauseFromExecutionException(e);
        }
    }

    @Override
    public PreparedStatement prepare(RegularStatement statement) {
        try {
            return (PreparedStatement)Uninterruptibles.getUninterruptibly(this.prepareAsync(statement));
        }
        catch (ExecutionException e) {
            throw DefaultResultSetFuture.extractCauseFromExecutionException(e);
        }
    }

    @Override
    public ListenableFuture<PreparedStatement> prepareAsync(String query) {
        Connection.Future future = new Connection.Future(new Requests.Prepare(query));
        this.execute(future, Statement.DEFAULT);
        return this.toPreparedStatement(query, future);
    }

    @Override
    public ListenableFuture<PreparedStatement> prepareAsync(final RegularStatement statement) {
        if (statement.getValues() != null) {
            throw new IllegalArgumentException("A statement to prepare should not have values");
        }
        ListenableFuture<PreparedStatement> prepared = this.prepareAsync(statement.toString());
        return Futures.transform(prepared, (Function)new Function<PreparedStatement, PreparedStatement>(){

            public PreparedStatement apply(PreparedStatement prepared) {
                ByteBuffer routingKey = statement.getRoutingKey();
                if (routingKey != null) {
                    prepared.setRoutingKey(routingKey);
                }
                prepared.setConsistencyLevel(statement.getConsistencyLevel());
                if (statement.isTracing()) {
                    prepared.enableTracing();
                }
                prepared.setRetryPolicy(statement.getRetryPolicy());
                return prepared;
            }
        });
    }

    @Override
    public CloseFuture closeAsync() {
        CloseFuture future = this.closeFuture.get();
        if (future != null) {
            return future;
        }
        ArrayList<CloseFuture> futures = new ArrayList<CloseFuture>(this.pools.size());
        for (HostConnectionPool pool : this.pools.values()) {
            futures.add(pool.closeAsync());
        }
        future = new CloseFuture.Forwarding(futures);
        return this.closeFuture.compareAndSet(null, future) ? future : this.closeFuture.get();
    }

    @Override
    public boolean isClosed() {
        return this.closeFuture.get() != null;
    }

    @Override
    public void close() {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            throw DefaultResultSetFuture.extractCauseFromExecutionException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    private ListenableFuture<PreparedStatement> toPreparedStatement(final String query, final Connection.Future future) {
        return Futures.transform((ListenableFuture)future, (Function)new Function<Message.Response, PreparedStatement>(){

            public PreparedStatement apply(Message.Response response) {
                switch (response.type) {
                    case RESULT: {
                        Responses.Result rm = (Responses.Result)response;
                        switch (rm.kind) {
                            case PREPARED: {
                                Responses.Result.Prepared pmsg = (Responses.Result.Prepared)rm;
                                PreparedStatement stmt = DefaultPreparedStatement.fromMessage(pmsg, SessionManager.this.cluster.getMetadata(), query, SessionManager.this.poolsState.keyspace);
                                stmt = SessionManager.this.cluster.manager.addPrepared(stmt);
                                try {
                                    SessionManager.this.prepare(stmt.getQueryString(), future.getAddress());
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                }
                                return stmt;
                            }
                        }
                        throw new DriverInternalError(String.format("%s response received when prepared statement was expected", new Object[]{rm.kind}));
                    }
                    case ERROR: {
                        throw ((Responses.Error)response).asException(future.getAddress());
                    }
                }
                throw new DriverInternalError(String.format("%s response received when prepared statement was expected", new Object[]{response.type}));
            }
        }, (Executor)this.executor());
    }

    Connection.Factory connectionFactory() {
        return this.cluster.manager.connectionFactory;
    }

    Configuration configuration() {
        return this.cluster.manager.configuration;
    }

    LoadBalancingPolicy loadBalancingPolicy() {
        return this.cluster.manager.loadBalancingPolicy();
    }

    ReconnectionPolicy reconnectionPolicy() {
        return this.cluster.manager.reconnectionPolicy();
    }

    ListeningExecutorService executor() {
        return this.cluster.manager.executor;
    }

    ListeningExecutorService blockingExecutor() {
        return this.cluster.manager.blockingTasksExecutor;
    }

    ListenableFuture<Boolean> addOrRenewPool(final Host host, final boolean isHostAddition) {
        final HostDistance distance = this.cluster.manager.loadBalancingPolicy().distance(host);
        if (distance == HostDistance.IGNORED) {
            return Futures.immediateFuture((Object)true);
        }
        return this.executor().submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                logger.debug("Adding {} to list of queried hosts", (Object)host);
                try {
                    HostConnectionPool previous = SessionManager.this.pools.put(host, new HostConnectionPool(host, distance, SessionManager.this));
                    if (previous != null) {
                        previous.closeAsync();
                    }
                    return true;
                }
                catch (AuthenticationException e) {
                    logger.error("Error creating pool to {} ({})", (Object)host, (Object)e.getMessage());
                    SessionManager.this.cluster.manager.signalConnectionFailure(host, new ConnectionException(e.getHost(), e.getMessage()), isHostAddition);
                    return false;
                }
                catch (UnsupportedProtocolVersionException e) {
                    logger.error("Error creating pool to {} ({})", (Object)host, (Object)e.getMessage());
                    SessionManager.this.cluster.manager.signalConnectionFailure(host, new ConnectionException(e.address, e.getMessage()), isHostAddition);
                    return false;
                }
                catch (ConnectionException e) {
                    logger.debug("Error creating pool to {} ({})", (Object)host, (Object)e.getMessage());
                    SessionManager.this.cluster.manager.signalConnectionFailure(host, e, isHostAddition);
                    return false;
                }
            }
        });
    }

    ListenableFuture<?> removePool(Host host) {
        final HostConnectionPool pool = (HostConnectionPool)this.pools.remove(host);
        if (pool == null) {
            return Futures.immediateFuture(null);
        }
        return this.executor().submit(new Runnable(){

            @Override
            public void run() {
                pool.closeAsync();
            }
        });
    }

    void updateCreatedPools() {
        for (Host h : this.cluster.getMetadata().allHosts()) {
            HostDistance dist = this.loadBalancingPolicy().distance(h);
            HostConnectionPool pool = (HostConnectionPool)this.pools.get(h);
            if (pool == null) {
                if (dist == HostDistance.IGNORED || !h.isUp()) continue;
                this.addOrRenewPool(h, false);
                continue;
            }
            if (dist == pool.hostDistance) continue;
            if (dist == HostDistance.IGNORED) {
                this.removePool(h);
                continue;
            }
            pool.hostDistance = dist;
        }
    }

    void onDown(Host host) {
        this.removePool(host).addListener(new Runnable(){

            @Override
            public void run() {
                SessionManager.this.updateCreatedPools();
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
    }

    void onRemove(Host host) {
        this.onDown(host);
    }

    void setKeyspace(String keyspace) {
        long timeout = this.configuration().getSocketOptions().getConnectTimeoutMillis();
        try {
            ResultSetFuture future = this.executeQuery(new Requests.Query("use " + keyspace), Statement.DEFAULT);
            Uninterruptibles.getUninterruptibly((Future)((Object)future), (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new DriverInternalError(String.format("No responses after %d milliseconds while setting current keyspace. This should not happen, unless you have setup a very low connection timeout.", timeout));
        }
        catch (ExecutionException e) {
            throw DefaultResultSetFuture.extractCauseFromExecutionException(e);
        }
    }

    Message.Request makeRequestMessage(Statement statement, ByteBuffer pagingState) {
        ConsistencyLevel serialConsistency;
        ConsistencyLevel consistency = statement.getConsistencyLevel();
        if (consistency == null) {
            consistency = this.configuration().getQueryOptions().getConsistencyLevel();
        }
        if ((serialConsistency = statement.getSerialConsistencyLevel()) == null) {
            serialConsistency = this.configuration().getQueryOptions().getSerialConsistencyLevel();
        }
        return this.makeRequestMessage(statement, consistency, serialConsistency, pagingState);
    }

    Message.Request makeRequestMessage(Statement statement, ConsistencyLevel cl, ConsistencyLevel scl, ByteBuffer pagingState) {
        int protoVersion = this.cluster.manager.protocolVersion();
        int fetchSize = statement.getFetchSize();
        if (protoVersion == 1) {
            assert (pagingState == null);
            if (fetchSize <= 0) {
                fetchSize = -1;
            } else if (fetchSize != Integer.MAX_VALUE) {
                throw new UnsupportedFeatureException("Paging is not supported");
            }
        } else if (fetchSize <= 0) {
            fetchSize = this.configuration().getQueryOptions().getFetchSize();
        }
        if (fetchSize == Integer.MAX_VALUE) {
            fetchSize = -1;
        }
        if (statement instanceof RegularStatement) {
            RegularStatement rs = (RegularStatement)statement;
            if (protoVersion == 1 && rs instanceof BuiltStatement) {
                ((BuiltStatement)rs).setForceNoValues(true);
            }
            ByteBuffer[] rawValues = rs.getValues();
            if (protoVersion == 1 && rawValues != null) {
                throw new UnsupportedFeatureException("Binary values are not supported");
            }
            List<ByteBuffer> values = rawValues == null ? Collections.emptyList() : Arrays.asList(rawValues);
            String qString = rs.getQueryString();
            Requests.QueryProtocolOptions options = new Requests.QueryProtocolOptions(cl, values, false, fetchSize, pagingState, scl);
            return new Requests.Query(qString, options);
        }
        if (statement instanceof BoundStatement) {
            BoundStatement bs = (BoundStatement)statement;
            boolean skipMetadata = protoVersion != 1 && bs.statement.getPreparedId().resultSetMetadata != null;
            Requests.QueryProtocolOptions options = new Requests.QueryProtocolOptions(cl, Arrays.asList(bs.values), skipMetadata, fetchSize, pagingState, scl);
            return new Requests.Execute(bs.statement.getPreparedId().id, options);
        }
        assert (statement instanceof BatchStatement) : statement;
        assert (pagingState == null);
        if (protoVersion == 1) {
            throw new UnsupportedFeatureException("Protocol level batching is not supported");
        }
        BatchStatement bs = (BatchStatement)statement;
        BatchStatement.IdAndValues idAndVals = bs.getIdAndValues();
        return new Requests.Batch(bs.batchType, idAndVals.ids, idAndVals.values, cl);
    }

    void execute(RequestHandler.Callback callback, Statement statement) {
        if (!this.isInit) {
            this.init();
        }
        new RequestHandler(this, callback, statement).sendRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepare(String query, InetAddress toExclude) throws InterruptedException {
        Iterator i$ = this.pools.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry = i$.next();
            if (((Host)entry.getKey()).getAddress().equals(toExclude)) continue;
            PooledConnection c = null;
            try {
                c = ((HostConnectionPool)entry.getValue()).borrowConnection(200L, TimeUnit.MILLISECONDS);
                c.write(new Requests.Prepare(query)).get();
                continue;
            }
            catch (ConnectionException e) {
                continue;
            }
            catch (BusyConnectionException e) {
                continue;
            }
            catch (TimeoutException e) {
                continue;
            }
            catch (ExecutionException e) {
                logger.error(String.format("Unexpected error while preparing query (%s) on %s", query, entry.getKey()), (Throwable)e);
                continue;
            }
            finally {
                if (c == null) continue;
                c.release();
                continue;
            }
            break;
        }
        return;
    }

    ResultSetFuture executeQuery(Message.Request msg, Statement statement) {
        if (statement.isTracing()) {
            msg.setTracingRequested();
        }
        DefaultResultSetFuture future = new DefaultResultSetFuture(this, msg);
        this.execute(future, statement);
        return future;
    }
}

