/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.policies.RetryPolicy;
import java.nio.ByteBuffer;

public abstract class Statement {
    static final Statement DEFAULT = new Statement(){

        @Override
        public ByteBuffer getRoutingKey() {
            return null;
        }

        @Override
        public String getKeyspace() {
            return null;
        }
    };
    private volatile ConsistencyLevel consistency;
    private volatile ConsistencyLevel serialConsistency;
    private volatile boolean traceQuery;
    private volatile int fetchSize;
    private volatile RetryPolicy retryPolicy;

    Statement() {
    }

    public Statement setConsistencyLevel(ConsistencyLevel consistency) {
        this.consistency = consistency;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public Statement setSerialConsistencyLevel(ConsistencyLevel serialConsistency) {
        if (serialConsistency != ConsistencyLevel.SERIAL && serialConsistency != ConsistencyLevel.LOCAL_SERIAL) {
            throw new IllegalArgumentException();
        }
        this.serialConsistency = serialConsistency;
        return this;
    }

    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistency;
    }

    public Statement enableTracing() {
        this.traceQuery = true;
        return this;
    }

    public Statement disableTracing() {
        this.traceQuery = false;
        return this;
    }

    public boolean isTracing() {
        return this.traceQuery;
    }

    public abstract ByteBuffer getRoutingKey();

    public abstract String getKeyspace();

    public Statement setRetryPolicy(RetryPolicy policy) {
        this.retryPolicy = policy;
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public Statement setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }
}

